/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.DomainValidationRecord;
import software.amazon.awssdk.services.lightsail.model.DomainValidationRecordListCopier;
import software.amazon.awssdk.services.lightsail.model.RenewalStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RenewalSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RenewalSummary> {
    private static final SdkField<List<DomainValidationRecord>> DOMAIN_VALIDATION_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("domainValidationRecords").getter(RenewalSummary.getter(RenewalSummary::domainValidationRecords)).setter(RenewalSummary.setter(Builder::domainValidationRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainValidationRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainValidationRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RENEWAL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("renewalStatus").getter(RenewalSummary.getter(RenewalSummary::renewalStatusAsString)).setter(RenewalSummary.setter(Builder::renewalStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renewalStatus").build()}).build();
    private static final SdkField<String> RENEWAL_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("renewalStatusReason").getter(RenewalSummary.getter(RenewalSummary::renewalStatusReason)).setter(RenewalSummary.setter(Builder::renewalStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renewalStatusReason").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(RenewalSummary.getter(RenewalSummary::updatedAt)).setter(RenewalSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_VALIDATION_RECORDS_FIELD, RENEWAL_STATUS_FIELD, RENEWAL_STATUS_REASON_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<DomainValidationRecord> domainValidationRecords;
    private final String renewalStatus;
    private final String renewalStatusReason;
    private final Instant updatedAt;

    private RenewalSummary(BuilderImpl builder) {
        this.domainValidationRecords = builder.domainValidationRecords;
        this.renewalStatus = builder.renewalStatus;
        this.renewalStatusReason = builder.renewalStatusReason;
        this.updatedAt = builder.updatedAt;
    }

    public final boolean hasDomainValidationRecords() {
        return this.domainValidationRecords != null && !(this.domainValidationRecords instanceof SdkAutoConstructList);
    }

    public final List<DomainValidationRecord> domainValidationRecords() {
        return this.domainValidationRecords;
    }

    public final RenewalStatus renewalStatus() {
        return RenewalStatus.fromValue(this.renewalStatus);
    }

    public final String renewalStatusAsString() {
        return this.renewalStatus;
    }

    public final String renewalStatusReason() {
        return this.renewalStatusReason;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainValidationRecords() ? this.domainValidationRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.renewalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.renewalStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenewalSummary)) {
            return false;
        }
        RenewalSummary other = (RenewalSummary)obj;
        return this.hasDomainValidationRecords() == other.hasDomainValidationRecords() && Objects.equals(this.domainValidationRecords(), other.domainValidationRecords()) && Objects.equals(this.renewalStatusAsString(), other.renewalStatusAsString()) && Objects.equals(this.renewalStatusReason(), other.renewalStatusReason()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"RenewalSummary").add("DomainValidationRecords", this.hasDomainValidationRecords() ? this.domainValidationRecords() : null).add("RenewalStatus", (Object)this.renewalStatusAsString()).add("RenewalStatusReason", (Object)this.renewalStatusReason()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainValidationRecords": {
                return Optional.ofNullable(clazz.cast(this.domainValidationRecords()));
            }
            case "renewalStatus": {
                return Optional.ofNullable(clazz.cast(this.renewalStatusAsString()));
            }
            case "renewalStatusReason": {
                return Optional.ofNullable(clazz.cast(this.renewalStatusReason()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RenewalSummary, T> g) {
        return obj -> g.apply((RenewalSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DomainValidationRecord> domainValidationRecords = DefaultSdkAutoConstructList.getInstance();
        private String renewalStatus;
        private String renewalStatusReason;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(RenewalSummary model) {
            this.domainValidationRecords(model.domainValidationRecords);
            this.renewalStatus(model.renewalStatus);
            this.renewalStatusReason(model.renewalStatusReason);
            this.updatedAt(model.updatedAt);
        }

        public final List<DomainValidationRecord.Builder> getDomainValidationRecords() {
            List<DomainValidationRecord.Builder> result = DomainValidationRecordListCopier.copyToBuilder(this.domainValidationRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder domainValidationRecords(Collection<DomainValidationRecord> domainValidationRecords) {
            this.domainValidationRecords = DomainValidationRecordListCopier.copy(domainValidationRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationRecords(DomainValidationRecord ... domainValidationRecords) {
            this.domainValidationRecords(Arrays.asList(domainValidationRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationRecords(Consumer<DomainValidationRecord.Builder> ... domainValidationRecords) {
            this.domainValidationRecords(Stream.of(domainValidationRecords).map(c -> (DomainValidationRecord)((DomainValidationRecord.Builder)DomainValidationRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomainValidationRecords(Collection<DomainValidationRecord.BuilderImpl> domainValidationRecords) {
            this.domainValidationRecords = DomainValidationRecordListCopier.copyFromBuilder(domainValidationRecords);
        }

        public final String getRenewalStatus() {
            return this.renewalStatus;
        }

        @Override
        public final Builder renewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
            return this;
        }

        @Override
        public final Builder renewalStatus(RenewalStatus renewalStatus) {
            this.renewalStatus(renewalStatus == null ? null : renewalStatus.toString());
            return this;
        }

        public final void setRenewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
        }

        public final String getRenewalStatusReason() {
            return this.renewalStatusReason;
        }

        @Override
        public final Builder renewalStatusReason(String renewalStatusReason) {
            this.renewalStatusReason = renewalStatusReason;
            return this;
        }

        public final void setRenewalStatusReason(String renewalStatusReason) {
            this.renewalStatusReason = renewalStatusReason;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        public RenewalSummary build() {
            return new RenewalSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RenewalSummary> {
        public Builder domainValidationRecords(Collection<DomainValidationRecord> var1);

        public Builder domainValidationRecords(DomainValidationRecord ... var1);

        public Builder domainValidationRecords(Consumer<DomainValidationRecord.Builder> ... var1);

        public Builder renewalStatus(String var1);

        public Builder renewalStatus(RenewalStatus var1);

        public Builder renewalStatusReason(String var1);

        public Builder updatedAt(Instant var1);
    }
}

