/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLoadBalancerTlsCertificatesResponse extends LightsailResponse implements
        ToCopyableBuilder<GetLoadBalancerTlsCertificatesResponse.Builder, GetLoadBalancerTlsCertificatesResponse> {
    private static final SdkField<List<LoadBalancerTlsCertificate>> TLS_CERTIFICATES_FIELD = SdkField
            .<List<LoadBalancerTlsCertificate>> builder(MarshallingType.LIST)
            .memberName("tlsCertificates")
            .getter(getter(GetLoadBalancerTlsCertificatesResponse::tlsCertificates))
            .setter(setter(Builder::tlsCertificates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tlsCertificates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoadBalancerTlsCertificate> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadBalancerTlsCertificate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TLS_CERTIFICATES_FIELD));

    private final List<LoadBalancerTlsCertificate> tlsCertificates;

    private GetLoadBalancerTlsCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.tlsCertificates = builder.tlsCertificates;
    }

    /**
     * For responses, this returns true if the service returned a value for the TlsCertificates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTlsCertificates() {
        return tlsCertificates != null && !(tlsCertificates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of LoadBalancerTlsCertificate objects describing your SSL/TLS certificates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTlsCertificates} method.
     * </p>
     * 
     * @return An array of LoadBalancerTlsCertificate objects describing your SSL/TLS certificates.
     */
    public final List<LoadBalancerTlsCertificate> tlsCertificates() {
        return tlsCertificates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTlsCertificates() ? tlsCertificates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLoadBalancerTlsCertificatesResponse)) {
            return false;
        }
        GetLoadBalancerTlsCertificatesResponse other = (GetLoadBalancerTlsCertificatesResponse) obj;
        return hasTlsCertificates() == other.hasTlsCertificates() && Objects.equals(tlsCertificates(), other.tlsCertificates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLoadBalancerTlsCertificatesResponse")
                .add("TlsCertificates", hasTlsCertificates() ? tlsCertificates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tlsCertificates":
            return Optional.ofNullable(clazz.cast(tlsCertificates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLoadBalancerTlsCertificatesResponse, T> g) {
        return obj -> g.apply((GetLoadBalancerTlsCertificatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetLoadBalancerTlsCertificatesResponse> {
        /**
         * <p>
         * An array of LoadBalancerTlsCertificate objects describing your SSL/TLS certificates.
         * </p>
         * 
         * @param tlsCertificates
         *        An array of LoadBalancerTlsCertificate objects describing your SSL/TLS certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsCertificates(Collection<LoadBalancerTlsCertificate> tlsCertificates);

        /**
         * <p>
         * An array of LoadBalancerTlsCertificate objects describing your SSL/TLS certificates.
         * </p>
         * 
         * @param tlsCertificates
         *        An array of LoadBalancerTlsCertificate objects describing your SSL/TLS certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsCertificates(LoadBalancerTlsCertificate... tlsCertificates);

        /**
         * <p>
         * An array of LoadBalancerTlsCertificate objects describing your SSL/TLS certificates.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LoadBalancerTlsCertificate>.Builder}
         * avoiding the need to create one manually via {@link List<LoadBalancerTlsCertificate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LoadBalancerTlsCertificate>.Builder#build()} is called
         * immediately and its result is passed to {@link #tlsCertificates(List<LoadBalancerTlsCertificate>)}.
         * 
         * @param tlsCertificates
         *        a consumer that will call methods on {@link List<LoadBalancerTlsCertificate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tlsCertificates(List<LoadBalancerTlsCertificate>)
         */
        Builder tlsCertificates(Consumer<LoadBalancerTlsCertificate.Builder>... tlsCertificates);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<LoadBalancerTlsCertificate> tlsCertificates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLoadBalancerTlsCertificatesResponse model) {
            super(model);
            tlsCertificates(model.tlsCertificates);
        }

        public final List<LoadBalancerTlsCertificate.Builder> getTlsCertificates() {
            List<LoadBalancerTlsCertificate.Builder> result = LoadBalancerTlsCertificateListCopier
                    .copyToBuilder(this.tlsCertificates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTlsCertificates(Collection<LoadBalancerTlsCertificate.BuilderImpl> tlsCertificates) {
            this.tlsCertificates = LoadBalancerTlsCertificateListCopier.copyFromBuilder(tlsCertificates);
        }

        @Override
        @Transient
        public final Builder tlsCertificates(Collection<LoadBalancerTlsCertificate> tlsCertificates) {
            this.tlsCertificates = LoadBalancerTlsCertificateListCopier.copy(tlsCertificates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tlsCertificates(LoadBalancerTlsCertificate... tlsCertificates) {
            tlsCertificates(Arrays.asList(tlsCertificates));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tlsCertificates(Consumer<LoadBalancerTlsCertificate.Builder>... tlsCertificates) {
            tlsCertificates(Stream.of(tlsCertificates).map(c -> LoadBalancerTlsCertificate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetLoadBalancerTlsCertificatesResponse build() {
            return new GetLoadBalancerTlsCertificatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
