/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDistributionRequest extends LightsailRequest implements
        ToCopyableBuilder<CreateDistributionRequest.Builder, CreateDistributionRequest> {
    private static final SdkField<String> DISTRIBUTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("distributionName").getter(getter(CreateDistributionRequest::distributionName))
            .setter(setter(Builder::distributionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionName").build()).build();

    private static final SdkField<InputOrigin> ORIGIN_FIELD = SdkField.<InputOrigin> builder(MarshallingType.SDK_POJO)
            .memberName("origin").getter(getter(CreateDistributionRequest::origin)).setter(setter(Builder::origin))
            .constructor(InputOrigin::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("origin").build()).build();

    private static final SdkField<CacheBehavior> DEFAULT_CACHE_BEHAVIOR_FIELD = SdkField
            .<CacheBehavior> builder(MarshallingType.SDK_POJO).memberName("defaultCacheBehavior")
            .getter(getter(CreateDistributionRequest::defaultCacheBehavior)).setter(setter(Builder::defaultCacheBehavior))
            .constructor(CacheBehavior::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultCacheBehavior").build())
            .build();

    private static final SdkField<CacheSettings> CACHE_BEHAVIOR_SETTINGS_FIELD = SdkField
            .<CacheSettings> builder(MarshallingType.SDK_POJO).memberName("cacheBehaviorSettings")
            .getter(getter(CreateDistributionRequest::cacheBehaviorSettings)).setter(setter(Builder::cacheBehaviorSettings))
            .constructor(CacheSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBehaviorSettings").build())
            .build();

    private static final SdkField<List<CacheBehaviorPerPath>> CACHE_BEHAVIORS_FIELD = SdkField
            .<List<CacheBehaviorPerPath>> builder(MarshallingType.LIST)
            .memberName("cacheBehaviors")
            .getter(getter(CreateDistributionRequest::cacheBehaviors))
            .setter(setter(Builder::cacheBehaviors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBehaviors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CacheBehaviorPerPath> builder(MarshallingType.SDK_POJO)
                                            .constructor(CacheBehaviorPerPath::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bundleId").getter(getter(CreateDistributionRequest::bundleId)).setter(setter(Builder::bundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipAddressType").getter(getter(CreateDistributionRequest::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressType").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateDistributionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_NAME_FIELD,
            ORIGIN_FIELD, DEFAULT_CACHE_BEHAVIOR_FIELD, CACHE_BEHAVIOR_SETTINGS_FIELD, CACHE_BEHAVIORS_FIELD, BUNDLE_ID_FIELD,
            IP_ADDRESS_TYPE_FIELD, TAGS_FIELD));

    private final String distributionName;

    private final InputOrigin origin;

    private final CacheBehavior defaultCacheBehavior;

    private final CacheSettings cacheBehaviorSettings;

    private final List<CacheBehaviorPerPath> cacheBehaviors;

    private final String bundleId;

    private final String ipAddressType;

    private final List<Tag> tags;

    private CreateDistributionRequest(BuilderImpl builder) {
        super(builder);
        this.distributionName = builder.distributionName;
        this.origin = builder.origin;
        this.defaultCacheBehavior = builder.defaultCacheBehavior;
        this.cacheBehaviorSettings = builder.cacheBehaviorSettings;
        this.cacheBehaviors = builder.cacheBehaviors;
        this.bundleId = builder.bundleId;
        this.ipAddressType = builder.ipAddressType;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name for the distribution.
     * </p>
     * 
     * @return The name for the distribution.
     */
    public final String distributionName() {
        return distributionName;
    }

    /**
     * <p>
     * An object that describes the origin resource for the distribution, such as a Lightsail instance or load balancer.
     * </p>
     * <p>
     * The distribution pulls, caches, and serves content from the origin.
     * </p>
     * 
     * @return An object that describes the origin resource for the distribution, such as a Lightsail instance or load
     *         balancer.</p>
     *         <p>
     *         The distribution pulls, caches, and serves content from the origin.
     */
    public final InputOrigin origin() {
        return origin;
    }

    /**
     * <p>
     * An object that describes the default cache behavior for the distribution.
     * </p>
     * 
     * @return An object that describes the default cache behavior for the distribution.
     */
    public final CacheBehavior defaultCacheBehavior() {
        return defaultCacheBehavior;
    }

    /**
     * <p>
     * An object that describes the cache behavior settings for the distribution.
     * </p>
     * 
     * @return An object that describes the cache behavior settings for the distribution.
     */
    public final CacheSettings cacheBehaviorSettings() {
        return cacheBehaviorSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the CacheBehaviors property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCacheBehaviors() {
        return cacheBehaviors != null && !(cacheBehaviors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe the per-path cache behavior for the distribution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCacheBehaviors} method.
     * </p>
     * 
     * @return An array of objects that describe the per-path cache behavior for the distribution.
     */
    public final List<CacheBehaviorPerPath> cacheBehaviors() {
        return cacheBehaviors;
    }

    /**
     * <p>
     * The bundle ID to use for the distribution.
     * </p>
     * <p>
     * A distribution bundle describes the specifications of your distribution, such as the monthly cost and monthly
     * network transfer quota.
     * </p>
     * <p>
     * Use the <code>GetDistributionBundles</code> action to get a list of distribution bundle IDs that you can specify.
     * </p>
     * 
     * @return The bundle ID to use for the distribution.</p>
     *         <p>
     *         A distribution bundle describes the specifications of your distribution, such as the monthly cost and
     *         monthly network transfer quota.
     *         </p>
     *         <p>
     *         Use the <code>GetDistributionBundles</code> action to get a list of distribution bundle IDs that you can
     *         specify.
     */
    public final String bundleId() {
        return bundleId;
    }

    /**
     * <p>
     * The IP address type for the distribution.
     * </p>
     * <p>
     * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     * </p>
     * <p>
     * The default value is <code>dualstack</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the distribution.</p>
     *         <p>
     *         The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     *         </p>
     *         <p>
     *         The default value is <code>dualstack</code>.
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The IP address type for the distribution.
     * </p>
     * <p>
     * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     * </p>
     * <p>
     * The default value is <code>dualstack</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the distribution.</p>
     *         <p>
     *         The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     *         </p>
     *         <p>
     *         The default value is <code>dualstack</code>.
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag keys and optional values to add to the distribution during create.
     * </p>
     * <p>
     * Use the <code>TagResource</code> action to tag a resource after it's created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tag keys and optional values to add to the distribution during create.</p>
     *         <p>
     *         Use the <code>TagResource</code> action to tag a resource after it's created.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(distributionName());
        hashCode = 31 * hashCode + Objects.hashCode(origin());
        hashCode = 31 * hashCode + Objects.hashCode(defaultCacheBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(cacheBehaviorSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasCacheBehaviors() ? cacheBehaviors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDistributionRequest)) {
            return false;
        }
        CreateDistributionRequest other = (CreateDistributionRequest) obj;
        return Objects.equals(distributionName(), other.distributionName()) && Objects.equals(origin(), other.origin())
                && Objects.equals(defaultCacheBehavior(), other.defaultCacheBehavior())
                && Objects.equals(cacheBehaviorSettings(), other.cacheBehaviorSettings())
                && hasCacheBehaviors() == other.hasCacheBehaviors() && Objects.equals(cacheBehaviors(), other.cacheBehaviors())
                && Objects.equals(bundleId(), other.bundleId())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDistributionRequest").add("DistributionName", distributionName()).add("Origin", origin())
                .add("DefaultCacheBehavior", defaultCacheBehavior()).add("CacheBehaviorSettings", cacheBehaviorSettings())
                .add("CacheBehaviors", hasCacheBehaviors() ? cacheBehaviors() : null).add("BundleId", bundleId())
                .add("IpAddressType", ipAddressTypeAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "distributionName":
            return Optional.ofNullable(clazz.cast(distributionName()));
        case "origin":
            return Optional.ofNullable(clazz.cast(origin()));
        case "defaultCacheBehavior":
            return Optional.ofNullable(clazz.cast(defaultCacheBehavior()));
        case "cacheBehaviorSettings":
            return Optional.ofNullable(clazz.cast(cacheBehaviorSettings()));
        case "cacheBehaviors":
            return Optional.ofNullable(clazz.cast(cacheBehaviors()));
        case "bundleId":
            return Optional.ofNullable(clazz.cast(bundleId()));
        case "ipAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDistributionRequest, T> g) {
        return obj -> g.apply((CreateDistributionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDistributionRequest> {
        /**
         * <p>
         * The name for the distribution.
         * </p>
         * 
         * @param distributionName
         *        The name for the distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionName(String distributionName);

        /**
         * <p>
         * An object that describes the origin resource for the distribution, such as a Lightsail instance or load
         * balancer.
         * </p>
         * <p>
         * The distribution pulls, caches, and serves content from the origin.
         * </p>
         * 
         * @param origin
         *        An object that describes the origin resource for the distribution, such as a Lightsail instance or
         *        load balancer.</p>
         *        <p>
         *        The distribution pulls, caches, and serves content from the origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder origin(InputOrigin origin);

        /**
         * <p>
         * An object that describes the origin resource for the distribution, such as a Lightsail instance or load
         * balancer.
         * </p>
         * <p>
         * The distribution pulls, caches, and serves content from the origin.
         * </p>
         * This is a convenience that creates an instance of the {@link InputOrigin.Builder} avoiding the need to create
         * one manually via {@link InputOrigin#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputOrigin.Builder#build()} is called immediately and its result
         * is passed to {@link #origin(InputOrigin)}.
         * 
         * @param origin
         *        a consumer that will call methods on {@link InputOrigin.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #origin(InputOrigin)
         */
        default Builder origin(Consumer<InputOrigin.Builder> origin) {
            return origin(InputOrigin.builder().applyMutation(origin).build());
        }

        /**
         * <p>
         * An object that describes the default cache behavior for the distribution.
         * </p>
         * 
         * @param defaultCacheBehavior
         *        An object that describes the default cache behavior for the distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCacheBehavior(CacheBehavior defaultCacheBehavior);

        /**
         * <p>
         * An object that describes the default cache behavior for the distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link CacheBehavior.Builder} avoiding the need to
         * create one manually via {@link CacheBehavior#builder()}.
         *
         * When the {@link Consumer} completes, {@link CacheBehavior.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultCacheBehavior(CacheBehavior)}.
         * 
         * @param defaultCacheBehavior
         *        a consumer that will call methods on {@link CacheBehavior.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultCacheBehavior(CacheBehavior)
         */
        default Builder defaultCacheBehavior(Consumer<CacheBehavior.Builder> defaultCacheBehavior) {
            return defaultCacheBehavior(CacheBehavior.builder().applyMutation(defaultCacheBehavior).build());
        }

        /**
         * <p>
         * An object that describes the cache behavior settings for the distribution.
         * </p>
         * 
         * @param cacheBehaviorSettings
         *        An object that describes the cache behavior settings for the distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheBehaviorSettings(CacheSettings cacheBehaviorSettings);

        /**
         * <p>
         * An object that describes the cache behavior settings for the distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link CacheSettings.Builder} avoiding the need to
         * create one manually via {@link CacheSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link CacheSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #cacheBehaviorSettings(CacheSettings)}.
         * 
         * @param cacheBehaviorSettings
         *        a consumer that will call methods on {@link CacheSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheBehaviorSettings(CacheSettings)
         */
        default Builder cacheBehaviorSettings(Consumer<CacheSettings.Builder> cacheBehaviorSettings) {
            return cacheBehaviorSettings(CacheSettings.builder().applyMutation(cacheBehaviorSettings).build());
        }

        /**
         * <p>
         * An array of objects that describe the per-path cache behavior for the distribution.
         * </p>
         * 
         * @param cacheBehaviors
         *        An array of objects that describe the per-path cache behavior for the distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheBehaviors(Collection<CacheBehaviorPerPath> cacheBehaviors);

        /**
         * <p>
         * An array of objects that describe the per-path cache behavior for the distribution.
         * </p>
         * 
         * @param cacheBehaviors
         *        An array of objects that describe the per-path cache behavior for the distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheBehaviors(CacheBehaviorPerPath... cacheBehaviors);

        /**
         * <p>
         * An array of objects that describe the per-path cache behavior for the distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CacheBehaviorPerPath>.Builder} avoiding the
         * need to create one manually via {@link List<CacheBehaviorPerPath>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CacheBehaviorPerPath>.Builder#build()} is called immediately
         * and its result is passed to {@link #cacheBehaviors(List<CacheBehaviorPerPath>)}.
         * 
         * @param cacheBehaviors
         *        a consumer that will call methods on {@link List<CacheBehaviorPerPath>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheBehaviors(List<CacheBehaviorPerPath>)
         */
        Builder cacheBehaviors(Consumer<CacheBehaviorPerPath.Builder>... cacheBehaviors);

        /**
         * <p>
         * The bundle ID to use for the distribution.
         * </p>
         * <p>
         * A distribution bundle describes the specifications of your distribution, such as the monthly cost and monthly
         * network transfer quota.
         * </p>
         * <p>
         * Use the <code>GetDistributionBundles</code> action to get a list of distribution bundle IDs that you can
         * specify.
         * </p>
         * 
         * @param bundleId
         *        The bundle ID to use for the distribution.</p>
         *        <p>
         *        A distribution bundle describes the specifications of your distribution, such as the monthly cost and
         *        monthly network transfer quota.
         *        </p>
         *        <p>
         *        Use the <code>GetDistributionBundles</code> action to get a list of distribution bundle IDs that you
         *        can specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * The IP address type for the distribution.
         * </p>
         * <p>
         * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         * </p>
         * <p>
         * The default value is <code>dualstack</code>.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type for the distribution.</p>
         *        <p>
         *        The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         *        </p>
         *        <p>
         *        The default value is <code>dualstack</code>.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The IP address type for the distribution.
         * </p>
         * <p>
         * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         * </p>
         * <p>
         * The default value is <code>dualstack</code>.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type for the distribution.</p>
         *        <p>
         *        The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         *        </p>
         *        <p>
         *        The default value is <code>dualstack</code>.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);

        /**
         * <p>
         * The tag keys and optional values to add to the distribution during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values to add to the distribution during create.</p>
         *        <p>
         *        Use the <code>TagResource</code> action to tag a resource after it's created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tag keys and optional values to add to the distribution during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values to add to the distribution during create.</p>
         *        <p>
         *        Use the <code>TagResource</code> action to tag a resource after it's created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tag keys and optional values to add to the distribution during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String distributionName;

        private InputOrigin origin;

        private CacheBehavior defaultCacheBehavior;

        private CacheSettings cacheBehaviorSettings;

        private List<CacheBehaviorPerPath> cacheBehaviors = DefaultSdkAutoConstructList.getInstance();

        private String bundleId;

        private String ipAddressType;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDistributionRequest model) {
            super(model);
            distributionName(model.distributionName);
            origin(model.origin);
            defaultCacheBehavior(model.defaultCacheBehavior);
            cacheBehaviorSettings(model.cacheBehaviorSettings);
            cacheBehaviors(model.cacheBehaviors);
            bundleId(model.bundleId);
            ipAddressType(model.ipAddressType);
            tags(model.tags);
        }

        public final String getDistributionName() {
            return distributionName;
        }

        public final void setDistributionName(String distributionName) {
            this.distributionName = distributionName;
        }

        @Override
        @Transient
        public final Builder distributionName(String distributionName) {
            this.distributionName = distributionName;
            return this;
        }

        public final InputOrigin.Builder getOrigin() {
            return origin != null ? origin.toBuilder() : null;
        }

        public final void setOrigin(InputOrigin.BuilderImpl origin) {
            this.origin = origin != null ? origin.build() : null;
        }

        @Override
        @Transient
        public final Builder origin(InputOrigin origin) {
            this.origin = origin;
            return this;
        }

        public final CacheBehavior.Builder getDefaultCacheBehavior() {
            return defaultCacheBehavior != null ? defaultCacheBehavior.toBuilder() : null;
        }

        public final void setDefaultCacheBehavior(CacheBehavior.BuilderImpl defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior != null ? defaultCacheBehavior.build() : null;
        }

        @Override
        @Transient
        public final Builder defaultCacheBehavior(CacheBehavior defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior;
            return this;
        }

        public final CacheSettings.Builder getCacheBehaviorSettings() {
            return cacheBehaviorSettings != null ? cacheBehaviorSettings.toBuilder() : null;
        }

        public final void setCacheBehaviorSettings(CacheSettings.BuilderImpl cacheBehaviorSettings) {
            this.cacheBehaviorSettings = cacheBehaviorSettings != null ? cacheBehaviorSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder cacheBehaviorSettings(CacheSettings cacheBehaviorSettings) {
            this.cacheBehaviorSettings = cacheBehaviorSettings;
            return this;
        }

        public final List<CacheBehaviorPerPath.Builder> getCacheBehaviors() {
            List<CacheBehaviorPerPath.Builder> result = CacheBehaviorListCopier.copyToBuilder(this.cacheBehaviors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCacheBehaviors(Collection<CacheBehaviorPerPath.BuilderImpl> cacheBehaviors) {
            this.cacheBehaviors = CacheBehaviorListCopier.copyFromBuilder(cacheBehaviors);
        }

        @Override
        @Transient
        public final Builder cacheBehaviors(Collection<CacheBehaviorPerPath> cacheBehaviors) {
            this.cacheBehaviors = CacheBehaviorListCopier.copy(cacheBehaviors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cacheBehaviors(CacheBehaviorPerPath... cacheBehaviors) {
            cacheBehaviors(Arrays.asList(cacheBehaviors));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cacheBehaviors(Consumer<CacheBehaviorPerPath.Builder>... cacheBehaviors) {
            cacheBehaviors(Stream.of(cacheBehaviors).map(c -> CacheBehaviorPerPath.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getBundleId() {
            return bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        @Transient
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        @Transient
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        @Transient
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDistributionRequest build() {
            return new CreateDistributionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
