/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the activation status of the role that you can use to grant an Amazon Lightsail container service access to
 * Amazon Elastic Container Registry (Amazon ECR) private repositories.
 * </p>
 * <p>
 * When activated, Lightsail creates an Identity and Access Management (IAM) role for the specified Lightsail container
 * service. You can use the ARN of the role to create a trust relationship between your Lightsail container service and
 * an Amazon ECR private repository in your Amazon Web Services account. This allows your container service to pull
 * images from Amazon ECR private repositories. For more information, see <a href=
 * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-service-ecr-private-repo-access"
 * >Configuring access to an Amazon ECR private repository for an Amazon Lightsail container service</a> in the
 * <i>Amazon Lightsail Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerServiceECRImagePullerRole implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerServiceECRImagePullerRole.Builder, ContainerServiceECRImagePullerRole> {
    private static final SdkField<Boolean> IS_ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isActive").getter(getter(ContainerServiceECRImagePullerRole::isActive))
            .setter(setter(Builder::isActive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isActive").build()).build();

    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalArn").getter(getter(ContainerServiceECRImagePullerRole::principalArn))
            .setter(setter(Builder::principalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_ACTIVE_FIELD,
            PRINCIPAL_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean isActive;

    private final String principalArn;

    private ContainerServiceECRImagePullerRole(BuilderImpl builder) {
        this.isActive = builder.isActive;
        this.principalArn = builder.principalArn;
    }

    /**
     * <p>
     * A Boolean value that indicates whether the role is activated.
     * </p>
     * 
     * @return A Boolean value that indicates whether the role is activated.
     */
    public final Boolean isActive() {
        return isActive;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role, if it is activated.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role, if it is activated.
     */
    public final String principalArn() {
        return principalArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isActive());
        hashCode = 31 * hashCode + Objects.hashCode(principalArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerServiceECRImagePullerRole)) {
            return false;
        }
        ContainerServiceECRImagePullerRole other = (ContainerServiceECRImagePullerRole) obj;
        return Objects.equals(isActive(), other.isActive()) && Objects.equals(principalArn(), other.principalArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerServiceECRImagePullerRole").add("IsActive", isActive())
                .add("PrincipalArn", principalArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isActive":
            return Optional.ofNullable(clazz.cast(isActive()));
        case "principalArn":
            return Optional.ofNullable(clazz.cast(principalArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerServiceECRImagePullerRole, T> g) {
        return obj -> g.apply((ContainerServiceECRImagePullerRole) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerServiceECRImagePullerRole> {
        /**
         * <p>
         * A Boolean value that indicates whether the role is activated.
         * </p>
         * 
         * @param isActive
         *        A Boolean value that indicates whether the role is activated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isActive(Boolean isActive);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role, if it is activated.
         * </p>
         * 
         * @param principalArn
         *        The Amazon Resource Name (ARN) of the role, if it is activated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalArn(String principalArn);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isActive;

        private String principalArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerServiceECRImagePullerRole model) {
            isActive(model.isActive);
            principalArn(model.principalArn);
        }

        public final Boolean getIsActive() {
            return isActive;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public final String getPrincipalArn() {
            return principalArn;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        @Override
        public ContainerServiceECRImagePullerRole build() {
            return new ContainerServiceECRImagePullerRole(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
