/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCertificateResponse extends LightsailResponse implements
        ToCopyableBuilder<CreateCertificateResponse.Builder, CreateCertificateResponse> {
    private static final SdkField<CertificateSummary> CERTIFICATE_FIELD = SdkField
            .<CertificateSummary> builder(MarshallingType.SDK_POJO).memberName("certificate")
            .getter(getter(CreateCertificateResponse::certificate)).setter(setter(Builder::certificate))
            .constructor(CertificateSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificate").build()).build();

    private static final SdkField<List<Operation>> OPERATIONS_FIELD = SdkField
            .<List<Operation>> builder(MarshallingType.LIST)
            .memberName("operations")
            .getter(getter(CreateCertificateResponse::operations))
            .setter(setter(Builder::operations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Operation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Operation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD,
            OPERATIONS_FIELD));

    private final CertificateSummary certificate;

    private final List<Operation> operations;

    private CreateCertificateResponse(BuilderImpl builder) {
        super(builder);
        this.certificate = builder.certificate;
        this.operations = builder.operations;
    }

    /**
     * <p>
     * An object that describes the certificate created.
     * </p>
     * 
     * @return An object that describes the certificate created.
     */
    public final CertificateSummary certificate() {
        return certificate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Operations property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOperations() {
        return operations != null && !(operations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe the result of the action, such as the status of the request, the timestamp of
     * the request, and the resources affected by the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperations} method.
     * </p>
     * 
     * @return An array of objects that describe the result of the action, such as the status of the request, the
     *         timestamp of the request, and the resources affected by the request.
     */
    public final List<Operation> operations() {
        return operations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificate());
        hashCode = 31 * hashCode + Objects.hashCode(hasOperations() ? operations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCertificateResponse)) {
            return false;
        }
        CreateCertificateResponse other = (CreateCertificateResponse) obj;
        return Objects.equals(certificate(), other.certificate()) && hasOperations() == other.hasOperations()
                && Objects.equals(operations(), other.operations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCertificateResponse").add("Certificate", certificate())
                .add("Operations", hasOperations() ? operations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificate":
            return Optional.ofNullable(clazz.cast(certificate()));
        case "operations":
            return Optional.ofNullable(clazz.cast(operations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCertificateResponse, T> g) {
        return obj -> g.apply((CreateCertificateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateCertificateResponse> {
        /**
         * <p>
         * An object that describes the certificate created.
         * </p>
         * 
         * @param certificate
         *        An object that describes the certificate created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificate(CertificateSummary certificate);

        /**
         * <p>
         * An object that describes the certificate created.
         * </p>
         * This is a convenience method that creates an instance of the {@link CertificateSummary.Builder} avoiding the
         * need to create one manually via {@link CertificateSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CertificateSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #certificate(CertificateSummary)}.
         * 
         * @param certificate
         *        a consumer that will call methods on {@link CertificateSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificate(CertificateSummary)
         */
        default Builder certificate(Consumer<CertificateSummary.Builder> certificate) {
            return certificate(CertificateSummary.builder().applyMutation(certificate).build());
        }

        /**
         * <p>
         * An array of objects that describe the result of the action, such as the status of the request, the timestamp
         * of the request, and the resources affected by the request.
         * </p>
         * 
         * @param operations
         *        An array of objects that describe the result of the action, such as the status of the request, the
         *        timestamp of the request, and the resources affected by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Collection<Operation> operations);

        /**
         * <p>
         * An array of objects that describe the result of the action, such as the status of the request, the timestamp
         * of the request, and the resources affected by the request.
         * </p>
         * 
         * @param operations
         *        An array of objects that describe the result of the action, such as the status of the request, the
         *        timestamp of the request, and the resources affected by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Operation... operations);

        /**
         * <p>
         * An array of objects that describe the result of the action, such as the status of the request, the timestamp
         * of the request, and the resources affected by the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lightsail.model.Operation.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lightsail.model.Operation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lightsail.model.Operation.Builder#build()} is called immediately and
         * its result is passed to {@link #operations(List<Operation>)}.
         * 
         * @param operations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lightsail.model.Operation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operations(java.util.Collection<Operation>)
         */
        Builder operations(Consumer<Operation.Builder>... operations);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private CertificateSummary certificate;

        private List<Operation> operations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCertificateResponse model) {
            super(model);
            certificate(model.certificate);
            operations(model.operations);
        }

        public final CertificateSummary.Builder getCertificate() {
            return certificate != null ? certificate.toBuilder() : null;
        }

        public final void setCertificate(CertificateSummary.BuilderImpl certificate) {
            this.certificate = certificate != null ? certificate.build() : null;
        }

        @Override
        public final Builder certificate(CertificateSummary certificate) {
            this.certificate = certificate;
            return this;
        }

        public final List<Operation.Builder> getOperations() {
            List<Operation.Builder> result = OperationListCopier.copyToBuilder(this.operations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperations(Collection<Operation.BuilderImpl> operations) {
            this.operations = OperationListCopier.copyFromBuilder(operations);
        }

        @Override
        public final Builder operations(Collection<Operation> operations) {
            this.operations = OperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Operation... operations) {
            operations(Arrays.asList(operations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Consumer<Operation.Builder>... operations) {
            operations(Stream.of(operations).map(c -> Operation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateCertificateResponse build() {
            return new CreateCertificateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
