/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An estimate that's associated with a time period.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EstimateByTime implements SdkPojo, Serializable, ToCopyableBuilder<EstimateByTime.Builder, EstimateByTime> {
    private static final SdkField<Double> USAGE_COST_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("usageCost").getter(getter(EstimateByTime::usageCost)).setter(setter(Builder::usageCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageCost").build()).build();

    private static final SdkField<String> PRICING_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pricingUnit").getter(getter(EstimateByTime::pricingUnitAsString)).setter(setter(Builder::pricingUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pricingUnit").build()).build();

    private static final SdkField<Double> UNIT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("unit")
            .getter(getter(EstimateByTime::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<String> CURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currency").getter(getter(EstimateByTime::currencyAsString)).setter(setter(Builder::currency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currency").build()).build();

    private static final SdkField<TimePeriod> TIME_PERIOD_FIELD = SdkField.<TimePeriod> builder(MarshallingType.SDK_POJO)
            .memberName("timePeriod").getter(getter(EstimateByTime::timePeriod)).setter(setter(Builder::timePeriod))
            .constructor(TimePeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timePeriod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_COST_FIELD,
            PRICING_UNIT_FIELD, UNIT_FIELD, CURRENCY_FIELD, TIME_PERIOD_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double usageCost;

    private final String pricingUnit;

    private final Double unit;

    private final String currency;

    private final TimePeriod timePeriod;

    private EstimateByTime(BuilderImpl builder) {
        this.usageCost = builder.usageCost;
        this.pricingUnit = builder.pricingUnit;
        this.unit = builder.unit;
        this.currency = builder.currency;
        this.timePeriod = builder.timePeriod;
    }

    /**
     * <p>
     * The amount of cost or usage that's measured for the cost estimate.
     * </p>
     * 
     * @return The amount of cost or usage that's measured for the cost estimate.
     */
    public final Double usageCost() {
        return usageCost;
    }

    /**
     * <p>
     * The unit of measurement that's used for the cost estimate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingUnit} will
     * return {@link PricingUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingUnitAsString}.
     * </p>
     * 
     * @return The unit of measurement that's used for the cost estimate.
     * @see PricingUnit
     */
    public final PricingUnit pricingUnit() {
        return PricingUnit.fromValue(pricingUnit);
    }

    /**
     * <p>
     * The unit of measurement that's used for the cost estimate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingUnit} will
     * return {@link PricingUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingUnitAsString}.
     * </p>
     * 
     * @return The unit of measurement that's used for the cost estimate.
     * @see PricingUnit
     */
    public final String pricingUnitAsString() {
        return pricingUnit;
    }

    /**
     * <p>
     * The number of pricing units used to calculate the total number of hours. For example, 1 unit equals 1 hour.
     * </p>
     * 
     * @return The number of pricing units used to calculate the total number of hours. For example, 1 unit equals 1
     *         hour.
     */
    public final Double unit() {
        return unit;
    }

    /**
     * <p>
     * The currency of the estimate in USD.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currency} will
     * return {@link Currency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyAsString}.
     * </p>
     * 
     * @return The currency of the estimate in USD.
     * @see Currency
     */
    public final Currency currency() {
        return Currency.fromValue(currency);
    }

    /**
     * <p>
     * The currency of the estimate in USD.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currency} will
     * return {@link Currency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyAsString}.
     * </p>
     * 
     * @return The currency of the estimate in USD.
     * @see Currency
     */
    public final String currencyAsString() {
        return currency;
    }

    /**
     * <p>
     * The period of time, in days, that an estimate covers. The period has a start date and an end date. The start date
     * must come before the end date.
     * </p>
     * 
     * @return The period of time, in days, that an estimate covers. The period has a start date and an end date. The
     *         start date must come before the end date.
     */
    public final TimePeriod timePeriod() {
        return timePeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(usageCost());
        hashCode = 31 * hashCode + Objects.hashCode(pricingUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        hashCode = 31 * hashCode + Objects.hashCode(currencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timePeriod());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EstimateByTime)) {
            return false;
        }
        EstimateByTime other = (EstimateByTime) obj;
        return Objects.equals(usageCost(), other.usageCost())
                && Objects.equals(pricingUnitAsString(), other.pricingUnitAsString()) && Objects.equals(unit(), other.unit())
                && Objects.equals(currencyAsString(), other.currencyAsString())
                && Objects.equals(timePeriod(), other.timePeriod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EstimateByTime").add("UsageCost", usageCost()).add("PricingUnit", pricingUnitAsString())
                .add("Unit", unit()).add("Currency", currencyAsString()).add("TimePeriod", timePeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usageCost":
            return Optional.ofNullable(clazz.cast(usageCost()));
        case "pricingUnit":
            return Optional.ofNullable(clazz.cast(pricingUnitAsString()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unit()));
        case "currency":
            return Optional.ofNullable(clazz.cast(currencyAsString()));
        case "timePeriod":
            return Optional.ofNullable(clazz.cast(timePeriod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EstimateByTime, T> g) {
        return obj -> g.apply((EstimateByTime) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EstimateByTime> {
        /**
         * <p>
         * The amount of cost or usage that's measured for the cost estimate.
         * </p>
         * 
         * @param usageCost
         *        The amount of cost or usage that's measured for the cost estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageCost(Double usageCost);

        /**
         * <p>
         * The unit of measurement that's used for the cost estimate.
         * </p>
         * 
         * @param pricingUnit
         *        The unit of measurement that's used for the cost estimate.
         * @see PricingUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingUnit
         */
        Builder pricingUnit(String pricingUnit);

        /**
         * <p>
         * The unit of measurement that's used for the cost estimate.
         * </p>
         * 
         * @param pricingUnit
         *        The unit of measurement that's used for the cost estimate.
         * @see PricingUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingUnit
         */
        Builder pricingUnit(PricingUnit pricingUnit);

        /**
         * <p>
         * The number of pricing units used to calculate the total number of hours. For example, 1 unit equals 1 hour.
         * </p>
         * 
         * @param unit
         *        The number of pricing units used to calculate the total number of hours. For example, 1 unit equals 1
         *        hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(Double unit);

        /**
         * <p>
         * The currency of the estimate in USD.
         * </p>
         * 
         * @param currency
         *        The currency of the estimate in USD.
         * @see Currency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Currency
         */
        Builder currency(String currency);

        /**
         * <p>
         * The currency of the estimate in USD.
         * </p>
         * 
         * @param currency
         *        The currency of the estimate in USD.
         * @see Currency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Currency
         */
        Builder currency(Currency currency);

        /**
         * <p>
         * The period of time, in days, that an estimate covers. The period has a start date and an end date. The start
         * date must come before the end date.
         * </p>
         * 
         * @param timePeriod
         *        The period of time, in days, that an estimate covers. The period has a start date and an end date. The
         *        start date must come before the end date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePeriod(TimePeriod timePeriod);

        /**
         * <p>
         * The period of time, in days, that an estimate covers. The period has a start date and an end date. The start
         * date must come before the end date.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimePeriod.Builder} avoiding the need to
         * create one manually via {@link TimePeriod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimePeriod.Builder#build()} is called immediately and its result
         * is passed to {@link #timePeriod(TimePeriod)}.
         * 
         * @param timePeriod
         *        a consumer that will call methods on {@link TimePeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timePeriod(TimePeriod)
         */
        default Builder timePeriod(Consumer<TimePeriod.Builder> timePeriod) {
            return timePeriod(TimePeriod.builder().applyMutation(timePeriod).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Double usageCost;

        private String pricingUnit;

        private Double unit;

        private String currency;

        private TimePeriod timePeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(EstimateByTime model) {
            usageCost(model.usageCost);
            pricingUnit(model.pricingUnit);
            unit(model.unit);
            currency(model.currency);
            timePeriod(model.timePeriod);
        }

        public final Double getUsageCost() {
            return usageCost;
        }

        public final void setUsageCost(Double usageCost) {
            this.usageCost = usageCost;
        }

        @Override
        public final Builder usageCost(Double usageCost) {
            this.usageCost = usageCost;
            return this;
        }

        public final String getPricingUnit() {
            return pricingUnit;
        }

        public final void setPricingUnit(String pricingUnit) {
            this.pricingUnit = pricingUnit;
        }

        @Override
        public final Builder pricingUnit(String pricingUnit) {
            this.pricingUnit = pricingUnit;
            return this;
        }

        @Override
        public final Builder pricingUnit(PricingUnit pricingUnit) {
            this.pricingUnit(pricingUnit == null ? null : pricingUnit.toString());
            return this;
        }

        public final Double getUnit() {
            return unit;
        }

        public final void setUnit(Double unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(Double unit) {
            this.unit = unit;
            return this;
        }

        public final String getCurrency() {
            return currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public final Builder currency(Currency currency) {
            this.currency(currency == null ? null : currency.toString());
            return this;
        }

        public final TimePeriod.Builder getTimePeriod() {
            return timePeriod != null ? timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(TimePeriod.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        public final Builder timePeriod(TimePeriod timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        @Override
        public EstimateByTime build() {
            return new EstimateByTime(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
