/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetResourceAccessForBucketRequest extends LightsailRequest implements
        ToCopyableBuilder<SetResourceAccessForBucketRequest.Builder, SetResourceAccessForBucketRequest> {
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceName").getter(getter(SetResourceAccessForBucketRequest::resourceName))
            .setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()).build();

    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketName").getter(getter(SetResourceAccessForBucketRequest::bucketName))
            .setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()).build();

    private static final SdkField<String> ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("access")
            .getter(getter(SetResourceAccessForBucketRequest::accessAsString)).setter(setter(Builder::access))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("access").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_NAME_FIELD,
            BUCKET_NAME_FIELD, ACCESS_FIELD));

    private final String resourceName;

    private final String bucketName;

    private final String access;

    private SetResourceAccessForBucketRequest(BuilderImpl builder) {
        super(builder);
        this.resourceName = builder.resourceName;
        this.bucketName = builder.bucketName;
        this.access = builder.access;
    }

    /**
     * <p>
     * The name of the Lightsail instance for which to set bucket access. The instance must be in a running or stopped
     * state.
     * </p>
     * 
     * @return The name of the Lightsail instance for which to set bucket access. The instance must be in a running or
     *         stopped state.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The name of the bucket for which to set access to another Lightsail resource.
     * </p>
     * 
     * @return The name of the bucket for which to set access to another Lightsail resource.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The access setting.
     * </p>
     * <p>
     * The following access settings are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>allow</code> - Allows access to the bucket and its objects.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deny</code> - Denies access to the bucket and its objects. Use this setting to remove access for a resource
     * previously set to <code>allow</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #access} will
     * return {@link ResourceBucketAccess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #accessAsString}.
     * </p>
     * 
     * @return The access setting.</p>
     *         <p>
     *         The following access settings are available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>allow</code> - Allows access to the bucket and its objects.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deny</code> - Denies access to the bucket and its objects. Use this setting to remove access for a
     *         resource previously set to <code>allow</code>.
     *         </p>
     *         </li>
     * @see ResourceBucketAccess
     */
    public final ResourceBucketAccess access() {
        return ResourceBucketAccess.fromValue(access);
    }

    /**
     * <p>
     * The access setting.
     * </p>
     * <p>
     * The following access settings are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>allow</code> - Allows access to the bucket and its objects.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deny</code> - Denies access to the bucket and its objects. Use this setting to remove access for a resource
     * previously set to <code>allow</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #access} will
     * return {@link ResourceBucketAccess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #accessAsString}.
     * </p>
     * 
     * @return The access setting.</p>
     *         <p>
     *         The following access settings are available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>allow</code> - Allows access to the bucket and its objects.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deny</code> - Denies access to the bucket and its objects. Use this setting to remove access for a
     *         resource previously set to <code>allow</code>.
     *         </p>
     *         </li>
     * @see ResourceBucketAccess
     */
    public final String accessAsString() {
        return access;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(accessAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetResourceAccessForBucketRequest)) {
            return false;
        }
        SetResourceAccessForBucketRequest other = (SetResourceAccessForBucketRequest) obj;
        return Objects.equals(resourceName(), other.resourceName()) && Objects.equals(bucketName(), other.bucketName())
                && Objects.equals(accessAsString(), other.accessAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetResourceAccessForBucketRequest").add("ResourceName", resourceName())
                .add("BucketName", bucketName()).add("Access", accessAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "bucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "access":
            return Optional.ofNullable(clazz.cast(accessAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetResourceAccessForBucketRequest, T> g) {
        return obj -> g.apply((SetResourceAccessForBucketRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SetResourceAccessForBucketRequest> {
        /**
         * <p>
         * The name of the Lightsail instance for which to set bucket access. The instance must be in a running or
         * stopped state.
         * </p>
         * 
         * @param resourceName
         *        The name of the Lightsail instance for which to set bucket access. The instance must be in a running
         *        or stopped state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The name of the bucket for which to set access to another Lightsail resource.
         * </p>
         * 
         * @param bucketName
         *        The name of the bucket for which to set access to another Lightsail resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The access setting.
         * </p>
         * <p>
         * The following access settings are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>allow</code> - Allows access to the bucket and its objects.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deny</code> - Denies access to the bucket and its objects. Use this setting to remove access for a
         * resource previously set to <code>allow</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param access
         *        The access setting.</p>
         *        <p>
         *        The following access settings are available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>allow</code> - Allows access to the bucket and its objects.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deny</code> - Denies access to the bucket and its objects. Use this setting to remove access for
         *        a resource previously set to <code>allow</code>.
         *        </p>
         *        </li>
         * @see ResourceBucketAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceBucketAccess
         */
        Builder access(String access);

        /**
         * <p>
         * The access setting.
         * </p>
         * <p>
         * The following access settings are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>allow</code> - Allows access to the bucket and its objects.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deny</code> - Denies access to the bucket and its objects. Use this setting to remove access for a
         * resource previously set to <code>allow</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param access
         *        The access setting.</p>
         *        <p>
         *        The following access settings are available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>allow</code> - Allows access to the bucket and its objects.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deny</code> - Denies access to the bucket and its objects. Use this setting to remove access for
         *        a resource previously set to <code>allow</code>.
         *        </p>
         *        </li>
         * @see ResourceBucketAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceBucketAccess
         */
        Builder access(ResourceBucketAccess access);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String resourceName;

        private String bucketName;

        private String access;

        private BuilderImpl() {
        }

        private BuilderImpl(SetResourceAccessForBucketRequest model) {
            super(model);
            resourceName(model.resourceName);
            bucketName(model.bucketName);
            access(model.access);
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getAccess() {
            return access;
        }

        public final void setAccess(String access) {
            this.access = access;
        }

        @Override
        public final Builder access(String access) {
            this.access = access;
            return this;
        }

        @Override
        public final Builder access(ResourceBucketAccess access) {
            this.access(access == null ? null : access.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetResourceAccessForBucketRequest build() {
            return new SetResourceAccessForBucketRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
