/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a block storage disk that is attached to an instance, and is included in an automatic snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachedDisk implements SdkPojo, Serializable, ToCopyableBuilder<AttachedDisk.Builder, AttachedDisk> {
    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("path")
            .getter(getter(AttachedDisk::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()).build();

    private static final SdkField<Integer> SIZE_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("sizeInGb").getter(getter(AttachedDisk::sizeInGb)).setter(setter(Builder::sizeInGb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInGb").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, SIZE_IN_GB_FIELD));

    private static final long serialVersionUID = 1L;

    private final String path;

    private final Integer sizeInGb;

    private AttachedDisk(BuilderImpl builder) {
        this.path = builder.path;
        this.sizeInGb = builder.sizeInGb;
    }

    /**
     * <p>
     * The path of the disk (e.g., <code>/dev/xvdf</code>).
     * </p>
     * 
     * @return The path of the disk (e.g., <code>/dev/xvdf</code>).
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The size of the disk in GB.
     * </p>
     * 
     * @return The size of the disk in GB.
     */
    public final Integer sizeInGb() {
        return sizeInGb;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInGb());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachedDisk)) {
            return false;
        }
        AttachedDisk other = (AttachedDisk) obj;
        return Objects.equals(path(), other.path()) && Objects.equals(sizeInGb(), other.sizeInGb());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttachedDisk").add("Path", path()).add("SizeInGb", sizeInGb()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "path":
            return Optional.ofNullable(clazz.cast(path()));
        case "sizeInGb":
            return Optional.ofNullable(clazz.cast(sizeInGb()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachedDisk, T> g) {
        return obj -> g.apply((AttachedDisk) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttachedDisk> {
        /**
         * <p>
         * The path of the disk (e.g., <code>/dev/xvdf</code>).
         * </p>
         * 
         * @param path
         *        The path of the disk (e.g., <code>/dev/xvdf</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The size of the disk in GB.
         * </p>
         * 
         * @param sizeInGb
         *        The size of the disk in GB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInGb(Integer sizeInGb);
    }

    static final class BuilderImpl implements Builder {
        private String path;

        private Integer sizeInGb;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachedDisk model) {
            path(model.path);
            sizeInGb(model.sizeInGb);
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Integer getSizeInGb() {
            return sizeInGb;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        @Override
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        @Override
        public AttachedDisk build() {
            return new AttachedDisk(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
