/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the monthly data transfer in and out of your virtual private server (or <i>instance</i>).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonthlyTransfer implements SdkPojo, Serializable, ToCopyableBuilder<MonthlyTransfer.Builder, MonthlyTransfer> {
    private static final SdkField<Integer> GB_PER_MONTH_ALLOCATED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("gbPerMonthAllocated").getter(getter(MonthlyTransfer::gbPerMonthAllocated))
            .setter(setter(Builder::gbPerMonthAllocated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gbPerMonthAllocated").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GB_PER_MONTH_ALLOCATED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer gbPerMonthAllocated;

    private MonthlyTransfer(BuilderImpl builder) {
        this.gbPerMonthAllocated = builder.gbPerMonthAllocated;
    }

    /**
     * <p>
     * The amount allocated per month (in GB).
     * </p>
     * 
     * @return The amount allocated per month (in GB).
     */
    public final Integer gbPerMonthAllocated() {
        return gbPerMonthAllocated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gbPerMonthAllocated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonthlyTransfer)) {
            return false;
        }
        MonthlyTransfer other = (MonthlyTransfer) obj;
        return Objects.equals(gbPerMonthAllocated(), other.gbPerMonthAllocated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonthlyTransfer").add("GbPerMonthAllocated", gbPerMonthAllocated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gbPerMonthAllocated":
            return Optional.ofNullable(clazz.cast(gbPerMonthAllocated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonthlyTransfer, T> g) {
        return obj -> g.apply((MonthlyTransfer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonthlyTransfer> {
        /**
         * <p>
         * The amount allocated per month (in GB).
         * </p>
         * 
         * @param gbPerMonthAllocated
         *        The amount allocated per month (in GB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gbPerMonthAllocated(Integer gbPerMonthAllocated);
    }

    static final class BuilderImpl implements Builder {
        private Integer gbPerMonthAllocated;

        private BuilderImpl() {
        }

        private BuilderImpl(MonthlyTransfer model) {
            gbPerMonthAllocated(model.gbPerMonthAllocated);
        }

        public final Integer getGbPerMonthAllocated() {
            return gbPerMonthAllocated;
        }

        public final void setGbPerMonthAllocated(Integer gbPerMonthAllocated) {
            this.gbPerMonthAllocated = gbPerMonthAllocated;
        }

        @Override
        public final Builder gbPerMonthAllocated(Integer gbPerMonthAllocated) {
            this.gbPerMonthAllocated = gbPerMonthAllocated;
            return this;
        }

        @Override
        public MonthlyTransfer build() {
            return new MonthlyTransfer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
