/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBucketRequest extends LightsailRequest implements
        ToCopyableBuilder<UpdateBucketRequest.Builder, UpdateBucketRequest> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketName").getter(getter(UpdateBucketRequest::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()).build();

    private static final SdkField<AccessRules> ACCESS_RULES_FIELD = SdkField.<AccessRules> builder(MarshallingType.SDK_POJO)
            .memberName("accessRules").getter(getter(UpdateBucketRequest::accessRules)).setter(setter(Builder::accessRules))
            .constructor(AccessRules::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessRules").build()).build();

    private static final SdkField<String> VERSIONING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versioning").getter(getter(UpdateBucketRequest::versioning)).setter(setter(Builder::versioning))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versioning").build()).build();

    private static final SdkField<List<String>> READONLY_ACCESS_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("readonlyAccessAccounts")
            .getter(getter(UpdateBucketRequest::readonlyAccessAccounts))
            .setter(setter(Builder::readonlyAccessAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readonlyAccessAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<BucketAccessLogConfig> ACCESS_LOG_CONFIG_FIELD = SdkField
            .<BucketAccessLogConfig> builder(MarshallingType.SDK_POJO).memberName("accessLogConfig")
            .getter(getter(UpdateBucketRequest::accessLogConfig)).setter(setter(Builder::accessLogConfig))
            .constructor(BucketAccessLogConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessLogConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD,
            ACCESS_RULES_FIELD, VERSIONING_FIELD, READONLY_ACCESS_ACCOUNTS_FIELD, ACCESS_LOG_CONFIG_FIELD));

    private final String bucketName;

    private final AccessRules accessRules;

    private final String versioning;

    private final List<String> readonlyAccessAccounts;

    private final BucketAccessLogConfig accessLogConfig;

    private UpdateBucketRequest(BuilderImpl builder) {
        super(builder);
        this.bucketName = builder.bucketName;
        this.accessRules = builder.accessRules;
        this.versioning = builder.versioning;
        this.readonlyAccessAccounts = builder.readonlyAccessAccounts;
        this.accessLogConfig = builder.accessLogConfig;
    }

    /**
     * <p>
     * The name of the bucket to update.
     * </p>
     * 
     * @return The name of the bucket to update.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * An object that sets the public accessibility of objects in the specified bucket.
     * </p>
     * 
     * @return An object that sets the public accessibility of objects in the specified bucket.
     */
    public final AccessRules accessRules() {
        return accessRules;
    }

    /**
     * <p>
     * Specifies whether to enable or suspend versioning of objects in the bucket.
     * </p>
     * <p>
     * The following options can be specified:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Enabled</code> - Enables versioning of objects in the specified bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Suspended</code> - Suspends versioning of objects in the specified bucket. Existing object versions are
     * retained.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies whether to enable or suspend versioning of objects in the bucket.</p>
     *         <p>
     *         The following options can be specified:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Enabled</code> - Enables versioning of objects in the specified bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Suspended</code> - Suspends versioning of objects in the specified bucket. Existing object versions
     *         are retained.
     *         </p>
     *         </li>
     */
    public final String versioning() {
        return versioning;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReadonlyAccessAccounts property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReadonlyAccessAccounts() {
        return readonlyAccessAccounts != null && !(readonlyAccessAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings to specify the Amazon Web Services account IDs that can access the bucket.
     * </p>
     * <p>
     * You can give a maximum of 10 Amazon Web Services accounts access to a bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReadonlyAccessAccounts} method.
     * </p>
     * 
     * @return An array of strings to specify the Amazon Web Services account IDs that can access the bucket.</p>
     *         <p>
     *         You can give a maximum of 10 Amazon Web Services accounts access to a bucket.
     */
    public final List<String> readonlyAccessAccounts() {
        return readonlyAccessAccounts;
    }

    /**
     * <p>
     * An object that describes the access log configuration for the bucket.
     * </p>
     * 
     * @return An object that describes the access log configuration for the bucket.
     */
    public final BucketAccessLogConfig accessLogConfig() {
        return accessLogConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(accessRules());
        hashCode = 31 * hashCode + Objects.hashCode(versioning());
        hashCode = 31 * hashCode + Objects.hashCode(hasReadonlyAccessAccounts() ? readonlyAccessAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(accessLogConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBucketRequest)) {
            return false;
        }
        UpdateBucketRequest other = (UpdateBucketRequest) obj;
        return Objects.equals(bucketName(), other.bucketName()) && Objects.equals(accessRules(), other.accessRules())
                && Objects.equals(versioning(), other.versioning())
                && hasReadonlyAccessAccounts() == other.hasReadonlyAccessAccounts()
                && Objects.equals(readonlyAccessAccounts(), other.readonlyAccessAccounts())
                && Objects.equals(accessLogConfig(), other.accessLogConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBucketRequest").add("BucketName", bucketName()).add("AccessRules", accessRules())
                .add("Versioning", versioning())
                .add("ReadonlyAccessAccounts", hasReadonlyAccessAccounts() ? readonlyAccessAccounts() : null)
                .add("AccessLogConfig", accessLogConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "accessRules":
            return Optional.ofNullable(clazz.cast(accessRules()));
        case "versioning":
            return Optional.ofNullable(clazz.cast(versioning()));
        case "readonlyAccessAccounts":
            return Optional.ofNullable(clazz.cast(readonlyAccessAccounts()));
        case "accessLogConfig":
            return Optional.ofNullable(clazz.cast(accessLogConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBucketRequest, T> g) {
        return obj -> g.apply((UpdateBucketRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBucketRequest> {
        /**
         * <p>
         * The name of the bucket to update.
         * </p>
         * 
         * @param bucketName
         *        The name of the bucket to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * An object that sets the public accessibility of objects in the specified bucket.
         * </p>
         * 
         * @param accessRules
         *        An object that sets the public accessibility of objects in the specified bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessRules(AccessRules accessRules);

        /**
         * <p>
         * An object that sets the public accessibility of objects in the specified bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessRules.Builder} avoiding the need to
         * create one manually via {@link AccessRules#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccessRules.Builder#build()} is called immediately and its result
         * is passed to {@link #accessRules(AccessRules)}.
         * 
         * @param accessRules
         *        a consumer that will call methods on {@link AccessRules.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessRules(AccessRules)
         */
        default Builder accessRules(Consumer<AccessRules.Builder> accessRules) {
            return accessRules(AccessRules.builder().applyMutation(accessRules).build());
        }

        /**
         * <p>
         * Specifies whether to enable or suspend versioning of objects in the bucket.
         * </p>
         * <p>
         * The following options can be specified:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Enabled</code> - Enables versioning of objects in the specified bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Suspended</code> - Suspends versioning of objects in the specified bucket. Existing object versions are
         * retained.
         * </p>
         * </li>
         * </ul>
         * 
         * @param versioning
         *        Specifies whether to enable or suspend versioning of objects in the bucket.</p>
         *        <p>
         *        The following options can be specified:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Enabled</code> - Enables versioning of objects in the specified bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Suspended</code> - Suspends versioning of objects in the specified bucket. Existing object
         *        versions are retained.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versioning(String versioning);

        /**
         * <p>
         * An array of strings to specify the Amazon Web Services account IDs that can access the bucket.
         * </p>
         * <p>
         * You can give a maximum of 10 Amazon Web Services accounts access to a bucket.
         * </p>
         * 
         * @param readonlyAccessAccounts
         *        An array of strings to specify the Amazon Web Services account IDs that can access the bucket.</p>
         *        <p>
         *        You can give a maximum of 10 Amazon Web Services accounts access to a bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readonlyAccessAccounts(Collection<String> readonlyAccessAccounts);

        /**
         * <p>
         * An array of strings to specify the Amazon Web Services account IDs that can access the bucket.
         * </p>
         * <p>
         * You can give a maximum of 10 Amazon Web Services accounts access to a bucket.
         * </p>
         * 
         * @param readonlyAccessAccounts
         *        An array of strings to specify the Amazon Web Services account IDs that can access the bucket.</p>
         *        <p>
         *        You can give a maximum of 10 Amazon Web Services accounts access to a bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readonlyAccessAccounts(String... readonlyAccessAccounts);

        /**
         * <p>
         * An object that describes the access log configuration for the bucket.
         * </p>
         * 
         * @param accessLogConfig
         *        An object that describes the access log configuration for the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessLogConfig(BucketAccessLogConfig accessLogConfig);

        /**
         * <p>
         * An object that describes the access log configuration for the bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link BucketAccessLogConfig.Builder} avoiding
         * the need to create one manually via {@link BucketAccessLogConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BucketAccessLogConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #accessLogConfig(BucketAccessLogConfig)}.
         * 
         * @param accessLogConfig
         *        a consumer that will call methods on {@link BucketAccessLogConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessLogConfig(BucketAccessLogConfig)
         */
        default Builder accessLogConfig(Consumer<BucketAccessLogConfig.Builder> accessLogConfig) {
            return accessLogConfig(BucketAccessLogConfig.builder().applyMutation(accessLogConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String bucketName;

        private AccessRules accessRules;

        private String versioning;

        private List<String> readonlyAccessAccounts = DefaultSdkAutoConstructList.getInstance();

        private BucketAccessLogConfig accessLogConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBucketRequest model) {
            super(model);
            bucketName(model.bucketName);
            accessRules(model.accessRules);
            versioning(model.versioning);
            readonlyAccessAccounts(model.readonlyAccessAccounts);
            accessLogConfig(model.accessLogConfig);
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final AccessRules.Builder getAccessRules() {
            return accessRules != null ? accessRules.toBuilder() : null;
        }

        public final void setAccessRules(AccessRules.BuilderImpl accessRules) {
            this.accessRules = accessRules != null ? accessRules.build() : null;
        }

        @Override
        public final Builder accessRules(AccessRules accessRules) {
            this.accessRules = accessRules;
            return this;
        }

        public final String getVersioning() {
            return versioning;
        }

        public final void setVersioning(String versioning) {
            this.versioning = versioning;
        }

        @Override
        public final Builder versioning(String versioning) {
            this.versioning = versioning;
            return this;
        }

        public final Collection<String> getReadonlyAccessAccounts() {
            if (readonlyAccessAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return readonlyAccessAccounts;
        }

        public final void setReadonlyAccessAccounts(Collection<String> readonlyAccessAccounts) {
            this.readonlyAccessAccounts = PartnerIdListCopier.copy(readonlyAccessAccounts);
        }

        @Override
        public final Builder readonlyAccessAccounts(Collection<String> readonlyAccessAccounts) {
            this.readonlyAccessAccounts = PartnerIdListCopier.copy(readonlyAccessAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readonlyAccessAccounts(String... readonlyAccessAccounts) {
            readonlyAccessAccounts(Arrays.asList(readonlyAccessAccounts));
            return this;
        }

        public final BucketAccessLogConfig.Builder getAccessLogConfig() {
            return accessLogConfig != null ? accessLogConfig.toBuilder() : null;
        }

        public final void setAccessLogConfig(BucketAccessLogConfig.BuilderImpl accessLogConfig) {
            this.accessLogConfig = accessLogConfig != null ? accessLogConfig.build() : null;
        }

        @Override
        public final Builder accessLogConfig(BucketAccessLogConfig accessLogConfig) {
            this.accessLogConfig = accessLogConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBucketRequest build() {
            return new UpdateBucketRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
