/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachDiskRequest extends LightsailRequest implements
        ToCopyableBuilder<AttachDiskRequest.Builder, AttachDiskRequest> {
    private static final SdkField<String> DISK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("diskName").getter(getter(AttachDiskRequest::diskName)).setter(setter(Builder::diskName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskName").build()).build();

    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceName").getter(getter(AttachDiskRequest::instanceName)).setter(setter(Builder::instanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()).build();

    private static final SdkField<String> DISK_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("diskPath").getter(getter(AttachDiskRequest::diskPath)).setter(setter(Builder::diskPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskPath").build()).build();

    private static final SdkField<Boolean> AUTO_MOUNTING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("autoMounting").getter(getter(AttachDiskRequest::autoMounting)).setter(setter(Builder::autoMounting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoMounting").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISK_NAME_FIELD,
            INSTANCE_NAME_FIELD, DISK_PATH_FIELD, AUTO_MOUNTING_FIELD));

    private final String diskName;

    private final String instanceName;

    private final String diskPath;

    private final Boolean autoMounting;

    private AttachDiskRequest(BuilderImpl builder) {
        super(builder);
        this.diskName = builder.diskName;
        this.instanceName = builder.instanceName;
        this.diskPath = builder.diskPath;
        this.autoMounting = builder.autoMounting;
    }

    /**
     * <p>
     * The unique Lightsail disk name (<code>my-disk</code>).
     * </p>
     * 
     * @return The unique Lightsail disk name (<code>my-disk</code>).
     */
    public final String diskName() {
        return diskName;
    }

    /**
     * <p>
     * The name of the Lightsail instance where you want to utilize the storage disk.
     * </p>
     * 
     * @return The name of the Lightsail instance where you want to utilize the storage disk.
     */
    public final String instanceName() {
        return instanceName;
    }

    /**
     * <p>
     * The disk path to expose to the instance (<code>/dev/xvdf</code>).
     * </p>
     * 
     * @return The disk path to expose to the instance (<code>/dev/xvdf</code>).
     */
    public final String diskPath() {
        return diskPath;
    }

    /**
     * <p>
     * A Boolean value used to determine the automatic mounting of a storage volume to a virtual computer. The default
     * value is <code>False</code>.
     * </p>
     * <important>
     * <p>
     * This value only applies to Lightsail for Research resources.
     * </p>
     * </important>
     * 
     * @return A Boolean value used to determine the automatic mounting of a storage volume to a virtual computer. The
     *         default value is <code>False</code>.</p> <important>
     *         <p>
     *         This value only applies to Lightsail for Research resources.
     *         </p>
     */
    public final Boolean autoMounting() {
        return autoMounting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(diskName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(diskPath());
        hashCode = 31 * hashCode + Objects.hashCode(autoMounting());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachDiskRequest)) {
            return false;
        }
        AttachDiskRequest other = (AttachDiskRequest) obj;
        return Objects.equals(diskName(), other.diskName()) && Objects.equals(instanceName(), other.instanceName())
                && Objects.equals(diskPath(), other.diskPath()) && Objects.equals(autoMounting(), other.autoMounting());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttachDiskRequest").add("DiskName", diskName()).add("InstanceName", instanceName())
                .add("DiskPath", diskPath()).add("AutoMounting", autoMounting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "diskName":
            return Optional.ofNullable(clazz.cast(diskName()));
        case "instanceName":
            return Optional.ofNullable(clazz.cast(instanceName()));
        case "diskPath":
            return Optional.ofNullable(clazz.cast(diskPath()));
        case "autoMounting":
            return Optional.ofNullable(clazz.cast(autoMounting()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachDiskRequest, T> g) {
        return obj -> g.apply((AttachDiskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, AttachDiskRequest> {
        /**
         * <p>
         * The unique Lightsail disk name (<code>my-disk</code>).
         * </p>
         * 
         * @param diskName
         *        The unique Lightsail disk name (<code>my-disk</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskName(String diskName);

        /**
         * <p>
         * The name of the Lightsail instance where you want to utilize the storage disk.
         * </p>
         * 
         * @param instanceName
         *        The name of the Lightsail instance where you want to utilize the storage disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);

        /**
         * <p>
         * The disk path to expose to the instance (<code>/dev/xvdf</code>).
         * </p>
         * 
         * @param diskPath
         *        The disk path to expose to the instance (<code>/dev/xvdf</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskPath(String diskPath);

        /**
         * <p>
         * A Boolean value used to determine the automatic mounting of a storage volume to a virtual computer. The
         * default value is <code>False</code>.
         * </p>
         * <important>
         * <p>
         * This value only applies to Lightsail for Research resources.
         * </p>
         * </important>
         * 
         * @param autoMounting
         *        A Boolean value used to determine the automatic mounting of a storage volume to a virtual computer.
         *        The default value is <code>False</code>.</p> <important>
         *        <p>
         *        This value only applies to Lightsail for Research resources.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMounting(Boolean autoMounting);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String diskName;

        private String instanceName;

        private String diskPath;

        private Boolean autoMounting;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachDiskRequest model) {
            super(model);
            diskName(model.diskName);
            instanceName(model.instanceName);
            diskPath(model.diskPath);
            autoMounting(model.autoMounting);
        }

        public final String getDiskName() {
            return diskName;
        }

        public final void setDiskName(String diskName) {
            this.diskName = diskName;
        }

        @Override
        public final Builder diskName(String diskName) {
            this.diskName = diskName;
            return this;
        }

        public final String getInstanceName() {
            return instanceName;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final String getDiskPath() {
            return diskPath;
        }

        public final void setDiskPath(String diskPath) {
            this.diskPath = diskPath;
        }

        @Override
        public final Builder diskPath(String diskPath) {
            this.diskPath = diskPath;
            return this;
        }

        public final Boolean getAutoMounting() {
            return autoMounting;
        }

        public final void setAutoMounting(Boolean autoMounting) {
            this.autoMounting = autoMounting;
        }

        @Override
        public final Builder autoMounting(Boolean autoMounting) {
            this.autoMounting = autoMounting;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AttachDiskRequest build() {
            return new AttachDiskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
