/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RelationalDatabaseMetricName {
    CPU_UTILIZATION("CPUUtilization"),
    DATABASE_CONNECTIONS("DatabaseConnections"),
    DISK_QUEUE_DEPTH("DiskQueueDepth"),
    FREE_STORAGE_SPACE("FreeStorageSpace"),
    NETWORK_RECEIVE_THROUGHPUT("NetworkReceiveThroughput"),
    NETWORK_TRANSMIT_THROUGHPUT("NetworkTransmitThroughput"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RelationalDatabaseMetricName> VALUE_MAP;
    private final String value;

    private RelationalDatabaseMetricName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RelationalDatabaseMetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RelationalDatabaseMetricName> knownValues() {
        EnumSet<RelationalDatabaseMetricName> knownValues = EnumSet.allOf(RelationalDatabaseMetricName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RelationalDatabaseMetricName.class, RelationalDatabaseMetricName::toString);
    }
}

