/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance (a virtual private server).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Instance implements SdkPojo, Serializable, ToCopyableBuilder<Instance.Builder, Instance> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Instance::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Instance::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> SUPPORT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("supportCode").getter(getter(Instance::supportCode)).setter(setter(Builder::supportCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportCode").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(Instance::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField
            .<ResourceLocation> builder(MarshallingType.SDK_POJO).memberName("location").getter(getter(Instance::location))
            .setter(setter(Builder::location)).constructor(ResourceLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(Instance::resourceTypeAsString)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(Instance::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BLUEPRINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blueprintId").getter(getter(Instance::blueprintId)).setter(setter(Builder::blueprintId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintId").build()).build();

    private static final SdkField<String> BLUEPRINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blueprintName").getter(getter(Instance::blueprintName)).setter(setter(Builder::blueprintName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintName").build()).build();

    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bundleId").getter(getter(Instance::bundleId)).setter(setter(Builder::bundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()).build();

    private static final SdkField<List<AddOn>> ADD_ONS_FIELD = SdkField
            .<List<AddOn>> builder(MarshallingType.LIST)
            .memberName("addOns")
            .getter(getter(Instance::addOns))
            .setter(setter(Builder::addOns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addOns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddOn> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddOn::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_STATIC_IP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isStaticIp").getter(getter(Instance::isStaticIp)).setter(setter(Builder::isStaticIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isStaticIp").build()).build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("privateIpAddress").getter(getter(Instance::privateIpAddress)).setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateIpAddress").build()).build();

    private static final SdkField<String> PUBLIC_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("publicIpAddress").getter(getter(Instance::publicIpAddress)).setter(setter(Builder::publicIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicIpAddress").build()).build();

    private static final SdkField<List<String>> IPV6_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ipv6Addresses")
            .getter(getter(Instance::ipv6Addresses))
            .setter(setter(Builder::ipv6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipv6Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipAddressType").getter(getter(Instance::ipAddressTypeAsString)).setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressType").build()).build();

    private static final SdkField<InstanceHardware> HARDWARE_FIELD = SdkField
            .<InstanceHardware> builder(MarshallingType.SDK_POJO).memberName("hardware").getter(getter(Instance::hardware))
            .setter(setter(Builder::hardware)).constructor(InstanceHardware::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hardware").build()).build();

    private static final SdkField<InstanceNetworking> NETWORKING_FIELD = SdkField
            .<InstanceNetworking> builder(MarshallingType.SDK_POJO).memberName("networking").getter(getter(Instance::networking))
            .setter(setter(Builder::networking)).constructor(InstanceNetworking::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networking").build()).build();

    private static final SdkField<InstanceState> STATE_FIELD = SdkField.<InstanceState> builder(MarshallingType.SDK_POJO)
            .memberName("state").getter(getter(Instance::state)).setter(setter(Builder::state))
            .constructor(InstanceState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("username").getter(getter(Instance::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()).build();

    private static final SdkField<String> SSH_KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sshKeyName").getter(getter(Instance::sshKeyName)).setter(setter(Builder::sshKeyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sshKeyName").build()).build();

    private static final SdkField<InstanceMetadataOptions> METADATA_OPTIONS_FIELD = SdkField
            .<InstanceMetadataOptions> builder(MarshallingType.SDK_POJO).memberName("metadataOptions")
            .getter(getter(Instance::metadataOptions)).setter(setter(Builder::metadataOptions))
            .constructor(InstanceMetadataOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            SUPPORT_CODE_FIELD, CREATED_AT_FIELD, LOCATION_FIELD, RESOURCE_TYPE_FIELD, TAGS_FIELD, BLUEPRINT_ID_FIELD,
            BLUEPRINT_NAME_FIELD, BUNDLE_ID_FIELD, ADD_ONS_FIELD, IS_STATIC_IP_FIELD, PRIVATE_IP_ADDRESS_FIELD,
            PUBLIC_IP_ADDRESS_FIELD, IPV6_ADDRESSES_FIELD, IP_ADDRESS_TYPE_FIELD, HARDWARE_FIELD, NETWORKING_FIELD, STATE_FIELD,
            USERNAME_FIELD, SSH_KEY_NAME_FIELD, METADATA_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final String supportCode;

    private final Instant createdAt;

    private final ResourceLocation location;

    private final String resourceType;

    private final List<Tag> tags;

    private final String blueprintId;

    private final String blueprintName;

    private final String bundleId;

    private final List<AddOn> addOns;

    private final Boolean isStaticIp;

    private final String privateIpAddress;

    private final String publicIpAddress;

    private final List<String> ipv6Addresses;

    private final String ipAddressType;

    private final InstanceHardware hardware;

    private final InstanceNetworking networking;

    private final InstanceState state;

    private final String username;

    private final String sshKeyName;

    private final InstanceMetadataOptions metadataOptions;

    private Instance(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.tags = builder.tags;
        this.blueprintId = builder.blueprintId;
        this.blueprintName = builder.blueprintName;
        this.bundleId = builder.bundleId;
        this.addOns = builder.addOns;
        this.isStaticIp = builder.isStaticIp;
        this.privateIpAddress = builder.privateIpAddress;
        this.publicIpAddress = builder.publicIpAddress;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.ipAddressType = builder.ipAddressType;
        this.hardware = builder.hardware;
        this.networking = builder.networking;
        this.state = builder.state;
        this.username = builder.username;
        this.sshKeyName = builder.sshKeyName;
        this.metadataOptions = builder.metadataOptions;
    }

    /**
     * <p>
     * The name the user gave the instance (<code>Amazon_Linux-1GB-Ohio-1</code>).
     * </p>
     * 
     * @return The name the user gave the instance (<code>Amazon_Linux-1GB-Ohio-1</code>).
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the instance (
     * <code>arn:aws:lightsail:us-east-2:123456789101:Instance/244ad76f-8aad-4741-809f-12345EXAMPLE</code>).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the instance (
     *         <code>arn:aws:lightsail:us-east-2:123456789101:Instance/244ad76f-8aad-4741-809f-12345EXAMPLE</code>).
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The support code. Include this code in your email to support when you have questions about an instance or another
     * resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     * </p>
     * 
     * @return The support code. Include this code in your email to support when you have questions about an instance or
     *         another resource in Lightsail. This code enables our support team to look up your Lightsail information
     *         more easily.
     */
    public final String supportCode() {
        return supportCode;
    }

    /**
     * <p>
     * The timestamp when the instance was created (<code>1479734909.17</code>) in Unix time format.
     * </p>
     * 
     * @return The timestamp when the instance was created (<code>1479734909.17</code>) in Unix time format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The region name and Availability Zone where the instance is located.
     * </p>
     * 
     * @return The region name and Availability Zone where the instance is located.
     */
    public final ResourceLocation location() {
        return location;
    }

    /**
     * <p>
     * The type of resource (usually <code>Instance</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource (usually <code>Instance</code>).
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource (usually <code>Instance</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource (usually <code>Instance</code>).
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer
     * Guide</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tag keys and optional values for the resource. For more information about tags in Lightsail, see the
     *         <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail
     *         Developer Guide</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The blueprint ID (<code>os_amlinux_2016_03</code>).
     * </p>
     * 
     * @return The blueprint ID (<code>os_amlinux_2016_03</code>).
     */
    public final String blueprintId() {
        return blueprintId;
    }

    /**
     * <p>
     * The friendly name of the blueprint (<code>Amazon Linux</code>).
     * </p>
     * 
     * @return The friendly name of the blueprint (<code>Amazon Linux</code>).
     */
    public final String blueprintName() {
        return blueprintName;
    }

    /**
     * <p>
     * The bundle for the instance (<code>micro_1_0</code>).
     * </p>
     * 
     * @return The bundle for the instance (<code>micro_1_0</code>).
     */
    public final String bundleId() {
        return bundleId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddOns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAddOns() {
        return addOns != null && !(addOns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects representing the add-ons enabled on the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddOns} method.
     * </p>
     * 
     * @return An array of objects representing the add-ons enabled on the instance.
     */
    public final List<AddOn> addOns() {
        return addOns;
    }

    /**
     * <p>
     * A Boolean value indicating whether this instance has a static IP assigned to it.
     * </p>
     * 
     * @return A Boolean value indicating whether this instance has a static IP assigned to it.
     */
    public final Boolean isStaticIp() {
        return isStaticIp;
    }

    /**
     * <p>
     * The private IP address of the instance.
     * </p>
     * 
     * @return The private IP address of the instance.
     */
    public final String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * <p>
     * The public IP address of the instance.
     * </p>
     * 
     * @return The public IP address of the instance.
     */
    public final String publicIpAddress() {
        return publicIpAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv6Addresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv6Addresses() {
        return ipv6Addresses != null && !(ipv6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv6 addresses of the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv6Addresses} method.
     * </p>
     * 
     * @return The IPv6 addresses of the instance.
     */
    public final List<String> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * <p>
     * The IP address type of the instance.
     * </p>
     * <p>
     * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type of the instance.</p>
     *         <p>
     *         The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The IP address type of the instance.
     * </p>
     * <p>
     * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type of the instance.</p>
     *         <p>
     *         The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    /**
     * <p>
     * The size of the vCPU and the amount of RAM for the instance.
     * </p>
     * 
     * @return The size of the vCPU and the amount of RAM for the instance.
     */
    public final InstanceHardware hardware() {
        return hardware;
    }

    /**
     * <p>
     * Information about the public ports and monthly data transfer rates for the instance.
     * </p>
     * 
     * @return Information about the public ports and monthly data transfer rates for the instance.
     */
    public final InstanceNetworking networking() {
        return networking;
    }

    /**
     * <p>
     * The status code and the state (<code>running</code>) for the instance.
     * </p>
     * 
     * @return The status code and the state (<code>running</code>) for the instance.
     */
    public final InstanceState state() {
        return state;
    }

    /**
     * <p>
     * The user name for connecting to the instance (<code>ec2-user</code>).
     * </p>
     * 
     * @return The user name for connecting to the instance (<code>ec2-user</code>).
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * The name of the SSH key being used to connect to the instance (<code>LightsailDefaultKeyPair</code>).
     * </p>
     * 
     * @return The name of the SSH key being used to connect to the instance (<code>LightsailDefaultKeyPair</code>).
     */
    public final String sshKeyName() {
        return sshKeyName;
    }

    /**
     * <p>
     * The metadata options for the Amazon Lightsail instance.
     * </p>
     * 
     * @return The metadata options for the Amazon Lightsail instance.
     */
    public final InstanceMetadataOptions metadataOptions() {
        return metadataOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(supportCode());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(blueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(blueprintName());
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddOns() ? addOns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isStaticIp());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(publicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6Addresses() ? ipv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hardware());
        hashCode = 31 * hashCode + Objects.hashCode(networking());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(sshKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(metadataOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(supportCode(), other.supportCode()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(location(), other.location())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(blueprintId(), other.blueprintId())
                && Objects.equals(blueprintName(), other.blueprintName()) && Objects.equals(bundleId(), other.bundleId())
                && hasAddOns() == other.hasAddOns() && Objects.equals(addOns(), other.addOns())
                && Objects.equals(isStaticIp(), other.isStaticIp())
                && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && Objects.equals(publicIpAddress(), other.publicIpAddress()) && hasIpv6Addresses() == other.hasIpv6Addresses()
                && Objects.equals(ipv6Addresses(), other.ipv6Addresses())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString())
                && Objects.equals(hardware(), other.hardware()) && Objects.equals(networking(), other.networking())
                && Objects.equals(state(), other.state()) && Objects.equals(username(), other.username())
                && Objects.equals(sshKeyName(), other.sshKeyName()) && Objects.equals(metadataOptions(), other.metadataOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Instance").add("Name", name()).add("Arn", arn()).add("SupportCode", supportCode())
                .add("CreatedAt", createdAt()).add("Location", location()).add("ResourceType", resourceTypeAsString())
                .add("Tags", hasTags() ? tags() : null).add("BlueprintId", blueprintId()).add("BlueprintName", blueprintName())
                .add("BundleId", bundleId()).add("AddOns", hasAddOns() ? addOns() : null).add("IsStaticIp", isStaticIp())
                .add("PrivateIpAddress", privateIpAddress()).add("PublicIpAddress", publicIpAddress())
                .add("Ipv6Addresses", hasIpv6Addresses() ? ipv6Addresses() : null).add("IpAddressType", ipAddressTypeAsString())
                .add("Hardware", hardware()).add("Networking", networking()).add("State", state()).add("Username", username())
                .add("SshKeyName", sshKeyName()).add("MetadataOptions", metadataOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "supportCode":
            return Optional.ofNullable(clazz.cast(supportCode()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "blueprintId":
            return Optional.ofNullable(clazz.cast(blueprintId()));
        case "blueprintName":
            return Optional.ofNullable(clazz.cast(blueprintName()));
        case "bundleId":
            return Optional.ofNullable(clazz.cast(bundleId()));
        case "addOns":
            return Optional.ofNullable(clazz.cast(addOns()));
        case "isStaticIp":
            return Optional.ofNullable(clazz.cast(isStaticIp()));
        case "privateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        case "publicIpAddress":
            return Optional.ofNullable(clazz.cast(publicIpAddress()));
        case "ipv6Addresses":
            return Optional.ofNullable(clazz.cast(ipv6Addresses()));
        case "ipAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        case "hardware":
            return Optional.ofNullable(clazz.cast(hardware()));
        case "networking":
            return Optional.ofNullable(clazz.cast(networking()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        case "username":
            return Optional.ofNullable(clazz.cast(username()));
        case "sshKeyName":
            return Optional.ofNullable(clazz.cast(sshKeyName()));
        case "metadataOptions":
            return Optional.ofNullable(clazz.cast(metadataOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Instance, T> g) {
        return obj -> g.apply((Instance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Instance> {
        /**
         * <p>
         * The name the user gave the instance (<code>Amazon_Linux-1GB-Ohio-1</code>).
         * </p>
         * 
         * @param name
         *        The name the user gave the instance (<code>Amazon_Linux-1GB-Ohio-1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the instance (
         * <code>arn:aws:lightsail:us-east-2:123456789101:Instance/244ad76f-8aad-4741-809f-12345EXAMPLE</code>).
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the instance (
         *        <code>arn:aws:lightsail:us-east-2:123456789101:Instance/244ad76f-8aad-4741-809f-12345EXAMPLE</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The support code. Include this code in your email to support when you have questions about an instance or
         * another resource in Lightsail. This code enables our support team to look up your Lightsail information more
         * easily.
         * </p>
         * 
         * @param supportCode
         *        The support code. Include this code in your email to support when you have questions about an instance
         *        or another resource in Lightsail. This code enables our support team to look up your Lightsail
         *        information more easily.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportCode(String supportCode);

        /**
         * <p>
         * The timestamp when the instance was created (<code>1479734909.17</code>) in Unix time format.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the instance was created (<code>1479734909.17</code>) in Unix time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The region name and Availability Zone where the instance is located.
         * </p>
         * 
         * @param location
         *        The region name and Availability Zone where the instance is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(ResourceLocation location);

        /**
         * <p>
         * The region name and Availability Zone where the instance is located.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceLocation.Builder} avoiding the
         * need to create one manually via {@link ResourceLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #location(ResourceLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link ResourceLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(ResourceLocation)
         */
        default Builder location(Consumer<ResourceLocation.Builder> location) {
            return location(ResourceLocation.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * The type of resource (usually <code>Instance</code>).
         * </p>
         * 
         * @param resourceType
         *        The type of resource (usually <code>Instance</code>).
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource (usually <code>Instance</code>).
         * </p>
         * 
         * @param resourceType
         *        The type of resource (usually <code>Instance</code>).
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the <a
         * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail
         * Developer Guide</a>.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values for the resource. For more information about tags in Lightsail, see
         *        the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon
         *        Lightsail Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the <a
         * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail
         * Developer Guide</a>.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values for the resource. For more information about tags in Lightsail, see
         *        the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon
         *        Lightsail Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the <a
         * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail
         * Developer Guide</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lightsail.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.lightsail.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lightsail.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lightsail.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The blueprint ID (<code>os_amlinux_2016_03</code>).
         * </p>
         * 
         * @param blueprintId
         *        The blueprint ID (<code>os_amlinux_2016_03</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintId(String blueprintId);

        /**
         * <p>
         * The friendly name of the blueprint (<code>Amazon Linux</code>).
         * </p>
         * 
         * @param blueprintName
         *        The friendly name of the blueprint (<code>Amazon Linux</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintName(String blueprintName);

        /**
         * <p>
         * The bundle for the instance (<code>micro_1_0</code>).
         * </p>
         * 
         * @param bundleId
         *        The bundle for the instance (<code>micro_1_0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * An array of objects representing the add-ons enabled on the instance.
         * </p>
         * 
         * @param addOns
         *        An array of objects representing the add-ons enabled on the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOns(Collection<AddOn> addOns);

        /**
         * <p>
         * An array of objects representing the add-ons enabled on the instance.
         * </p>
         * 
         * @param addOns
         *        An array of objects representing the add-ons enabled on the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOns(AddOn... addOns);

        /**
         * <p>
         * An array of objects representing the add-ons enabled on the instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lightsail.model.AddOn.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lightsail.model.AddOn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lightsail.model.AddOn.Builder#build()} is called immediately and its
         * result is passed to {@link #addOns(List<AddOn>)}.
         * 
         * @param addOns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lightsail.model.AddOn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addOns(java.util.Collection<AddOn>)
         */
        Builder addOns(Consumer<AddOn.Builder>... addOns);

        /**
         * <p>
         * A Boolean value indicating whether this instance has a static IP assigned to it.
         * </p>
         * 
         * @param isStaticIp
         *        A Boolean value indicating whether this instance has a static IP assigned to it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isStaticIp(Boolean isStaticIp);

        /**
         * <p>
         * The private IP address of the instance.
         * </p>
         * 
         * @param privateIpAddress
         *        The private IP address of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * The public IP address of the instance.
         * </p>
         * 
         * @param publicIpAddress
         *        The public IP address of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIpAddress(String publicIpAddress);

        /**
         * <p>
         * The IPv6 addresses of the instance.
         * </p>
         * 
         * @param ipv6Addresses
         *        The IPv6 addresses of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<String> ipv6Addresses);

        /**
         * <p>
         * The IPv6 addresses of the instance.
         * </p>
         * 
         * @param ipv6Addresses
         *        The IPv6 addresses of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(String... ipv6Addresses);

        /**
         * <p>
         * The IP address type of the instance.
         * </p>
         * <p>
         * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type of the instance.</p>
         *        <p>
         *        The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The IP address type of the instance.
         * </p>
         * <p>
         * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type of the instance.</p>
         *        <p>
         *        The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);

        /**
         * <p>
         * The size of the vCPU and the amount of RAM for the instance.
         * </p>
         * 
         * @param hardware
         *        The size of the vCPU and the amount of RAM for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hardware(InstanceHardware hardware);

        /**
         * <p>
         * The size of the vCPU and the amount of RAM for the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceHardware.Builder} avoiding the
         * need to create one manually via {@link InstanceHardware#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceHardware.Builder#build()} is called immediately and its
         * result is passed to {@link #hardware(InstanceHardware)}.
         * 
         * @param hardware
         *        a consumer that will call methods on {@link InstanceHardware.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hardware(InstanceHardware)
         */
        default Builder hardware(Consumer<InstanceHardware.Builder> hardware) {
            return hardware(InstanceHardware.builder().applyMutation(hardware).build());
        }

        /**
         * <p>
         * Information about the public ports and monthly data transfer rates for the instance.
         * </p>
         * 
         * @param networking
         *        Information about the public ports and monthly data transfer rates for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networking(InstanceNetworking networking);

        /**
         * <p>
         * Information about the public ports and monthly data transfer rates for the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceNetworking.Builder} avoiding the
         * need to create one manually via {@link InstanceNetworking#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceNetworking.Builder#build()} is called immediately and its
         * result is passed to {@link #networking(InstanceNetworking)}.
         * 
         * @param networking
         *        a consumer that will call methods on {@link InstanceNetworking.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networking(InstanceNetworking)
         */
        default Builder networking(Consumer<InstanceNetworking.Builder> networking) {
            return networking(InstanceNetworking.builder().applyMutation(networking).build());
        }

        /**
         * <p>
         * The status code and the state (<code>running</code>) for the instance.
         * </p>
         * 
         * @param state
         *        The status code and the state (<code>running</code>) for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(InstanceState state);

        /**
         * <p>
         * The status code and the state (<code>running</code>) for the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceState.Builder} avoiding the need
         * to create one manually via {@link InstanceState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceState.Builder#build()} is called immediately and its
         * result is passed to {@link #state(InstanceState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link InstanceState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(InstanceState)
         */
        default Builder state(Consumer<InstanceState.Builder> state) {
            return state(InstanceState.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * The user name for connecting to the instance (<code>ec2-user</code>).
         * </p>
         * 
         * @param username
         *        The user name for connecting to the instance (<code>ec2-user</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The name of the SSH key being used to connect to the instance (<code>LightsailDefaultKeyPair</code>).
         * </p>
         * 
         * @param sshKeyName
         *        The name of the SSH key being used to connect to the instance (<code>LightsailDefaultKeyPair</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshKeyName(String sshKeyName);

        /**
         * <p>
         * The metadata options for the Amazon Lightsail instance.
         * </p>
         * 
         * @param metadataOptions
         *        The metadata options for the Amazon Lightsail instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataOptions(InstanceMetadataOptions metadataOptions);

        /**
         * <p>
         * The metadata options for the Amazon Lightsail instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceMetadataOptions.Builder} avoiding
         * the need to create one manually via {@link InstanceMetadataOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceMetadataOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #metadataOptions(InstanceMetadataOptions)}.
         * 
         * @param metadataOptions
         *        a consumer that will call methods on {@link InstanceMetadataOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataOptions(InstanceMetadataOptions)
         */
        default Builder metadataOptions(Consumer<InstanceMetadataOptions.Builder> metadataOptions) {
            return metadataOptions(InstanceMetadataOptions.builder().applyMutation(metadataOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String supportCode;

        private Instant createdAt;

        private ResourceLocation location;

        private String resourceType;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String blueprintId;

        private String blueprintName;

        private String bundleId;

        private List<AddOn> addOns = DefaultSdkAutoConstructList.getInstance();

        private Boolean isStaticIp;

        private String privateIpAddress;

        private String publicIpAddress;

        private List<String> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();

        private String ipAddressType;

        private InstanceHardware hardware;

        private InstanceNetworking networking;

        private InstanceState state;

        private String username;

        private String sshKeyName;

        private InstanceMetadataOptions metadataOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            name(model.name);
            arn(model.arn);
            supportCode(model.supportCode);
            createdAt(model.createdAt);
            location(model.location);
            resourceType(model.resourceType);
            tags(model.tags);
            blueprintId(model.blueprintId);
            blueprintName(model.blueprintName);
            bundleId(model.bundleId);
            addOns(model.addOns);
            isStaticIp(model.isStaticIp);
            privateIpAddress(model.privateIpAddress);
            publicIpAddress(model.publicIpAddress);
            ipv6Addresses(model.ipv6Addresses);
            ipAddressType(model.ipAddressType);
            hardware(model.hardware);
            networking(model.networking);
            state(model.state);
            username(model.username);
            sshKeyName(model.sshKeyName);
            metadataOptions(model.metadataOptions);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getSupportCode() {
            return supportCode;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final ResourceLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getBlueprintId() {
            return blueprintId;
        }

        public final void setBlueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
        }

        @Override
        public final Builder blueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
            return this;
        }

        public final String getBlueprintName() {
            return blueprintName;
        }

        public final void setBlueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
        }

        @Override
        public final Builder blueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
            return this;
        }

        public final String getBundleId() {
            return bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final List<AddOn.Builder> getAddOns() {
            List<AddOn.Builder> result = AddOnListCopier.copyToBuilder(this.addOns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddOns(Collection<AddOn.BuilderImpl> addOns) {
            this.addOns = AddOnListCopier.copyFromBuilder(addOns);
        }

        @Override
        public final Builder addOns(Collection<AddOn> addOns) {
            this.addOns = AddOnListCopier.copy(addOns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOns(AddOn... addOns) {
            addOns(Arrays.asList(addOns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOns(Consumer<AddOn.Builder>... addOns) {
            addOns(Stream.of(addOns).map(c -> AddOn.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsStaticIp() {
            return isStaticIp;
        }

        public final void setIsStaticIp(Boolean isStaticIp) {
            this.isStaticIp = isStaticIp;
        }

        @Override
        public final Builder isStaticIp(Boolean isStaticIp) {
            this.isStaticIp = isStaticIp;
            return this;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final String getPublicIpAddress() {
            return publicIpAddress;
        }

        public final void setPublicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
        }

        @Override
        public final Builder publicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
            return this;
        }

        public final Collection<String> getIpv6Addresses() {
            if (ipv6Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return ipv6Addresses;
        }

        public final void setIpv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressListCopier.copy(ipv6Addresses);
        }

        @Override
        public final Builder ipv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(String... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final InstanceHardware.Builder getHardware() {
            return hardware != null ? hardware.toBuilder() : null;
        }

        public final void setHardware(InstanceHardware.BuilderImpl hardware) {
            this.hardware = hardware != null ? hardware.build() : null;
        }

        @Override
        public final Builder hardware(InstanceHardware hardware) {
            this.hardware = hardware;
            return this;
        }

        public final InstanceNetworking.Builder getNetworking() {
            return networking != null ? networking.toBuilder() : null;
        }

        public final void setNetworking(InstanceNetworking.BuilderImpl networking) {
            this.networking = networking != null ? networking.build() : null;
        }

        @Override
        public final Builder networking(InstanceNetworking networking) {
            this.networking = networking;
            return this;
        }

        public final InstanceState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(InstanceState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state = state;
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getSshKeyName() {
            return sshKeyName;
        }

        public final void setSshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
        }

        @Override
        public final Builder sshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
            return this;
        }

        public final InstanceMetadataOptions.Builder getMetadataOptions() {
            return metadataOptions != null ? metadataOptions.toBuilder() : null;
        }

        public final void setMetadataOptions(InstanceMetadataOptions.BuilderImpl metadataOptions) {
            this.metadataOptions = metadataOptions != null ? metadataOptions.build() : null;
        }

        @Override
        public final Builder metadataOptions(InstanceMetadataOptions metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        @Override
        public Instance build() {
            return new Instance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
