/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class ContainerMapCopier {
    static Map<String, Container> copy(Map<String, ? extends Container> containerMapParam) {
        Map<String, Container> map;
        if (containerMapParam == null || containerMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Container> modifiableMap = new LinkedHashMap<>(containerMapParam.size());
            containerMapParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, Container> copyFromBuilder(Map<String, ? extends Container.Builder> containerMapParam) {
        Map<String, Container> map;
        if (containerMapParam == null || containerMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Container> modifiableMap = new LinkedHashMap<>(containerMapParam.size());
            containerMapParam.forEach((key, value) -> {
                Container member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, Container.Builder> copyToBuilder(Map<String, ? extends Container> containerMapParam) {
        Map<String, Container.Builder> map;
        if (containerMapParam == null || containerMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Container.Builder> modifiableMap = new LinkedHashMap<>(containerMapParam.size());
            containerMapParam.forEach((key, value) -> {
                Container.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
