/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.LoadBalancer;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLoadBalancersResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetLoadBalancersResponse> {
    private static final SdkField<List<LoadBalancer>> LOAD_BALANCERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("loadBalancers").getter(GetLoadBalancersResponse.getter(GetLoadBalancersResponse::loadBalancers)).setter(GetLoadBalancersResponse.setter(Builder::loadBalancers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoadBalancer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(GetLoadBalancersResponse.getter(GetLoadBalancersResponse::nextPageToken)).setter(GetLoadBalancersResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCERS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("loadBalancers", LOAD_BALANCERS_FIELD);
            this.put("nextPageToken", NEXT_PAGE_TOKEN_FIELD);
        }
    });
    private final List<LoadBalancer> loadBalancers;
    private final String nextPageToken;

    private GetLoadBalancersResponse(BuilderImpl builder) {
        super(builder);
        this.loadBalancers = builder.loadBalancers;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasLoadBalancers() {
        return this.loadBalancers != null && !(this.loadBalancers instanceof SdkAutoConstructList);
    }

    public final List<LoadBalancer> loadBalancers() {
        return this.loadBalancers;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoadBalancers() ? this.loadBalancers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLoadBalancersResponse)) {
            return false;
        }
        GetLoadBalancersResponse other = (GetLoadBalancersResponse)((Object)obj);
        return this.hasLoadBalancers() == other.hasLoadBalancers() && Objects.equals(this.loadBalancers(), other.loadBalancers()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetLoadBalancersResponse").add("LoadBalancers", this.hasLoadBalancers() ? this.loadBalancers() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "loadBalancers": {
                return Optional.ofNullable(clazz.cast(this.loadBalancers()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetLoadBalancersResponse, T> g) {
        return obj -> g.apply((GetLoadBalancersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<LoadBalancer> loadBalancers = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLoadBalancersResponse model) {
            super(model);
            this.loadBalancers(model.loadBalancers);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<LoadBalancer.Builder> getLoadBalancers() {
            List<LoadBalancer.Builder> result = LoadBalancerListCopier.copyToBuilder(this.loadBalancers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoadBalancers(Collection<LoadBalancer.BuilderImpl> loadBalancers) {
            this.loadBalancers = LoadBalancerListCopier.copyFromBuilder(loadBalancers);
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancerListCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer ... loadBalancers) {
            this.loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<LoadBalancer.Builder> ... loadBalancers) {
            this.loadBalancers(Stream.of(loadBalancers).map(c -> (LoadBalancer)((LoadBalancer.Builder)LoadBalancer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetLoadBalancersResponse build() {
            return new GetLoadBalancersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLoadBalancersResponse> {
        public Builder loadBalancers(Collection<LoadBalancer> var1);

        public Builder loadBalancers(LoadBalancer ... var1);

        public Builder loadBalancers(Consumer<LoadBalancer.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

