/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.AddOn;
import software.amazon.awssdk.services.lightsail.model.AddOnListCopier;
import software.amazon.awssdk.services.lightsail.model.InstanceHardware;
import software.amazon.awssdk.services.lightsail.model.InstanceMetadataOptions;
import software.amazon.awssdk.services.lightsail.model.InstanceNetworking;
import software.amazon.awssdk.services.lightsail.model.InstanceState;
import software.amazon.awssdk.services.lightsail.model.IpAddressType;
import software.amazon.awssdk.services.lightsail.model.Ipv6AddressListCopier;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Instance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Instance> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Instance.getter(Instance::name)).setter(Instance.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Instance.getter(Instance::arn)).setter(Instance.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> SUPPORT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("supportCode").getter(Instance.getter(Instance::supportCode)).setter(Instance.setter(Builder::supportCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportCode").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Instance.getter(Instance::createdAt)).setter(Instance.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("location").getter(Instance.getter(Instance::location)).setter(Instance.setter(Builder::location)).constructor(ResourceLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(Instance.getter(Instance::resourceTypeAsString)).setter(Instance.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(Instance.getter(Instance::tags)).setter(Instance.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BLUEPRINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blueprintId").getter(Instance.getter(Instance::blueprintId)).setter(Instance.setter(Builder::blueprintId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintId").build()}).build();
    private static final SdkField<String> BLUEPRINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blueprintName").getter(Instance.getter(Instance::blueprintName)).setter(Instance.setter(Builder::blueprintName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintName").build()}).build();
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bundleId").getter(Instance.getter(Instance::bundleId)).setter(Instance.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()}).build();
    private static final SdkField<List<AddOn>> ADD_ONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("addOns").getter(Instance.getter(Instance::addOns)).setter(Instance.setter(Builder::addOns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addOns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddOn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_STATIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isStaticIp").getter(Instance.getter(Instance::isStaticIp)).setter(Instance.setter(Builder::isStaticIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isStaticIp").build()}).build();
    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("privateIpAddress").getter(Instance.getter(Instance::privateIpAddress)).setter(Instance.setter(Builder::privateIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateIpAddress").build()}).build();
    private static final SdkField<String> PUBLIC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("publicIpAddress").getter(Instance.getter(Instance::publicIpAddress)).setter(Instance.setter(Builder::publicIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicIpAddress").build()}).build();
    private static final SdkField<List<String>> IPV6_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ipv6Addresses").getter(Instance.getter(Instance::ipv6Addresses)).setter(Instance.setter(Builder::ipv6Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipv6Addresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAddressType").getter(Instance.getter(Instance::ipAddressTypeAsString)).setter(Instance.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressType").build()}).build();
    private static final SdkField<InstanceHardware> HARDWARE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("hardware").getter(Instance.getter(Instance::hardware)).setter(Instance.setter(Builder::hardware)).constructor(InstanceHardware::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hardware").build()}).build();
    private static final SdkField<InstanceNetworking> NETWORKING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networking").getter(Instance.getter(Instance::networking)).setter(Instance.setter(Builder::networking)).constructor(InstanceNetworking::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networking").build()}).build();
    private static final SdkField<InstanceState> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("state").getter(Instance.getter(Instance::state)).setter(Instance.setter(Builder::state)).constructor(InstanceState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("username").getter(Instance.getter(Instance::username)).setter(Instance.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()}).build();
    private static final SdkField<String> SSH_KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sshKeyName").getter(Instance.getter(Instance::sshKeyName)).setter(Instance.setter(Builder::sshKeyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sshKeyName").build()}).build();
    private static final SdkField<InstanceMetadataOptions> METADATA_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadataOptions").getter(Instance.getter(Instance::metadataOptions)).setter(Instance.setter(Builder::metadataOptions)).constructor(InstanceMetadataOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, SUPPORT_CODE_FIELD, CREATED_AT_FIELD, LOCATION_FIELD, RESOURCE_TYPE_FIELD, TAGS_FIELD, BLUEPRINT_ID_FIELD, BLUEPRINT_NAME_FIELD, BUNDLE_ID_FIELD, ADD_ONS_FIELD, IS_STATIC_IP_FIELD, PRIVATE_IP_ADDRESS_FIELD, PUBLIC_IP_ADDRESS_FIELD, IPV6_ADDRESSES_FIELD, IP_ADDRESS_TYPE_FIELD, HARDWARE_FIELD, NETWORKING_FIELD, STATE_FIELD, USERNAME_FIELD, SSH_KEY_NAME_FIELD, METADATA_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("arn", ARN_FIELD);
            this.put("supportCode", SUPPORT_CODE_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("location", LOCATION_FIELD);
            this.put("resourceType", RESOURCE_TYPE_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("blueprintId", BLUEPRINT_ID_FIELD);
            this.put("blueprintName", BLUEPRINT_NAME_FIELD);
            this.put("bundleId", BUNDLE_ID_FIELD);
            this.put("addOns", ADD_ONS_FIELD);
            this.put("isStaticIp", IS_STATIC_IP_FIELD);
            this.put("privateIpAddress", PRIVATE_IP_ADDRESS_FIELD);
            this.put("publicIpAddress", PUBLIC_IP_ADDRESS_FIELD);
            this.put("ipv6Addresses", IPV6_ADDRESSES_FIELD);
            this.put("ipAddressType", IP_ADDRESS_TYPE_FIELD);
            this.put("hardware", HARDWARE_FIELD);
            this.put("networking", NETWORKING_FIELD);
            this.put("state", STATE_FIELD);
            this.put("username", USERNAME_FIELD);
            this.put("sshKeyName", SSH_KEY_NAME_FIELD);
            this.put("metadataOptions", METADATA_OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String supportCode;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final String resourceType;
    private final List<Tag> tags;
    private final String blueprintId;
    private final String blueprintName;
    private final String bundleId;
    private final List<AddOn> addOns;
    private final Boolean isStaticIp;
    private final String privateIpAddress;
    private final String publicIpAddress;
    private final List<String> ipv6Addresses;
    private final String ipAddressType;
    private final InstanceHardware hardware;
    private final InstanceNetworking networking;
    private final InstanceState state;
    private final String username;
    private final String sshKeyName;
    private final InstanceMetadataOptions metadataOptions;

    private Instance(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.tags = builder.tags;
        this.blueprintId = builder.blueprintId;
        this.blueprintName = builder.blueprintName;
        this.bundleId = builder.bundleId;
        this.addOns = builder.addOns;
        this.isStaticIp = builder.isStaticIp;
        this.privateIpAddress = builder.privateIpAddress;
        this.publicIpAddress = builder.publicIpAddress;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.ipAddressType = builder.ipAddressType;
        this.hardware = builder.hardware;
        this.networking = builder.networking;
        this.state = builder.state;
        this.username = builder.username;
        this.sshKeyName = builder.sshKeyName;
        this.metadataOptions = builder.metadataOptions;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String supportCode() {
        return this.supportCode;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final ResourceLocation location() {
        return this.location;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String blueprintId() {
        return this.blueprintId;
    }

    public final String blueprintName() {
        return this.blueprintName;
    }

    public final String bundleId() {
        return this.bundleId;
    }

    public final boolean hasAddOns() {
        return this.addOns != null && !(this.addOns instanceof SdkAutoConstructList);
    }

    public final List<AddOn> addOns() {
        return this.addOns;
    }

    public final Boolean isStaticIp() {
        return this.isStaticIp;
    }

    public final String privateIpAddress() {
        return this.privateIpAddress;
    }

    public final String publicIpAddress() {
        return this.publicIpAddress;
    }

    public final boolean hasIpv6Addresses() {
        return this.ipv6Addresses != null && !(this.ipv6Addresses instanceof SdkAutoConstructList);
    }

    public final List<String> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(this.ipAddressType);
    }

    public final String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    public final InstanceHardware hardware() {
        return this.hardware;
    }

    public final InstanceNetworking networking() {
        return this.networking;
    }

    public final InstanceState state() {
        return this.state;
    }

    public final String username() {
        return this.username;
    }

    public final String sshKeyName() {
        return this.sshKeyName;
    }

    public final InstanceMetadataOptions metadataOptions() {
        return this.metadataOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddOns() ? this.addOns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isStaticIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6Addresses() ? this.ipv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hardware());
        hashCode = 31 * hashCode + Objects.hashCode(this.networking());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.supportCode(), other.supportCode()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.blueprintId(), other.blueprintId()) && Objects.equals(this.blueprintName(), other.blueprintName()) && Objects.equals(this.bundleId(), other.bundleId()) && this.hasAddOns() == other.hasAddOns() && Objects.equals(this.addOns(), other.addOns()) && Objects.equals(this.isStaticIp(), other.isStaticIp()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress()) && Objects.equals(this.publicIpAddress(), other.publicIpAddress()) && this.hasIpv6Addresses() == other.hasIpv6Addresses() && Objects.equals(this.ipv6Addresses(), other.ipv6Addresses()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString()) && Objects.equals(this.hardware(), other.hardware()) && Objects.equals(this.networking(), other.networking()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.sshKeyName(), other.sshKeyName()) && Objects.equals(this.metadataOptions(), other.metadataOptions());
    }

    public final String toString() {
        return ToString.builder((String)"Instance").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("SupportCode", (Object)this.supportCode()).add("CreatedAt", (Object)this.createdAt()).add("Location", (Object)this.location()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("BlueprintId", (Object)this.blueprintId()).add("BlueprintName", (Object)this.blueprintName()).add("BundleId", (Object)this.bundleId()).add("AddOns", this.hasAddOns() ? this.addOns() : null).add("IsStaticIp", (Object)this.isStaticIp()).add("PrivateIpAddress", (Object)this.privateIpAddress()).add("PublicIpAddress", (Object)this.publicIpAddress()).add("Ipv6Addresses", this.hasIpv6Addresses() ? this.ipv6Addresses() : null).add("IpAddressType", (Object)this.ipAddressTypeAsString()).add("Hardware", (Object)this.hardware()).add("Networking", (Object)this.networking()).add("State", (Object)this.state()).add("Username", (Object)this.username()).add("SshKeyName", (Object)this.sshKeyName()).add("MetadataOptions", (Object)this.metadataOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "supportCode": {
                return Optional.ofNullable(clazz.cast(this.supportCode()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "blueprintId": {
                return Optional.ofNullable(clazz.cast(this.blueprintId()));
            }
            case "blueprintName": {
                return Optional.ofNullable(clazz.cast(this.blueprintName()));
            }
            case "bundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "addOns": {
                return Optional.ofNullable(clazz.cast(this.addOns()));
            }
            case "isStaticIp": {
                return Optional.ofNullable(clazz.cast(this.isStaticIp()));
            }
            case "privateIpAddress": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddress()));
            }
            case "publicIpAddress": {
                return Optional.ofNullable(clazz.cast(this.publicIpAddress()));
            }
            case "ipv6Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipv6Addresses()));
            }
            case "ipAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
            case "hardware": {
                return Optional.ofNullable(clazz.cast(this.hardware()));
            }
            case "networking": {
                return Optional.ofNullable(clazz.cast(this.networking()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "sshKeyName": {
                return Optional.ofNullable(clazz.cast(this.sshKeyName()));
            }
            case "metadataOptions": {
                return Optional.ofNullable(clazz.cast(this.metadataOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Instance, T> g) {
        return obj -> g.apply((Instance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String supportCode;
        private Instant createdAt;
        private ResourceLocation location;
        private String resourceType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String blueprintId;
        private String blueprintName;
        private String bundleId;
        private List<AddOn> addOns = DefaultSdkAutoConstructList.getInstance();
        private Boolean isStaticIp;
        private String privateIpAddress;
        private String publicIpAddress;
        private List<String> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();
        private String ipAddressType;
        private InstanceHardware hardware;
        private InstanceNetworking networking;
        private InstanceState state;
        private String username;
        private String sshKeyName;
        private InstanceMetadataOptions metadataOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            this.name(model.name);
            this.arn(model.arn);
            this.supportCode(model.supportCode);
            this.createdAt(model.createdAt);
            this.location(model.location);
            this.resourceType(model.resourceType);
            this.tags(model.tags);
            this.blueprintId(model.blueprintId);
            this.blueprintName(model.blueprintName);
            this.bundleId(model.bundleId);
            this.addOns(model.addOns);
            this.isStaticIp(model.isStaticIp);
            this.privateIpAddress(model.privateIpAddress);
            this.publicIpAddress(model.publicIpAddress);
            this.ipv6Addresses(model.ipv6Addresses);
            this.ipAddressType(model.ipAddressType);
            this.hardware(model.hardware);
            this.networking(model.networking);
            this.state(model.state);
            this.username(model.username);
            this.sshKeyName(model.sshKeyName);
            this.metadataOptions(model.metadataOptions);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getSupportCode() {
            return this.supportCode;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final ResourceLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getBlueprintId() {
            return this.blueprintId;
        }

        public final void setBlueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
        }

        @Override
        public final Builder blueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
            return this;
        }

        public final String getBlueprintName() {
            return this.blueprintName;
        }

        public final void setBlueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
        }

        @Override
        public final Builder blueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
            return this;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final List<AddOn.Builder> getAddOns() {
            List<AddOn.Builder> result = AddOnListCopier.copyToBuilder(this.addOns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddOns(Collection<AddOn.BuilderImpl> addOns) {
            this.addOns = AddOnListCopier.copyFromBuilder(addOns);
        }

        @Override
        public final Builder addOns(Collection<AddOn> addOns) {
            this.addOns = AddOnListCopier.copy(addOns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOns(AddOn ... addOns) {
            this.addOns(Arrays.asList(addOns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOns(Consumer<AddOn.Builder> ... addOns) {
            this.addOns(Stream.of(addOns).map(c -> (AddOn)((AddOn.Builder)AddOn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsStaticIp() {
            return this.isStaticIp;
        }

        public final void setIsStaticIp(Boolean isStaticIp) {
            this.isStaticIp = isStaticIp;
        }

        @Override
        public final Builder isStaticIp(Boolean isStaticIp) {
            this.isStaticIp = isStaticIp;
            return this;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final String getPublicIpAddress() {
            return this.publicIpAddress;
        }

        public final void setPublicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
        }

        @Override
        public final Builder publicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
            return this;
        }

        public final Collection<String> getIpv6Addresses() {
            if (this.ipv6Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipv6Addresses;
        }

        public final void setIpv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressListCopier.copy(ipv6Addresses);
        }

        @Override
        public final Builder ipv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(String ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final InstanceHardware.Builder getHardware() {
            return this.hardware != null ? this.hardware.toBuilder() : null;
        }

        public final void setHardware(InstanceHardware.BuilderImpl hardware) {
            this.hardware = hardware != null ? hardware.build() : null;
        }

        @Override
        public final Builder hardware(InstanceHardware hardware) {
            this.hardware = hardware;
            return this;
        }

        public final InstanceNetworking.Builder getNetworking() {
            return this.networking != null ? this.networking.toBuilder() : null;
        }

        public final void setNetworking(InstanceNetworking.BuilderImpl networking) {
            this.networking = networking != null ? networking.build() : null;
        }

        @Override
        public final Builder networking(InstanceNetworking networking) {
            this.networking = networking;
            return this;
        }

        public final InstanceState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        public final void setState(InstanceState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state = state;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getSshKeyName() {
            return this.sshKeyName;
        }

        public final void setSshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
        }

        @Override
        public final Builder sshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
            return this;
        }

        public final InstanceMetadataOptions.Builder getMetadataOptions() {
            return this.metadataOptions != null ? this.metadataOptions.toBuilder() : null;
        }

        public final void setMetadataOptions(InstanceMetadataOptions.BuilderImpl metadataOptions) {
            this.metadataOptions = metadataOptions != null ? metadataOptions.build() : null;
        }

        @Override
        public final Builder metadataOptions(InstanceMetadataOptions metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        public Instance build() {
            return new Instance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Instance> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder supportCode(String var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        default public Builder location(Consumer<ResourceLocation.Builder> location) {
            return this.location((ResourceLocation)((ResourceLocation.Builder)ResourceLocation.builder().applyMutation(location)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder blueprintId(String var1);

        public Builder blueprintName(String var1);

        public Builder bundleId(String var1);

        public Builder addOns(Collection<AddOn> var1);

        public Builder addOns(AddOn ... var1);

        public Builder addOns(Consumer<AddOn.Builder> ... var1);

        public Builder isStaticIp(Boolean var1);

        public Builder privateIpAddress(String var1);

        public Builder publicIpAddress(String var1);

        public Builder ipv6Addresses(Collection<String> var1);

        public Builder ipv6Addresses(String ... var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IpAddressType var1);

        public Builder hardware(InstanceHardware var1);

        default public Builder hardware(Consumer<InstanceHardware.Builder> hardware) {
            return this.hardware((InstanceHardware)((InstanceHardware.Builder)InstanceHardware.builder().applyMutation(hardware)).build());
        }

        public Builder networking(InstanceNetworking var1);

        default public Builder networking(Consumer<InstanceNetworking.Builder> networking) {
            return this.networking((InstanceNetworking)((InstanceNetworking.Builder)InstanceNetworking.builder().applyMutation(networking)).build());
        }

        public Builder state(InstanceState var1);

        default public Builder state(Consumer<InstanceState.Builder> state) {
            return this.state((InstanceState)((InstanceState.Builder)InstanceState.builder().applyMutation(state)).build());
        }

        public Builder username(String var1);

        public Builder sshKeyName(String var1);

        public Builder metadataOptions(InstanceMetadataOptions var1);

        default public Builder metadataOptions(Consumer<InstanceMetadataOptions.Builder> metadataOptions) {
            return this.metadataOptions((InstanceMetadataOptions)((InstanceMetadataOptions.Builder)InstanceMetadataOptions.builder().applyMutation(metadataOptions)).build());
        }
    }
}

