/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRelationalDatabaseResponse extends LightsailResponse implements
        ToCopyableBuilder<GetRelationalDatabaseResponse.Builder, GetRelationalDatabaseResponse> {
    private static final SdkField<RelationalDatabase> RELATIONAL_DATABASE_FIELD = SdkField
            .<RelationalDatabase> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetRelationalDatabaseResponse::relationalDatabase)).setter(setter(Builder::relationalDatabase))
            .constructor(RelationalDatabase::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabase").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIONAL_DATABASE_FIELD));

    private final RelationalDatabase relationalDatabase;

    private GetRelationalDatabaseResponse(BuilderImpl builder) {
        super(builder);
        this.relationalDatabase = builder.relationalDatabase;
    }

    /**
     * <p>
     * An object describing the specified database.
     * </p>
     * 
     * @return An object describing the specified database.
     */
    public RelationalDatabase relationalDatabase() {
        return relationalDatabase;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(relationalDatabase());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabaseResponse)) {
            return false;
        }
        GetRelationalDatabaseResponse other = (GetRelationalDatabaseResponse) obj;
        return Objects.equals(relationalDatabase(), other.relationalDatabase());
    }

    @Override
    public String toString() {
        return ToString.builder("GetRelationalDatabaseResponse").add("RelationalDatabase", relationalDatabase()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relationalDatabase":
            return Optional.ofNullable(clazz.cast(relationalDatabase()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRelationalDatabaseResponse, T> g) {
        return obj -> g.apply((GetRelationalDatabaseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRelationalDatabaseResponse> {
        /**
         * <p>
         * An object describing the specified database.
         * </p>
         * 
         * @param relationalDatabase
         *        An object describing the specified database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabase(RelationalDatabase relationalDatabase);

        /**
         * <p>
         * An object describing the specified database.
         * </p>
         * This is a convenience that creates an instance of the {@link RelationalDatabase.Builder} avoiding the need to
         * create one manually via {@link RelationalDatabase#builder()}.
         *
         * When the {@link Consumer} completes, {@link RelationalDatabase.Builder#build()} is called immediately and its
         * result is passed to {@link #relationalDatabase(RelationalDatabase)}.
         * 
         * @param relationalDatabase
         *        a consumer that will call methods on {@link RelationalDatabase.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relationalDatabase(RelationalDatabase)
         */
        default Builder relationalDatabase(Consumer<RelationalDatabase.Builder> relationalDatabase) {
            return relationalDatabase(RelationalDatabase.builder().applyMutation(relationalDatabase).build());
        }
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private RelationalDatabase relationalDatabase;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationalDatabaseResponse model) {
            super(model);
            relationalDatabase(model.relationalDatabase);
        }

        public final RelationalDatabase.Builder getRelationalDatabase() {
            return relationalDatabase != null ? relationalDatabase.toBuilder() : null;
        }

        @Override
        public final Builder relationalDatabase(RelationalDatabase relationalDatabase) {
            this.relationalDatabase = relationalDatabase;
            return this;
        }

        public final void setRelationalDatabase(RelationalDatabase.BuilderImpl relationalDatabase) {
            this.relationalDatabase = relationalDatabase != null ? relationalDatabase.build() : null;
        }

        @Override
        public GetRelationalDatabaseResponse build() {
            return new GetRelationalDatabaseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
