/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a database bundle. A bundle describes the performance specifications of the database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelationalDatabaseBundle implements SdkPojo, Serializable,
        ToCopyableBuilder<RelationalDatabaseBundle.Builder, RelationalDatabaseBundle> {
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RelationalDatabaseBundle::bundleId)).setter(setter(Builder::bundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RelationalDatabaseBundle::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Float> PRICE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .getter(getter(RelationalDatabaseBundle::price)).setter(setter(Builder::price))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("price").build()).build();

    private static final SdkField<Float> RAM_SIZE_IN_GB_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .getter(getter(RelationalDatabaseBundle::ramSizeInGb)).setter(setter(Builder::ramSizeInGb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ramSizeInGb").build()).build();

    private static final SdkField<Integer> DISK_SIZE_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RelationalDatabaseBundle::diskSizeInGb)).setter(setter(Builder::diskSizeInGb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskSizeInGb").build()).build();

    private static final SdkField<Integer> TRANSFER_PER_MONTH_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RelationalDatabaseBundle::transferPerMonthInGb)).setter(setter(Builder::transferPerMonthInGb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transferPerMonthInGb").build())
            .build();

    private static final SdkField<Integer> CPU_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RelationalDatabaseBundle::cpuCount)).setter(setter(Builder::cpuCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCount").build()).build();

    private static final SdkField<Boolean> IS_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(RelationalDatabaseBundle::isEncrypted)).setter(setter(Builder::isEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isEncrypted").build()).build();

    private static final SdkField<Boolean> IS_ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(RelationalDatabaseBundle::isActive)).setter(setter(Builder::isActive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isActive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_ID_FIELD, NAME_FIELD,
            PRICE_FIELD, RAM_SIZE_IN_GB_FIELD, DISK_SIZE_IN_GB_FIELD, TRANSFER_PER_MONTH_IN_GB_FIELD, CPU_COUNT_FIELD,
            IS_ENCRYPTED_FIELD, IS_ACTIVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bundleId;

    private final String name;

    private final Float price;

    private final Float ramSizeInGb;

    private final Integer diskSizeInGb;

    private final Integer transferPerMonthInGb;

    private final Integer cpuCount;

    private final Boolean isEncrypted;

    private final Boolean isActive;

    private RelationalDatabaseBundle(BuilderImpl builder) {
        this.bundleId = builder.bundleId;
        this.name = builder.name;
        this.price = builder.price;
        this.ramSizeInGb = builder.ramSizeInGb;
        this.diskSizeInGb = builder.diskSizeInGb;
        this.transferPerMonthInGb = builder.transferPerMonthInGb;
        this.cpuCount = builder.cpuCount;
        this.isEncrypted = builder.isEncrypted;
        this.isActive = builder.isActive;
    }

    /**
     * <p>
     * The ID for the database bundle.
     * </p>
     * 
     * @return The ID for the database bundle.
     */
    public String bundleId() {
        return bundleId;
    }

    /**
     * <p>
     * The name for the database bundle.
     * </p>
     * 
     * @return The name for the database bundle.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The cost of the database bundle in US currency.
     * </p>
     * 
     * @return The cost of the database bundle in US currency.
     */
    public Float price() {
        return price;
    }

    /**
     * <p>
     * The amount of RAM in GB (for example, <code>2.0</code>) for the database bundle.
     * </p>
     * 
     * @return The amount of RAM in GB (for example, <code>2.0</code>) for the database bundle.
     */
    public Float ramSizeInGb() {
        return ramSizeInGb;
    }

    /**
     * <p>
     * The size of the disk for the database bundle.
     * </p>
     * 
     * @return The size of the disk for the database bundle.
     */
    public Integer diskSizeInGb() {
        return diskSizeInGb;
    }

    /**
     * <p>
     * The data transfer rate per month in GB for the database bundle.
     * </p>
     * 
     * @return The data transfer rate per month in GB for the database bundle.
     */
    public Integer transferPerMonthInGb() {
        return transferPerMonthInGb;
    }

    /**
     * <p>
     * The number of virtual CPUs (vCPUs) for the database bundle.
     * </p>
     * 
     * @return The number of virtual CPUs (vCPUs) for the database bundle.
     */
    public Integer cpuCount() {
        return cpuCount;
    }

    /**
     * <p>
     * A Boolean value indicating whether the database bundle is encrypted.
     * </p>
     * 
     * @return A Boolean value indicating whether the database bundle is encrypted.
     */
    public Boolean isEncrypted() {
        return isEncrypted;
    }

    /**
     * <p>
     * A Boolean value indicating whether the database bundle is active.
     * </p>
     * 
     * @return A Boolean value indicating whether the database bundle is active.
     */
    public Boolean isActive() {
        return isActive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(price());
        hashCode = 31 * hashCode + Objects.hashCode(ramSizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(diskSizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(transferPerMonthInGb());
        hashCode = 31 * hashCode + Objects.hashCode(cpuCount());
        hashCode = 31 * hashCode + Objects.hashCode(isEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(isActive());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationalDatabaseBundle)) {
            return false;
        }
        RelationalDatabaseBundle other = (RelationalDatabaseBundle) obj;
        return Objects.equals(bundleId(), other.bundleId()) && Objects.equals(name(), other.name())
                && Objects.equals(price(), other.price()) && Objects.equals(ramSizeInGb(), other.ramSizeInGb())
                && Objects.equals(diskSizeInGb(), other.diskSizeInGb())
                && Objects.equals(transferPerMonthInGb(), other.transferPerMonthInGb())
                && Objects.equals(cpuCount(), other.cpuCount()) && Objects.equals(isEncrypted(), other.isEncrypted())
                && Objects.equals(isActive(), other.isActive());
    }

    @Override
    public String toString() {
        return ToString.builder("RelationalDatabaseBundle").add("BundleId", bundleId()).add("Name", name()).add("Price", price())
                .add("RamSizeInGb", ramSizeInGb()).add("DiskSizeInGb", diskSizeInGb())
                .add("TransferPerMonthInGb", transferPerMonthInGb()).add("CpuCount", cpuCount())
                .add("IsEncrypted", isEncrypted()).add("IsActive", isActive()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bundleId":
            return Optional.ofNullable(clazz.cast(bundleId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "price":
            return Optional.ofNullable(clazz.cast(price()));
        case "ramSizeInGb":
            return Optional.ofNullable(clazz.cast(ramSizeInGb()));
        case "diskSizeInGb":
            return Optional.ofNullable(clazz.cast(diskSizeInGb()));
        case "transferPerMonthInGb":
            return Optional.ofNullable(clazz.cast(transferPerMonthInGb()));
        case "cpuCount":
            return Optional.ofNullable(clazz.cast(cpuCount()));
        case "isEncrypted":
            return Optional.ofNullable(clazz.cast(isEncrypted()));
        case "isActive":
            return Optional.ofNullable(clazz.cast(isActive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelationalDatabaseBundle, T> g) {
        return obj -> g.apply((RelationalDatabaseBundle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelationalDatabaseBundle> {
        /**
         * <p>
         * The ID for the database bundle.
         * </p>
         * 
         * @param bundleId
         *        The ID for the database bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * The name for the database bundle.
         * </p>
         * 
         * @param name
         *        The name for the database bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The cost of the database bundle in US currency.
         * </p>
         * 
         * @param price
         *        The cost of the database bundle in US currency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder price(Float price);

        /**
         * <p>
         * The amount of RAM in GB (for example, <code>2.0</code>) for the database bundle.
         * </p>
         * 
         * @param ramSizeInGb
         *        The amount of RAM in GB (for example, <code>2.0</code>) for the database bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramSizeInGb(Float ramSizeInGb);

        /**
         * <p>
         * The size of the disk for the database bundle.
         * </p>
         * 
         * @param diskSizeInGb
         *        The size of the disk for the database bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskSizeInGb(Integer diskSizeInGb);

        /**
         * <p>
         * The data transfer rate per month in GB for the database bundle.
         * </p>
         * 
         * @param transferPerMonthInGb
         *        The data transfer rate per month in GB for the database bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferPerMonthInGb(Integer transferPerMonthInGb);

        /**
         * <p>
         * The number of virtual CPUs (vCPUs) for the database bundle.
         * </p>
         * 
         * @param cpuCount
         *        The number of virtual CPUs (vCPUs) for the database bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuCount(Integer cpuCount);

        /**
         * <p>
         * A Boolean value indicating whether the database bundle is encrypted.
         * </p>
         * 
         * @param isEncrypted
         *        A Boolean value indicating whether the database bundle is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isEncrypted(Boolean isEncrypted);

        /**
         * <p>
         * A Boolean value indicating whether the database bundle is active.
         * </p>
         * 
         * @param isActive
         *        A Boolean value indicating whether the database bundle is active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isActive(Boolean isActive);
    }

    static final class BuilderImpl implements Builder {
        private String bundleId;

        private String name;

        private Float price;

        private Float ramSizeInGb;

        private Integer diskSizeInGb;

        private Integer transferPerMonthInGb;

        private Integer cpuCount;

        private Boolean isEncrypted;

        private Boolean isActive;

        private BuilderImpl() {
        }

        private BuilderImpl(RelationalDatabaseBundle model) {
            bundleId(model.bundleId);
            name(model.name);
            price(model.price);
            ramSizeInGb(model.ramSizeInGb);
            diskSizeInGb(model.diskSizeInGb);
            transferPerMonthInGb(model.transferPerMonthInGb);
            cpuCount(model.cpuCount);
            isEncrypted(model.isEncrypted);
            isActive(model.isActive);
        }

        public final String getBundleId() {
            return bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Float getPrice() {
            return price;
        }

        @Override
        public final Builder price(Float price) {
            this.price = price;
            return this;
        }

        public final void setPrice(Float price) {
            this.price = price;
        }

        public final Float getRamSizeInGb() {
            return ramSizeInGb;
        }

        @Override
        public final Builder ramSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
            return this;
        }

        public final void setRamSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
        }

        public final Integer getDiskSizeInGb() {
            return diskSizeInGb;
        }

        @Override
        public final Builder diskSizeInGb(Integer diskSizeInGb) {
            this.diskSizeInGb = diskSizeInGb;
            return this;
        }

        public final void setDiskSizeInGb(Integer diskSizeInGb) {
            this.diskSizeInGb = diskSizeInGb;
        }

        public final Integer getTransferPerMonthInGb() {
            return transferPerMonthInGb;
        }

        @Override
        public final Builder transferPerMonthInGb(Integer transferPerMonthInGb) {
            this.transferPerMonthInGb = transferPerMonthInGb;
            return this;
        }

        public final void setTransferPerMonthInGb(Integer transferPerMonthInGb) {
            this.transferPerMonthInGb = transferPerMonthInGb;
        }

        public final Integer getCpuCount() {
            return cpuCount;
        }

        @Override
        public final Builder cpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
            return this;
        }

        public final void setCpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
        }

        public final Boolean getIsEncrypted() {
            return isEncrypted;
        }

        @Override
        public final Builder isEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
            return this;
        }

        public final void setIsEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
        }

        public final Boolean getIsActive() {
            return isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        @Override
        public RelationalDatabaseBundle build() {
            return new RelationalDatabaseBundle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
