/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExportSnapshotRecordsResponse extends LightsailResponse implements
        ToCopyableBuilder<GetExportSnapshotRecordsResponse.Builder, GetExportSnapshotRecordsResponse> {
    private static final SdkField<List<ExportSnapshotRecord>> EXPORT_SNAPSHOT_RECORDS_FIELD = SdkField
            .<List<ExportSnapshotRecord>> builder(MarshallingType.LIST)
            .getter(getter(GetExportSnapshotRecordsResponse::exportSnapshotRecords))
            .setter(setter(Builder::exportSnapshotRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportSnapshotRecords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExportSnapshotRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExportSnapshotRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetExportSnapshotRecordsResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_SNAPSHOT_RECORDS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<ExportSnapshotRecord> exportSnapshotRecords;

    private final String nextPageToken;

    private GetExportSnapshotRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.exportSnapshotRecords = builder.exportSnapshotRecords;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * A list of objects describing the export snapshot records.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of objects describing the export snapshot records.
     */
    public List<ExportSnapshotRecord> exportSnapshotRecords() {
        return exportSnapshotRecords;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results of your get relational database bundles request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results of your get relational database bundles request.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exportSnapshotRecords());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExportSnapshotRecordsResponse)) {
            return false;
        }
        GetExportSnapshotRecordsResponse other = (GetExportSnapshotRecordsResponse) obj;
        return Objects.equals(exportSnapshotRecords(), other.exportSnapshotRecords())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetExportSnapshotRecordsResponse").add("ExportSnapshotRecords", exportSnapshotRecords())
                .add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exportSnapshotRecords":
            return Optional.ofNullable(clazz.cast(exportSnapshotRecords()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetExportSnapshotRecordsResponse, T> g) {
        return obj -> g.apply((GetExportSnapshotRecordsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetExportSnapshotRecordsResponse> {
        /**
         * <p>
         * A list of objects describing the export snapshot records.
         * </p>
         * 
         * @param exportSnapshotRecords
         *        A list of objects describing the export snapshot records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportSnapshotRecords(Collection<ExportSnapshotRecord> exportSnapshotRecords);

        /**
         * <p>
         * A list of objects describing the export snapshot records.
         * </p>
         * 
         * @param exportSnapshotRecords
         *        A list of objects describing the export snapshot records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportSnapshotRecords(ExportSnapshotRecord... exportSnapshotRecords);

        /**
         * <p>
         * A list of objects describing the export snapshot records.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ExportSnapshotRecord>.Builder} avoiding the
         * need to create one manually via {@link List<ExportSnapshotRecord>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExportSnapshotRecord>.Builder#build()} is called immediately
         * and its result is passed to {@link #exportSnapshotRecords(List<ExportSnapshotRecord>)}.
         * 
         * @param exportSnapshotRecords
         *        a consumer that will call methods on {@link List<ExportSnapshotRecord>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportSnapshotRecords(List<ExportSnapshotRecord>)
         */
        Builder exportSnapshotRecords(Consumer<ExportSnapshotRecord.Builder>... exportSnapshotRecords);

        /**
         * <p>
         * A token used for advancing to the next page of results of your get relational database bundles request.
         * </p>
         * 
         * @param nextPageToken
         *        A token used for advancing to the next page of results of your get relational database bundles
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<ExportSnapshotRecord> exportSnapshotRecords = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExportSnapshotRecordsResponse model) {
            super(model);
            exportSnapshotRecords(model.exportSnapshotRecords);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<ExportSnapshotRecord.Builder> getExportSnapshotRecords() {
            return exportSnapshotRecords != null ? exportSnapshotRecords.stream().map(ExportSnapshotRecord::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder exportSnapshotRecords(Collection<ExportSnapshotRecord> exportSnapshotRecords) {
            this.exportSnapshotRecords = ExportSnapshotRecordListCopier.copy(exportSnapshotRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportSnapshotRecords(ExportSnapshotRecord... exportSnapshotRecords) {
            exportSnapshotRecords(Arrays.asList(exportSnapshotRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportSnapshotRecords(Consumer<ExportSnapshotRecord.Builder>... exportSnapshotRecords) {
            exportSnapshotRecords(Stream.of(exportSnapshotRecords)
                    .map(c -> ExportSnapshotRecord.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExportSnapshotRecords(Collection<ExportSnapshotRecord.BuilderImpl> exportSnapshotRecords) {
            this.exportSnapshotRecords = ExportSnapshotRecordListCopier.copyFromBuilder(exportSnapshotRecords);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetExportSnapshotRecordsResponse build() {
            return new GetExportSnapshotRecordsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
