/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLoadBalancerTlsCertificatesResponse extends LightsailResponse implements
        ToCopyableBuilder<GetLoadBalancerTlsCertificatesResponse.Builder, GetLoadBalancerTlsCertificatesResponse> {
    private static final SdkField<List<LoadBalancerTlsCertificate>> TLS_CERTIFICATES_FIELD = SdkField
            .<List<LoadBalancerTlsCertificate>> builder(MarshallingType.LIST)
            .getter(getter(GetLoadBalancerTlsCertificatesResponse::tlsCertificates))
            .setter(setter(Builder::tlsCertificates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tlsCertificates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoadBalancerTlsCertificate> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadBalancerTlsCertificate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TLS_CERTIFICATES_FIELD));

    private final List<LoadBalancerTlsCertificate> tlsCertificates;

    private GetLoadBalancerTlsCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.tlsCertificates = builder.tlsCertificates;
    }

    /**
     * <p>
     * An array of LoadBalancerTlsCertificate objects describing your SSL/TLS certificates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of LoadBalancerTlsCertificate objects describing your SSL/TLS certificates.
     */
    public List<LoadBalancerTlsCertificate> tlsCertificates() {
        return tlsCertificates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tlsCertificates());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLoadBalancerTlsCertificatesResponse)) {
            return false;
        }
        GetLoadBalancerTlsCertificatesResponse other = (GetLoadBalancerTlsCertificatesResponse) obj;
        return Objects.equals(tlsCertificates(), other.tlsCertificates());
    }

    @Override
    public String toString() {
        return ToString.builder("GetLoadBalancerTlsCertificatesResponse").add("TlsCertificates", tlsCertificates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tlsCertificates":
            return Optional.ofNullable(clazz.cast(tlsCertificates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLoadBalancerTlsCertificatesResponse, T> g) {
        return obj -> g.apply((GetLoadBalancerTlsCertificatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetLoadBalancerTlsCertificatesResponse> {
        /**
         * <p>
         * An array of LoadBalancerTlsCertificate objects describing your SSL/TLS certificates.
         * </p>
         * 
         * @param tlsCertificates
         *        An array of LoadBalancerTlsCertificate objects describing your SSL/TLS certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsCertificates(Collection<LoadBalancerTlsCertificate> tlsCertificates);

        /**
         * <p>
         * An array of LoadBalancerTlsCertificate objects describing your SSL/TLS certificates.
         * </p>
         * 
         * @param tlsCertificates
         *        An array of LoadBalancerTlsCertificate objects describing your SSL/TLS certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsCertificates(LoadBalancerTlsCertificate... tlsCertificates);

        /**
         * <p>
         * An array of LoadBalancerTlsCertificate objects describing your SSL/TLS certificates.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LoadBalancerTlsCertificate>.Builder}
         * avoiding the need to create one manually via {@link List<LoadBalancerTlsCertificate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LoadBalancerTlsCertificate>.Builder#build()} is called
         * immediately and its result is passed to {@link #tlsCertificates(List<LoadBalancerTlsCertificate>)}.
         * 
         * @param tlsCertificates
         *        a consumer that will call methods on {@link List<LoadBalancerTlsCertificate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tlsCertificates(List<LoadBalancerTlsCertificate>)
         */
        Builder tlsCertificates(Consumer<LoadBalancerTlsCertificate.Builder>... tlsCertificates);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<LoadBalancerTlsCertificate> tlsCertificates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLoadBalancerTlsCertificatesResponse model) {
            super(model);
            tlsCertificates(model.tlsCertificates);
        }

        public final Collection<LoadBalancerTlsCertificate.Builder> getTlsCertificates() {
            return tlsCertificates != null ? tlsCertificates.stream().map(LoadBalancerTlsCertificate::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tlsCertificates(Collection<LoadBalancerTlsCertificate> tlsCertificates) {
            this.tlsCertificates = LoadBalancerTlsCertificateListCopier.copy(tlsCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tlsCertificates(LoadBalancerTlsCertificate... tlsCertificates) {
            tlsCertificates(Arrays.asList(tlsCertificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tlsCertificates(Consumer<LoadBalancerTlsCertificate.Builder>... tlsCertificates) {
            tlsCertificates(Stream.of(tlsCertificates).map(c -> LoadBalancerTlsCertificate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTlsCertificates(Collection<LoadBalancerTlsCertificate.BuilderImpl> tlsCertificates) {
            this.tlsCertificates = LoadBalancerTlsCertificateListCopier.copyFromBuilder(tlsCertificates);
        }

        @Override
        public GetLoadBalancerTlsCertificatesResponse build() {
            return new GetLoadBalancerTlsCertificatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
