/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRelationalDatabaseParametersResponse extends LightsailResponse implements
        ToCopyableBuilder<GetRelationalDatabaseParametersResponse.Builder, GetRelationalDatabaseParametersResponse> {
    private static final SdkField<List<RelationalDatabaseParameter>> PARAMETERS_FIELD = SdkField
            .<List<RelationalDatabaseParameter>> builder(MarshallingType.LIST)
            .getter(getter(GetRelationalDatabaseParametersResponse::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RelationalDatabaseParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(RelationalDatabaseParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetRelationalDatabaseParametersResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETERS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<RelationalDatabaseParameter> parameters;

    private final String nextPageToken;

    private GetRelationalDatabaseParametersResponse(BuilderImpl builder) {
        super(builder);
        this.parameters = builder.parameters;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * An object describing the result of your get relational database parameters request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An object describing the result of your get relational database parameters request.
     */
    public List<RelationalDatabaseParameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results from your get static IPs request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results from your get static IPs request.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabaseParametersResponse)) {
            return false;
        }
        GetRelationalDatabaseParametersResponse other = (GetRelationalDatabaseParametersResponse) obj;
        return Objects.equals(parameters(), other.parameters()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetRelationalDatabaseParametersResponse").add("Parameters", parameters())
                .add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRelationalDatabaseParametersResponse, T> g) {
        return obj -> g.apply((GetRelationalDatabaseParametersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRelationalDatabaseParametersResponse> {
        /**
         * <p>
         * An object describing the result of your get relational database parameters request.
         * </p>
         * 
         * @param parameters
         *        An object describing the result of your get relational database parameters request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<RelationalDatabaseParameter> parameters);

        /**
         * <p>
         * An object describing the result of your get relational database parameters request.
         * </p>
         * 
         * @param parameters
         *        An object describing the result of your get relational database parameters request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(RelationalDatabaseParameter... parameters);

        /**
         * <p>
         * An object describing the result of your get relational database parameters request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RelationalDatabaseParameter>.Builder}
         * avoiding the need to create one manually via {@link List<RelationalDatabaseParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RelationalDatabaseParameter>.Builder#build()} is called
         * immediately and its result is passed to {@link #parameters(List<RelationalDatabaseParameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link List<RelationalDatabaseParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(List<RelationalDatabaseParameter>)
         */
        Builder parameters(Consumer<RelationalDatabaseParameter.Builder>... parameters);

        /**
         * <p>
         * A token used for advancing to the next page of results from your get static IPs request.
         * </p>
         * 
         * @param nextPageToken
         *        A token used for advancing to the next page of results from your get static IPs request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<RelationalDatabaseParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationalDatabaseParametersResponse model) {
            super(model);
            parameters(model.parameters);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<RelationalDatabaseParameter.Builder> getParameters() {
            return parameters != null ? parameters.stream().map(RelationalDatabaseParameter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<RelationalDatabaseParameter> parameters) {
            this.parameters = RelationalDatabaseParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(RelationalDatabaseParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<RelationalDatabaseParameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> RelationalDatabaseParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<RelationalDatabaseParameter.BuilderImpl> parameters) {
            this.parameters = RelationalDatabaseParameterListCopier.copyFromBuilder(parameters);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetRelationalDatabaseParametersResponse build() {
            return new GetRelationalDatabaseParametersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
