/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRelationalDatabaseLogEventsRequest extends LightsailRequest implements
        ToCopyableBuilder<GetRelationalDatabaseLogEventsRequest.Builder, GetRelationalDatabaseLogEventsRequest> {
    private static final SdkField<String> RELATIONAL_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetRelationalDatabaseLogEventsRequest::relationalDatabaseName))
            .setter(setter(Builder::relationalDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseName").build())
            .build();

    private static final SdkField<String> LOG_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetRelationalDatabaseLogEventsRequest::logStreamName)).setter(setter(Builder::logStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamName").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetRelationalDatabaseLogEventsRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetRelationalDatabaseLogEventsRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<Boolean> START_FROM_HEAD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(GetRelationalDatabaseLogEventsRequest::startFromHead)).setter(setter(Builder::startFromHead))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startFromHead").build()).build();

    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetRelationalDatabaseLogEventsRequest::pageToken)).setter(setter(Builder::pageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RELATIONAL_DATABASE_NAME_FIELD, LOG_STREAM_NAME_FIELD, START_TIME_FIELD, END_TIME_FIELD, START_FROM_HEAD_FIELD,
            PAGE_TOKEN_FIELD));

    private final String relationalDatabaseName;

    private final String logStreamName;

    private final Instant startTime;

    private final Instant endTime;

    private final Boolean startFromHead;

    private final String pageToken;

    private GetRelationalDatabaseLogEventsRequest(BuilderImpl builder) {
        super(builder);
        this.relationalDatabaseName = builder.relationalDatabaseName;
        this.logStreamName = builder.logStreamName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.startFromHead = builder.startFromHead;
        this.pageToken = builder.pageToken;
    }

    /**
     * <p>
     * The name of your database for which to get log events.
     * </p>
     * 
     * @return The name of your database for which to get log events.
     */
    public String relationalDatabaseName() {
        return relationalDatabaseName;
    }

    /**
     * <p>
     * The name of the log stream.
     * </p>
     * <p>
     * Use the <code>get relational database log streams</code> operation to get a list of available log streams.
     * </p>
     * 
     * @return The name of the log stream.</p>
     *         <p>
     *         Use the <code>get relational database log streams</code> operation to get a list of available log
     *         streams.
     */
    public String logStreamName() {
        return logStreamName;
    }

    /**
     * <p>
     * The start of the time interval from which to get log events.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specified in Universal Coordinated Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in the Unix time format.
     * </p>
     * <p>
     * For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you input
     * <code>1538424000</code> as the start time.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The start of the time interval from which to get log events.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specified in Universal Coordinated Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specified in the Unix time format.
     *         </p>
     *         <p>
     *         For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you input
     *         <code>1538424000</code> as the start time.
     *         </p>
     *         </li>
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time interval from which to get log events.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specified in Universal Coordinated Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in the Unix time format.
     * </p>
     * <p>
     * For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you input
     * <code>1538424000</code> as the end time.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The end of the time interval from which to get log events.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specified in Universal Coordinated Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specified in the Unix time format.
     *         </p>
     *         <p>
     *         For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you input
     *         <code>1538424000</code> as the end time.
     *         </p>
     *         </li>
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Parameter to specify if the log should start from head or tail. If <code>true</code> is specified, the log event
     * starts from the head of the log. If <code>false</code> is specified, the log event starts from the tail of the
     * log.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Parameter to specify if the log should start from head or tail. If <code>true</code> is specified, the
     *         log event starts from the head of the log. If <code>false</code> is specified, the log event starts from
     *         the tail of the log.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean startFromHead() {
        return startFromHead;
    }

    /**
     * <p>
     * A token used for advancing to a specific page of results for your <code>get relational database log events</code>
     * request.
     * </p>
     * 
     * @return A token used for advancing to a specific page of results for your
     *         <code>get relational database log events</code> request.
     */
    public String pageToken() {
        return pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(relationalDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(logStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(startFromHead());
        hashCode = 31 * hashCode + Objects.hashCode(pageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabaseLogEventsRequest)) {
            return false;
        }
        GetRelationalDatabaseLogEventsRequest other = (GetRelationalDatabaseLogEventsRequest) obj;
        return Objects.equals(relationalDatabaseName(), other.relationalDatabaseName())
                && Objects.equals(logStreamName(), other.logStreamName()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(startFromHead(), other.startFromHead())
                && Objects.equals(pageToken(), other.pageToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetRelationalDatabaseLogEventsRequest").add("RelationalDatabaseName", relationalDatabaseName())
                .add("LogStreamName", logStreamName()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("StartFromHead", startFromHead()).add("PageToken", pageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relationalDatabaseName":
            return Optional.ofNullable(clazz.cast(relationalDatabaseName()));
        case "logStreamName":
            return Optional.ofNullable(clazz.cast(logStreamName()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "startFromHead":
            return Optional.ofNullable(clazz.cast(startFromHead()));
        case "pageToken":
            return Optional.ofNullable(clazz.cast(pageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRelationalDatabaseLogEventsRequest, T> g) {
        return obj -> g.apply((GetRelationalDatabaseLogEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRelationalDatabaseLogEventsRequest> {
        /**
         * <p>
         * The name of your database for which to get log events.
         * </p>
         * 
         * @param relationalDatabaseName
         *        The name of your database for which to get log events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseName(String relationalDatabaseName);

        /**
         * <p>
         * The name of the log stream.
         * </p>
         * <p>
         * Use the <code>get relational database log streams</code> operation to get a list of available log streams.
         * </p>
         * 
         * @param logStreamName
         *        The name of the log stream.</p>
         *        <p>
         *        Use the <code>get relational database log streams</code> operation to get a list of available log
         *        streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamName(String logStreamName);

        /**
         * <p>
         * The start of the time interval from which to get log events.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Specified in Universal Coordinated Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Specified in the Unix time format.
         * </p>
         * <p>
         * For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you input
         * <code>1538424000</code> as the start time.
         * </p>
         * </li>
         * </ul>
         * 
         * @param startTime
         *        The start of the time interval from which to get log events.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Specified in Universal Coordinated Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Specified in the Unix time format.
         *        </p>
         *        <p>
         *        For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you input
         *        <code>1538424000</code> as the start time.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end of the time interval from which to get log events.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Specified in Universal Coordinated Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Specified in the Unix time format.
         * </p>
         * <p>
         * For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you input
         * <code>1538424000</code> as the end time.
         * </p>
         * </li>
         * </ul>
         * 
         * @param endTime
         *        The end of the time interval from which to get log events.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Specified in Universal Coordinated Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Specified in the Unix time format.
         *        </p>
         *        <p>
         *        For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you input
         *        <code>1538424000</code> as the end time.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Parameter to specify if the log should start from head or tail. If <code>true</code> is specified, the log
         * event starts from the head of the log. If <code>false</code> is specified, the log event starts from the tail
         * of the log.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param startFromHead
         *        Parameter to specify if the log should start from head or tail. If <code>true</code> is specified, the
         *        log event starts from the head of the log. If <code>false</code> is specified, the log event starts
         *        from the tail of the log.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startFromHead(Boolean startFromHead);

        /**
         * <p>
         * A token used for advancing to a specific page of results for your
         * <code>get relational database log events</code> request.
         * </p>
         * 
         * @param pageToken
         *        A token used for advancing to a specific page of results for your
         *        <code>get relational database log events</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageToken(String pageToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String relationalDatabaseName;

        private String logStreamName;

        private Instant startTime;

        private Instant endTime;

        private Boolean startFromHead;

        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationalDatabaseLogEventsRequest model) {
            super(model);
            relationalDatabaseName(model.relationalDatabaseName);
            logStreamName(model.logStreamName);
            startTime(model.startTime);
            endTime(model.endTime);
            startFromHead(model.startFromHead);
            pageToken(model.pageToken);
        }

        public final String getRelationalDatabaseName() {
            return relationalDatabaseName;
        }

        @Override
        public final Builder relationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
            return this;
        }

        public final void setRelationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
        }

        public final String getLogStreamName() {
            return logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Boolean getStartFromHead() {
            return startFromHead;
        }

        @Override
        public final Builder startFromHead(Boolean startFromHead) {
            this.startFromHead = startFromHead;
            return this;
        }

        public final void setStartFromHead(Boolean startFromHead) {
            this.startFromHead = startFromHead;
        }

        public final String getPageToken() {
            return pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRelationalDatabaseLogEventsRequest build() {
            return new GetRelationalDatabaseLogEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
