/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportSnapshotRequest extends LightsailRequest implements
        ToCopyableBuilder<ExportSnapshotRequest.Builder, ExportSnapshotRequest> {
    private static final SdkField<String> SOURCE_SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportSnapshotRequest::sourceSnapshotName)).setter(setter(Builder::sourceSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceSnapshotName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_SNAPSHOT_NAME_FIELD));

    private final String sourceSnapshotName;

    private ExportSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.sourceSnapshotName = builder.sourceSnapshotName;
    }

    /**
     * <p>
     * The name of the instance or disk snapshot to be exported to Amazon EC2.
     * </p>
     * 
     * @return The name of the instance or disk snapshot to be exported to Amazon EC2.
     */
    public String sourceSnapshotName() {
        return sourceSnapshotName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceSnapshotName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportSnapshotRequest)) {
            return false;
        }
        ExportSnapshotRequest other = (ExportSnapshotRequest) obj;
        return Objects.equals(sourceSnapshotName(), other.sourceSnapshotName());
    }

    @Override
    public String toString() {
        return ToString.builder("ExportSnapshotRequest").add("SourceSnapshotName", sourceSnapshotName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceSnapshotName":
            return Optional.ofNullable(clazz.cast(sourceSnapshotName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportSnapshotRequest, T> g) {
        return obj -> g.apply((ExportSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, ExportSnapshotRequest> {
        /**
         * <p>
         * The name of the instance or disk snapshot to be exported to Amazon EC2.
         * </p>
         * 
         * @param sourceSnapshotName
         *        The name of the instance or disk snapshot to be exported to Amazon EC2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSnapshotName(String sourceSnapshotName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String sourceSnapshotName;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportSnapshotRequest model) {
            super(model);
            sourceSnapshotName(model.sourceSnapshotName);
        }

        public final String getSourceSnapshotName() {
            return sourceSnapshotName;
        }

        @Override
        public final Builder sourceSnapshotName(String sourceSnapshotName) {
            this.sourceSnapshotName = sourceSnapshotName;
            return this;
        }

        public final void setSourceSnapshotName(String sourceSnapshotName) {
            this.sourceSnapshotName = sourceSnapshotName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportSnapshotRequest build() {
            return new ExportSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
