/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.Operation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDomainEntryResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, CreateDomainEntryResponse> {
    private static final SdkField<Operation> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateDomainEntryResponse.getter(CreateDomainEntryResponse::operation)).setter(CreateDomainEntryResponse.setter(Builder::operation)).constructor(Operation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_FIELD));
    private final Operation operation;

    private CreateDomainEntryResponse(BuilderImpl builder) {
        super(builder);
        this.operation = builder.operation;
    }

    public Operation operation() {
        return this.operation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainEntryResponse)) {
            return false;
        }
        CreateDomainEntryResponse other = (CreateDomainEntryResponse)((Object)obj);
        return Objects.equals(this.operation(), other.operation());
    }

    public String toString() {
        return ToString.builder((String)"CreateDomainEntryResponse").add("Operation", (Object)this.operation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "operation": {
                return Optional.ofNullable(clazz.cast(this.operation()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainEntryResponse, T> g) {
        return obj -> g.apply((CreateDomainEntryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private Operation operation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainEntryResponse model) {
            super(model);
            this.operation(model.operation);
        }

        public final Operation.Builder getOperation() {
            return this.operation != null ? this.operation.toBuilder() : null;
        }

        @Override
        public final Builder operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        public final void setOperation(Operation.BuilderImpl operation) {
            this.operation = operation != null ? operation.build() : null;
        }

        @Override
        public CreateDomainEntryResponse build() {
            return new CreateDomainEntryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDomainEntryResponse> {
        public Builder operation(Operation var1);

        default public Builder operation(Consumer<Operation.Builder> operation) {
            return this.operation((Operation)((Operation.Builder)Operation.builder().applyMutation(operation)).build());
        }
    }
}

