/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the health check configuration of an Amazon Lightsail container service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerServiceHealthCheckConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerServiceHealthCheckConfig.Builder, ContainerServiceHealthCheckConfig> {
    private static final SdkField<Integer> HEALTHY_THRESHOLD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("healthyThreshold").getter(getter(ContainerServiceHealthCheckConfig::healthyThreshold))
            .setter(setter(Builder::healthyThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthyThreshold").build()).build();

    private static final SdkField<Integer> UNHEALTHY_THRESHOLD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("unhealthyThreshold").getter(getter(ContainerServiceHealthCheckConfig::unhealthyThreshold))
            .setter(setter(Builder::unhealthyThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unhealthyThreshold").build())
            .build();

    private static final SdkField<Integer> TIMEOUT_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeoutSeconds").getter(getter(ContainerServiceHealthCheckConfig::timeoutSeconds))
            .setter(setter(Builder::timeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutSeconds").build()).build();

    private static final SdkField<Integer> INTERVAL_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("intervalSeconds").getter(getter(ContainerServiceHealthCheckConfig::intervalSeconds))
            .setter(setter(Builder::intervalSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intervalSeconds").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("path")
            .getter(getter(ContainerServiceHealthCheckConfig::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()).build();

    private static final SdkField<String> SUCCESS_CODES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("successCodes").getter(getter(ContainerServiceHealthCheckConfig::successCodes))
            .setter(setter(Builder::successCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successCodes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTHY_THRESHOLD_FIELD,
            UNHEALTHY_THRESHOLD_FIELD, TIMEOUT_SECONDS_FIELD, INTERVAL_SECONDS_FIELD, PATH_FIELD, SUCCESS_CODES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer healthyThreshold;

    private final Integer unhealthyThreshold;

    private final Integer timeoutSeconds;

    private final Integer intervalSeconds;

    private final String path;

    private final String successCodes;

    private ContainerServiceHealthCheckConfig(BuilderImpl builder) {
        this.healthyThreshold = builder.healthyThreshold;
        this.unhealthyThreshold = builder.unhealthyThreshold;
        this.timeoutSeconds = builder.timeoutSeconds;
        this.intervalSeconds = builder.intervalSeconds;
        this.path = builder.path;
        this.successCodes = builder.successCodes;
    }

    /**
     * <p>
     * The number of consecutive health checks successes required before moving the container to the
     * <code>Healthy</code> state. The default value is <code>2</code>.
     * </p>
     * 
     * @return The number of consecutive health checks successes required before moving the container to the
     *         <code>Healthy</code> state. The default value is <code>2</code>.
     */
    public final Integer healthyThreshold() {
        return healthyThreshold;
    }

    /**
     * <p>
     * The number of consecutive health check failures required before moving the container to the
     * <code>Unhealthy</code> state. The default value is <code>2</code>.
     * </p>
     * 
     * @return The number of consecutive health check failures required before moving the container to the
     *         <code>Unhealthy</code> state. The default value is <code>2</code>.
     */
    public final Integer unhealthyThreshold() {
        return unhealthyThreshold;
    }

    /**
     * <p>
     * The amount of time, in seconds, during which no response means a failed health check. You can specify between 2
     * and 60 seconds. The default value is <code>2</code>.
     * </p>
     * 
     * @return The amount of time, in seconds, during which no response means a failed health check. You can specify
     *         between 2 and 60 seconds. The default value is <code>2</code>.
     */
    public final Integer timeoutSeconds() {
        return timeoutSeconds;
    }

    /**
     * <p>
     * The approximate interval, in seconds, between health checks of an individual container. You can specify between 5
     * and 300 seconds. The default value is <code>5</code>.
     * </p>
     * 
     * @return The approximate interval, in seconds, between health checks of an individual container. You can specify
     *         between 5 and 300 seconds. The default value is <code>5</code>.
     */
    public final Integer intervalSeconds() {
        return intervalSeconds;
    }

    /**
     * <p>
     * The path on the container on which to perform the health check. The default value is <code>/</code>.
     * </p>
     * 
     * @return The path on the container on which to perform the health check. The default value is <code>/</code>.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The HTTP codes to use when checking for a successful response from a container. You can specify values between
     * <code>200</code> and <code>499</code>. You can specify multiple values (for example, <code>200,202</code>) or a
     * range of values (for example, <code>200-299</code>).
     * </p>
     * 
     * @return The HTTP codes to use when checking for a successful response from a container. You can specify values
     *         between <code>200</code> and <code>499</code>. You can specify multiple values (for example,
     *         <code>200,202</code>) or a range of values (for example, <code>200-299</code>).
     */
    public final String successCodes() {
        return successCodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(healthyThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(unhealthyThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(intervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(successCodes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerServiceHealthCheckConfig)) {
            return false;
        }
        ContainerServiceHealthCheckConfig other = (ContainerServiceHealthCheckConfig) obj;
        return Objects.equals(healthyThreshold(), other.healthyThreshold())
                && Objects.equals(unhealthyThreshold(), other.unhealthyThreshold())
                && Objects.equals(timeoutSeconds(), other.timeoutSeconds())
                && Objects.equals(intervalSeconds(), other.intervalSeconds()) && Objects.equals(path(), other.path())
                && Objects.equals(successCodes(), other.successCodes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerServiceHealthCheckConfig").add("HealthyThreshold", healthyThreshold())
                .add("UnhealthyThreshold", unhealthyThreshold()).add("TimeoutSeconds", timeoutSeconds())
                .add("IntervalSeconds", intervalSeconds()).add("Path", path()).add("SuccessCodes", successCodes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "healthyThreshold":
            return Optional.ofNullable(clazz.cast(healthyThreshold()));
        case "unhealthyThreshold":
            return Optional.ofNullable(clazz.cast(unhealthyThreshold()));
        case "timeoutSeconds":
            return Optional.ofNullable(clazz.cast(timeoutSeconds()));
        case "intervalSeconds":
            return Optional.ofNullable(clazz.cast(intervalSeconds()));
        case "path":
            return Optional.ofNullable(clazz.cast(path()));
        case "successCodes":
            return Optional.ofNullable(clazz.cast(successCodes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("healthyThreshold", HEALTHY_THRESHOLD_FIELD);
        map.put("unhealthyThreshold", UNHEALTHY_THRESHOLD_FIELD);
        map.put("timeoutSeconds", TIMEOUT_SECONDS_FIELD);
        map.put("intervalSeconds", INTERVAL_SECONDS_FIELD);
        map.put("path", PATH_FIELD);
        map.put("successCodes", SUCCESS_CODES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContainerServiceHealthCheckConfig, T> g) {
        return obj -> g.apply((ContainerServiceHealthCheckConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerServiceHealthCheckConfig> {
        /**
         * <p>
         * The number of consecutive health checks successes required before moving the container to the
         * <code>Healthy</code> state. The default value is <code>2</code>.
         * </p>
         * 
         * @param healthyThreshold
         *        The number of consecutive health checks successes required before moving the container to the
         *        <code>Healthy</code> state. The default value is <code>2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthyThreshold(Integer healthyThreshold);

        /**
         * <p>
         * The number of consecutive health check failures required before moving the container to the
         * <code>Unhealthy</code> state. The default value is <code>2</code>.
         * </p>
         * 
         * @param unhealthyThreshold
         *        The number of consecutive health check failures required before moving the container to the
         *        <code>Unhealthy</code> state. The default value is <code>2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unhealthyThreshold(Integer unhealthyThreshold);

        /**
         * <p>
         * The amount of time, in seconds, during which no response means a failed health check. You can specify between
         * 2 and 60 seconds. The default value is <code>2</code>.
         * </p>
         * 
         * @param timeoutSeconds
         *        The amount of time, in seconds, during which no response means a failed health check. You can specify
         *        between 2 and 60 seconds. The default value is <code>2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutSeconds(Integer timeoutSeconds);

        /**
         * <p>
         * The approximate interval, in seconds, between health checks of an individual container. You can specify
         * between 5 and 300 seconds. The default value is <code>5</code>.
         * </p>
         * 
         * @param intervalSeconds
         *        The approximate interval, in seconds, between health checks of an individual container. You can
         *        specify between 5 and 300 seconds. The default value is <code>5</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intervalSeconds(Integer intervalSeconds);

        /**
         * <p>
         * The path on the container on which to perform the health check. The default value is <code>/</code>.
         * </p>
         * 
         * @param path
         *        The path on the container on which to perform the health check. The default value is <code>/</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The HTTP codes to use when checking for a successful response from a container. You can specify values
         * between <code>200</code> and <code>499</code>. You can specify multiple values (for example,
         * <code>200,202</code>) or a range of values (for example, <code>200-299</code>).
         * </p>
         * 
         * @param successCodes
         *        The HTTP codes to use when checking for a successful response from a container. You can specify values
         *        between <code>200</code> and <code>499</code>. You can specify multiple values (for example,
         *        <code>200,202</code>) or a range of values (for example, <code>200-299</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successCodes(String successCodes);
    }

    static final class BuilderImpl implements Builder {
        private Integer healthyThreshold;

        private Integer unhealthyThreshold;

        private Integer timeoutSeconds;

        private Integer intervalSeconds;

        private String path;

        private String successCodes;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerServiceHealthCheckConfig model) {
            healthyThreshold(model.healthyThreshold);
            unhealthyThreshold(model.unhealthyThreshold);
            timeoutSeconds(model.timeoutSeconds);
            intervalSeconds(model.intervalSeconds);
            path(model.path);
            successCodes(model.successCodes);
        }

        public final Integer getHealthyThreshold() {
            return healthyThreshold;
        }

        public final void setHealthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
        }

        @Override
        public final Builder healthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
            return this;
        }

        public final Integer getUnhealthyThreshold() {
            return unhealthyThreshold;
        }

        public final void setUnhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
        }

        @Override
        public final Builder unhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
            return this;
        }

        public final Integer getTimeoutSeconds() {
            return timeoutSeconds;
        }

        public final void setTimeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
        }

        @Override
        public final Builder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public final Integer getIntervalSeconds() {
            return intervalSeconds;
        }

        public final void setIntervalSeconds(Integer intervalSeconds) {
            this.intervalSeconds = intervalSeconds;
        }

        @Override
        public final Builder intervalSeconds(Integer intervalSeconds) {
            this.intervalSeconds = intervalSeconds;
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getSuccessCodes() {
            return successCodes;
        }

        public final void setSuccessCodes(String successCodes) {
            this.successCodes = successCodes;
        }

        @Override
        public final Builder successCodes(String successCodes) {
            this.successCodes = successCodes;
            return this;
        }

        @Override
        public ContainerServiceHealthCheckConfig build() {
            return new ContainerServiceHealthCheckConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
