/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContactMethodRequest extends LightsailRequest implements
        ToCopyableBuilder<CreateContactMethodRequest.Builder, CreateContactMethodRequest> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocol").getter(getter(CreateContactMethodRequest::protocolAsString))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<String> CONTACT_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contactEndpoint").getter(getter(CreateContactMethodRequest::contactEndpoint))
            .setter(setter(Builder::contactEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD,
            CONTACT_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String protocol;

    private final String contactEndpoint;

    private CreateContactMethodRequest(BuilderImpl builder) {
        super(builder);
        this.protocol = builder.protocol;
        this.contactEndpoint = builder.contactEndpoint;
    }

    /**
     * <p>
     * The protocol of the contact method, such as <code>Email</code> or <code>SMS</code> (text messaging).
     * </p>
     * <p>
     * The <code>SMS</code> protocol is supported only in the following Amazon Web Services Regions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * US East (N. Virginia) (<code>us-east-1</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * US West (Oregon) (<code>us-west-2</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Europe (Ireland) (<code>eu-west-1</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Asia Pacific (Tokyo) (<code>ap-northeast-1</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Asia Pacific (Singapore) (<code>ap-southeast-1</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Asia Pacific (Sydney) (<code>ap-southeast-2</code>)
     * </p>
     * </li>
     * </ul>
     * <p>
     * For a list of countries/regions where SMS text messages can be sent, and the latest Amazon Web Services Regions
     * where SMS text messaging is supported, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-supported-regions-countries.html">Supported Regions and
     * Countries</a> in the <i>Amazon SNS Developer Guide</i>.
     * </p>
     * <p>
     * For more information about notifications in Amazon Lightsail, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in
     * Amazon Lightsail</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ContactProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol of the contact method, such as <code>Email</code> or <code>SMS</code> (text messaging).</p>
     *         <p>
     *         The <code>SMS</code> protocol is supported only in the following Amazon Web Services Regions.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         US East (N. Virginia) (<code>us-east-1</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         US West (Oregon) (<code>us-west-2</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Europe (Ireland) (<code>eu-west-1</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Asia Pacific (Tokyo) (<code>ap-northeast-1</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Asia Pacific (Singapore) (<code>ap-southeast-1</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Asia Pacific (Sydney) (<code>ap-southeast-2</code>)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For a list of countries/regions where SMS text messages can be sent, and the latest Amazon Web Services
     *         Regions where SMS text messaging is supported, see <a
     *         href="https://docs.aws.amazon.com/sns/latest/dg/sns-supported-regions-countries.html">Supported Regions
     *         and Countries</a> in the <i>Amazon SNS Developer Guide</i>.
     *         </p>
     *         <p>
     *         For more information about notifications in Amazon Lightsail, see <a
     *         href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications"
     *         >Notifications in Amazon Lightsail</a>.
     * @see ContactProtocol
     */
    public final ContactProtocol protocol() {
        return ContactProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol of the contact method, such as <code>Email</code> or <code>SMS</code> (text messaging).
     * </p>
     * <p>
     * The <code>SMS</code> protocol is supported only in the following Amazon Web Services Regions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * US East (N. Virginia) (<code>us-east-1</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * US West (Oregon) (<code>us-west-2</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Europe (Ireland) (<code>eu-west-1</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Asia Pacific (Tokyo) (<code>ap-northeast-1</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Asia Pacific (Singapore) (<code>ap-southeast-1</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Asia Pacific (Sydney) (<code>ap-southeast-2</code>)
     * </p>
     * </li>
     * </ul>
     * <p>
     * For a list of countries/regions where SMS text messages can be sent, and the latest Amazon Web Services Regions
     * where SMS text messaging is supported, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-supported-regions-countries.html">Supported Regions and
     * Countries</a> in the <i>Amazon SNS Developer Guide</i>.
     * </p>
     * <p>
     * For more information about notifications in Amazon Lightsail, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in
     * Amazon Lightsail</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ContactProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol of the contact method, such as <code>Email</code> or <code>SMS</code> (text messaging).</p>
     *         <p>
     *         The <code>SMS</code> protocol is supported only in the following Amazon Web Services Regions.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         US East (N. Virginia) (<code>us-east-1</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         US West (Oregon) (<code>us-west-2</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Europe (Ireland) (<code>eu-west-1</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Asia Pacific (Tokyo) (<code>ap-northeast-1</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Asia Pacific (Singapore) (<code>ap-southeast-1</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Asia Pacific (Sydney) (<code>ap-southeast-2</code>)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For a list of countries/regions where SMS text messages can be sent, and the latest Amazon Web Services
     *         Regions where SMS text messaging is supported, see <a
     *         href="https://docs.aws.amazon.com/sns/latest/dg/sns-supported-regions-countries.html">Supported Regions
     *         and Countries</a> in the <i>Amazon SNS Developer Guide</i>.
     *         </p>
     *         <p>
     *         For more information about notifications in Amazon Lightsail, see <a
     *         href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications"
     *         >Notifications in Amazon Lightsail</a>.
     * @see ContactProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The destination of the contact method, such as an email address or a mobile phone number.
     * </p>
     * <p>
     * Use the E.164 format when specifying a mobile phone number. E.164 is a standard for the phone number structure
     * used for international telecommunication. Phone numbers that follow this format can have a maximum of 15 digits,
     * and they are prefixed with the plus character (+) and the country code. For example, a U.S. phone number in E.164
     * format would be specified as +1XXX5550100. For more information, see <a
     * href="https://en.wikipedia.org/wiki/E.164">E.164</a> on <i>Wikipedia</i>.
     * </p>
     * 
     * @return The destination of the contact method, such as an email address or a mobile phone number.</p>
     *         <p>
     *         Use the E.164 format when specifying a mobile phone number. E.164 is a standard for the phone number
     *         structure used for international telecommunication. Phone numbers that follow this format can have a
     *         maximum of 15 digits, and they are prefixed with the plus character (+) and the country code. For
     *         example, a U.S. phone number in E.164 format would be specified as +1XXX5550100. For more information,
     *         see <a href="https://en.wikipedia.org/wiki/E.164">E.164</a> on <i>Wikipedia</i>.
     */
    public final String contactEndpoint() {
        return contactEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contactEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContactMethodRequest)) {
            return false;
        }
        CreateContactMethodRequest other = (CreateContactMethodRequest) obj;
        return Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(contactEndpoint(), other.contactEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateContactMethodRequest").add("Protocol", protocolAsString())
                .add("ContactEndpoint", contactEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "contactEndpoint":
            return Optional.ofNullable(clazz.cast(contactEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("protocol", PROTOCOL_FIELD);
        map.put("contactEndpoint", CONTACT_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateContactMethodRequest, T> g) {
        return obj -> g.apply((CreateContactMethodRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateContactMethodRequest> {
        /**
         * <p>
         * The protocol of the contact method, such as <code>Email</code> or <code>SMS</code> (text messaging).
         * </p>
         * <p>
         * The <code>SMS</code> protocol is supported only in the following Amazon Web Services Regions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * US East (N. Virginia) (<code>us-east-1</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * US West (Oregon) (<code>us-west-2</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * Europe (Ireland) (<code>eu-west-1</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * Asia Pacific (Tokyo) (<code>ap-northeast-1</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * Asia Pacific (Singapore) (<code>ap-southeast-1</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * Asia Pacific (Sydney) (<code>ap-southeast-2</code>)
         * </p>
         * </li>
         * </ul>
         * <p>
         * For a list of countries/regions where SMS text messages can be sent, and the latest Amazon Web Services
         * Regions where SMS text messaging is supported, see <a
         * href="https://docs.aws.amazon.com/sns/latest/dg/sns-supported-regions-countries.html">Supported Regions and
         * Countries</a> in the <i>Amazon SNS Developer Guide</i>.
         * </p>
         * <p>
         * For more information about notifications in Amazon Lightsail, see <a
         * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications
         * in Amazon Lightsail</a>.
         * </p>
         * 
         * @param protocol
         *        The protocol of the contact method, such as <code>Email</code> or <code>SMS</code> (text
         *        messaging).</p>
         *        <p>
         *        The <code>SMS</code> protocol is supported only in the following Amazon Web Services Regions.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        US East (N. Virginia) (<code>us-east-1</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        US West (Oregon) (<code>us-west-2</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Europe (Ireland) (<code>eu-west-1</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Asia Pacific (Tokyo) (<code>ap-northeast-1</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Asia Pacific (Singapore) (<code>ap-southeast-1</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Asia Pacific (Sydney) (<code>ap-southeast-2</code>)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For a list of countries/regions where SMS text messages can be sent, and the latest Amazon Web
         *        Services Regions where SMS text messaging is supported, see <a
         *        href="https://docs.aws.amazon.com/sns/latest/dg/sns-supported-regions-countries.html">Supported
         *        Regions and Countries</a> in the <i>Amazon SNS Developer Guide</i>.
         *        </p>
         *        <p>
         *        For more information about notifications in Amazon Lightsail, see <a
         *        href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications"
         *        >Notifications in Amazon Lightsail</a>.
         * @see ContactProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol of the contact method, such as <code>Email</code> or <code>SMS</code> (text messaging).
         * </p>
         * <p>
         * The <code>SMS</code> protocol is supported only in the following Amazon Web Services Regions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * US East (N. Virginia) (<code>us-east-1</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * US West (Oregon) (<code>us-west-2</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * Europe (Ireland) (<code>eu-west-1</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * Asia Pacific (Tokyo) (<code>ap-northeast-1</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * Asia Pacific (Singapore) (<code>ap-southeast-1</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * Asia Pacific (Sydney) (<code>ap-southeast-2</code>)
         * </p>
         * </li>
         * </ul>
         * <p>
         * For a list of countries/regions where SMS text messages can be sent, and the latest Amazon Web Services
         * Regions where SMS text messaging is supported, see <a
         * href="https://docs.aws.amazon.com/sns/latest/dg/sns-supported-regions-countries.html">Supported Regions and
         * Countries</a> in the <i>Amazon SNS Developer Guide</i>.
         * </p>
         * <p>
         * For more information about notifications in Amazon Lightsail, see <a
         * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications
         * in Amazon Lightsail</a>.
         * </p>
         * 
         * @param protocol
         *        The protocol of the contact method, such as <code>Email</code> or <code>SMS</code> (text
         *        messaging).</p>
         *        <p>
         *        The <code>SMS</code> protocol is supported only in the following Amazon Web Services Regions.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        US East (N. Virginia) (<code>us-east-1</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        US West (Oregon) (<code>us-west-2</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Europe (Ireland) (<code>eu-west-1</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Asia Pacific (Tokyo) (<code>ap-northeast-1</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Asia Pacific (Singapore) (<code>ap-southeast-1</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Asia Pacific (Sydney) (<code>ap-southeast-2</code>)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For a list of countries/regions where SMS text messages can be sent, and the latest Amazon Web
         *        Services Regions where SMS text messaging is supported, see <a
         *        href="https://docs.aws.amazon.com/sns/latest/dg/sns-supported-regions-countries.html">Supported
         *        Regions and Countries</a> in the <i>Amazon SNS Developer Guide</i>.
         *        </p>
         *        <p>
         *        For more information about notifications in Amazon Lightsail, see <a
         *        href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications"
         *        >Notifications in Amazon Lightsail</a>.
         * @see ContactProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactProtocol
         */
        Builder protocol(ContactProtocol protocol);

        /**
         * <p>
         * The destination of the contact method, such as an email address or a mobile phone number.
         * </p>
         * <p>
         * Use the E.164 format when specifying a mobile phone number. E.164 is a standard for the phone number
         * structure used for international telecommunication. Phone numbers that follow this format can have a maximum
         * of 15 digits, and they are prefixed with the plus character (+) and the country code. For example, a U.S.
         * phone number in E.164 format would be specified as +1XXX5550100. For more information, see <a
         * href="https://en.wikipedia.org/wiki/E.164">E.164</a> on <i>Wikipedia</i>.
         * </p>
         * 
         * @param contactEndpoint
         *        The destination of the contact method, such as an email address or a mobile phone number.</p>
         *        <p>
         *        Use the E.164 format when specifying a mobile phone number. E.164 is a standard for the phone number
         *        structure used for international telecommunication. Phone numbers that follow this format can have a
         *        maximum of 15 digits, and they are prefixed with the plus character (+) and the country code. For
         *        example, a U.S. phone number in E.164 format would be specified as +1XXX5550100. For more information,
         *        see <a href="https://en.wikipedia.org/wiki/E.164">E.164</a> on <i>Wikipedia</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactEndpoint(String contactEndpoint);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String protocol;

        private String contactEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContactMethodRequest model) {
            super(model);
            protocol(model.protocol);
            contactEndpoint(model.contactEndpoint);
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ContactProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getContactEndpoint() {
            return contactEndpoint;
        }

        public final void setContactEndpoint(String contactEndpoint) {
            this.contactEndpoint = contactEndpoint;
        }

        @Override
        public final Builder contactEndpoint(String contactEndpoint) {
            this.contactEndpoint = contactEndpoint;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContactMethodRequest build() {
            return new CreateContactMethodRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
