/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDistributionResponse extends LightsailResponse implements
        ToCopyableBuilder<CreateDistributionResponse.Builder, CreateDistributionResponse> {
    private static final SdkField<LightsailDistribution> DISTRIBUTION_FIELD = SdkField
            .<LightsailDistribution> builder(MarshallingType.SDK_POJO).memberName("distribution")
            .getter(getter(CreateDistributionResponse::distribution)).setter(setter(Builder::distribution))
            .constructor(LightsailDistribution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distribution").build()).build();

    private static final SdkField<Operation> OPERATION_FIELD = SdkField.<Operation> builder(MarshallingType.SDK_POJO)
            .memberName("operation").getter(getter(CreateDistributionResponse::operation)).setter(setter(Builder::operation))
            .constructor(Operation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_FIELD,
            OPERATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final LightsailDistribution distribution;

    private final Operation operation;

    private CreateDistributionResponse(BuilderImpl builder) {
        super(builder);
        this.distribution = builder.distribution;
        this.operation = builder.operation;
    }

    /**
     * <p>
     * An object that describes the distribution created.
     * </p>
     * 
     * @return An object that describes the distribution created.
     */
    public final LightsailDistribution distribution() {
        return distribution;
    }

    /**
     * <p>
     * An array of objects that describe the result of the action, such as the status of the request, the timestamp of
     * the request, and the resources affected by the request.
     * </p>
     * 
     * @return An array of objects that describe the result of the action, such as the status of the request, the
     *         timestamp of the request, and the resources affected by the request.
     */
    public final Operation operation() {
        return operation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(distribution());
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDistributionResponse)) {
            return false;
        }
        CreateDistributionResponse other = (CreateDistributionResponse) obj;
        return Objects.equals(distribution(), other.distribution()) && Objects.equals(operation(), other.operation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDistributionResponse").add("Distribution", distribution()).add("Operation", operation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "distribution":
            return Optional.ofNullable(clazz.cast(distribution()));
        case "operation":
            return Optional.ofNullable(clazz.cast(operation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("distribution", DISTRIBUTION_FIELD);
        map.put("operation", OPERATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDistributionResponse, T> g) {
        return obj -> g.apply((CreateDistributionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDistributionResponse> {
        /**
         * <p>
         * An object that describes the distribution created.
         * </p>
         * 
         * @param distribution
         *        An object that describes the distribution created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distribution(LightsailDistribution distribution);

        /**
         * <p>
         * An object that describes the distribution created.
         * </p>
         * This is a convenience method that creates an instance of the {@link LightsailDistribution.Builder} avoiding
         * the need to create one manually via {@link LightsailDistribution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LightsailDistribution.Builder#build()} is called immediately and
         * its result is passed to {@link #distribution(LightsailDistribution)}.
         * 
         * @param distribution
         *        a consumer that will call methods on {@link LightsailDistribution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #distribution(LightsailDistribution)
         */
        default Builder distribution(Consumer<LightsailDistribution.Builder> distribution) {
            return distribution(LightsailDistribution.builder().applyMutation(distribution).build());
        }

        /**
         * <p>
         * An array of objects that describe the result of the action, such as the status of the request, the timestamp
         * of the request, and the resources affected by the request.
         * </p>
         * 
         * @param operation
         *        An array of objects that describe the result of the action, such as the status of the request, the
         *        timestamp of the request, and the resources affected by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(Operation operation);

        /**
         * <p>
         * An array of objects that describe the result of the action, such as the status of the request, the timestamp
         * of the request, and the resources affected by the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link Operation.Builder} avoiding the need to
         * create one manually via {@link Operation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Operation.Builder#build()} is called immediately and its result
         * is passed to {@link #operation(Operation)}.
         * 
         * @param operation
         *        a consumer that will call methods on {@link Operation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operation(Operation)
         */
        default Builder operation(Consumer<Operation.Builder> operation) {
            return operation(Operation.builder().applyMutation(operation).build());
        }
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private LightsailDistribution distribution;

        private Operation operation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDistributionResponse model) {
            super(model);
            distribution(model.distribution);
            operation(model.operation);
        }

        public final LightsailDistribution.Builder getDistribution() {
            return distribution != null ? distribution.toBuilder() : null;
        }

        public final void setDistribution(LightsailDistribution.BuilderImpl distribution) {
            this.distribution = distribution != null ? distribution.build() : null;
        }

        @Override
        public final Builder distribution(LightsailDistribution distribution) {
            this.distribution = distribution;
            return this;
        }

        public final Operation.Builder getOperation() {
            return operation != null ? operation.toBuilder() : null;
        }

        public final void setOperation(Operation.BuilderImpl operation) {
            this.operation = operation != null ? operation.build() : null;
        }

        @Override
        public final Builder operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public CreateDistributionResponse build() {
            return new CreateDistributionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
