/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRelationalDatabaseRequest extends LightsailRequest implements
        ToCopyableBuilder<DeleteRelationalDatabaseRequest.Builder, DeleteRelationalDatabaseRequest> {
    private static final SdkField<String> RELATIONAL_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relationalDatabaseName").getter(getter(DeleteRelationalDatabaseRequest::relationalDatabaseName))
            .setter(setter(Builder::relationalDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseName").build())
            .build();

    private static final SdkField<Boolean> SKIP_FINAL_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("skipFinalSnapshot").getter(getter(DeleteRelationalDatabaseRequest::skipFinalSnapshot))
            .setter(setter(Builder::skipFinalSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skipFinalSnapshot").build()).build();

    private static final SdkField<String> FINAL_RELATIONAL_DATABASE_SNAPSHOT_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("finalRelationalDatabaseSnapshotName")
            .getter(getter(DeleteRelationalDatabaseRequest::finalRelationalDatabaseSnapshotName))
            .setter(setter(Builder::finalRelationalDatabaseSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("finalRelationalDatabaseSnapshotName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RELATIONAL_DATABASE_NAME_FIELD, SKIP_FINAL_SNAPSHOT_FIELD, FINAL_RELATIONAL_DATABASE_SNAPSHOT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String relationalDatabaseName;

    private final Boolean skipFinalSnapshot;

    private final String finalRelationalDatabaseSnapshotName;

    private DeleteRelationalDatabaseRequest(BuilderImpl builder) {
        super(builder);
        this.relationalDatabaseName = builder.relationalDatabaseName;
        this.skipFinalSnapshot = builder.skipFinalSnapshot;
        this.finalRelationalDatabaseSnapshotName = builder.finalRelationalDatabaseSnapshotName;
    }

    /**
     * <p>
     * The name of the database that you are deleting.
     * </p>
     * 
     * @return The name of the database that you are deleting.
     */
    public final String relationalDatabaseName() {
        return relationalDatabaseName;
    }

    /**
     * <p>
     * Determines whether a final database snapshot is created before your database is deleted. If <code>true</code> is
     * specified, no database snapshot is created. If <code>false</code> is specified, a database snapshot is created
     * before your database is deleted.
     * </p>
     * <p>
     * You must specify the <code>final relational database snapshot name</code> parameter if the
     * <code>skip final snapshot</code> parameter is <code>false</code>.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Determines whether a final database snapshot is created before your database is deleted. If
     *         <code>true</code> is specified, no database snapshot is created. If <code>false</code> is specified, a
     *         database snapshot is created before your database is deleted.</p>
     *         <p>
     *         You must specify the <code>final relational database snapshot name</code> parameter if the
     *         <code>skip final snapshot</code> parameter is <code>false</code>.
     *         </p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean skipFinalSnapshot() {
        return skipFinalSnapshot;
    }

    /**
     * <p>
     * The name of the database snapshot created if <code>skip final snapshot</code> is <code>false</code>, which is the
     * default value for that parameter.
     * </p>
     * <note>
     * <p>
     * Specifying this parameter and also specifying the <code>skip final snapshot</code> parameter to <code>true</code>
     * results in an error.
     * </p>
     * </note>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 2 to 255 alphanumeric characters, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first and last character must be a letter or number.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the database snapshot created if <code>skip final snapshot</code> is <code>false</code>,
     *         which is the default value for that parameter.</p> <note>
     *         <p>
     *         Specifying this parameter and also specifying the <code>skip final snapshot</code> parameter to
     *         <code>true</code> results in an error.
     *         </p>
     *         </note>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 2 to 255 alphanumeric characters, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first and last character must be a letter or number.
     *         </p>
     *         </li>
     */
    public final String finalRelationalDatabaseSnapshotName() {
        return finalRelationalDatabaseSnapshotName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(relationalDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(skipFinalSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(finalRelationalDatabaseSnapshotName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRelationalDatabaseRequest)) {
            return false;
        }
        DeleteRelationalDatabaseRequest other = (DeleteRelationalDatabaseRequest) obj;
        return Objects.equals(relationalDatabaseName(), other.relationalDatabaseName())
                && Objects.equals(skipFinalSnapshot(), other.skipFinalSnapshot())
                && Objects.equals(finalRelationalDatabaseSnapshotName(), other.finalRelationalDatabaseSnapshotName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteRelationalDatabaseRequest").add("RelationalDatabaseName", relationalDatabaseName())
                .add("SkipFinalSnapshot", skipFinalSnapshot())
                .add("FinalRelationalDatabaseSnapshotName", finalRelationalDatabaseSnapshotName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relationalDatabaseName":
            return Optional.ofNullable(clazz.cast(relationalDatabaseName()));
        case "skipFinalSnapshot":
            return Optional.ofNullable(clazz.cast(skipFinalSnapshot()));
        case "finalRelationalDatabaseSnapshotName":
            return Optional.ofNullable(clazz.cast(finalRelationalDatabaseSnapshotName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("relationalDatabaseName", RELATIONAL_DATABASE_NAME_FIELD);
        map.put("skipFinalSnapshot", SKIP_FINAL_SNAPSHOT_FIELD);
        map.put("finalRelationalDatabaseSnapshotName", FINAL_RELATIONAL_DATABASE_SNAPSHOT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteRelationalDatabaseRequest, T> g) {
        return obj -> g.apply((DeleteRelationalDatabaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteRelationalDatabaseRequest> {
        /**
         * <p>
         * The name of the database that you are deleting.
         * </p>
         * 
         * @param relationalDatabaseName
         *        The name of the database that you are deleting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseName(String relationalDatabaseName);

        /**
         * <p>
         * Determines whether a final database snapshot is created before your database is deleted. If <code>true</code>
         * is specified, no database snapshot is created. If <code>false</code> is specified, a database snapshot is
         * created before your database is deleted.
         * </p>
         * <p>
         * You must specify the <code>final relational database snapshot name</code> parameter if the
         * <code>skip final snapshot</code> parameter is <code>false</code>.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param skipFinalSnapshot
         *        Determines whether a final database snapshot is created before your database is deleted. If
         *        <code>true</code> is specified, no database snapshot is created. If <code>false</code> is specified, a
         *        database snapshot is created before your database is deleted.</p>
         *        <p>
         *        You must specify the <code>final relational database snapshot name</code> parameter if the
         *        <code>skip final snapshot</code> parameter is <code>false</code>.
         *        </p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipFinalSnapshot(Boolean skipFinalSnapshot);

        /**
         * <p>
         * The name of the database snapshot created if <code>skip final snapshot</code> is <code>false</code>, which is
         * the default value for that parameter.
         * </p>
         * <note>
         * <p>
         * Specifying this parameter and also specifying the <code>skip final snapshot</code> parameter to
         * <code>true</code> results in an error.
         * </p>
         * </note>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 2 to 255 alphanumeric characters, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * The first and last character must be a letter or number.
         * </p>
         * </li>
         * </ul>
         * 
         * @param finalRelationalDatabaseSnapshotName
         *        The name of the database snapshot created if <code>skip final snapshot</code> is <code>false</code>,
         *        which is the default value for that parameter.</p> <note>
         *        <p>
         *        Specifying this parameter and also specifying the <code>skip final snapshot</code> parameter to
         *        <code>true</code> results in an error.
         *        </p>
         *        </note>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 2 to 255 alphanumeric characters, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first and last character must be a letter or number.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalRelationalDatabaseSnapshotName(String finalRelationalDatabaseSnapshotName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String relationalDatabaseName;

        private Boolean skipFinalSnapshot;

        private String finalRelationalDatabaseSnapshotName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRelationalDatabaseRequest model) {
            super(model);
            relationalDatabaseName(model.relationalDatabaseName);
            skipFinalSnapshot(model.skipFinalSnapshot);
            finalRelationalDatabaseSnapshotName(model.finalRelationalDatabaseSnapshotName);
        }

        public final String getRelationalDatabaseName() {
            return relationalDatabaseName;
        }

        public final void setRelationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
        }

        @Override
        public final Builder relationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
            return this;
        }

        public final Boolean getSkipFinalSnapshot() {
            return skipFinalSnapshot;
        }

        public final void setSkipFinalSnapshot(Boolean skipFinalSnapshot) {
            this.skipFinalSnapshot = skipFinalSnapshot;
        }

        @Override
        public final Builder skipFinalSnapshot(Boolean skipFinalSnapshot) {
            this.skipFinalSnapshot = skipFinalSnapshot;
            return this;
        }

        public final String getFinalRelationalDatabaseSnapshotName() {
            return finalRelationalDatabaseSnapshotName;
        }

        public final void setFinalRelationalDatabaseSnapshotName(String finalRelationalDatabaseSnapshotName) {
            this.finalRelationalDatabaseSnapshotName = finalRelationalDatabaseSnapshotName;
        }

        @Override
        public final Builder finalRelationalDatabaseSnapshotName(String finalRelationalDatabaseSnapshotName) {
            this.finalRelationalDatabaseSnapshotName = finalRelationalDatabaseSnapshotName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRelationalDatabaseRequest build() {
            return new DeleteRelationalDatabaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
