/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisableAddOnRequest extends LightsailRequest implements
        ToCopyableBuilder<DisableAddOnRequest.Builder, DisableAddOnRequest> {
    private static final SdkField<String> ADD_ON_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addOnType").getter(getter(DisableAddOnRequest::addOnTypeAsString)).setter(setter(Builder::addOnType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addOnType").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceName").getter(getter(DisableAddOnRequest::resourceName)).setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_ON_TYPE_FIELD,
            RESOURCE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String addOnType;

    private final String resourceName;

    private DisableAddOnRequest(BuilderImpl builder) {
        super(builder);
        this.addOnType = builder.addOnType;
        this.resourceName = builder.resourceName;
    }

    /**
     * <p>
     * The add-on type to disable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addOnType} will
     * return {@link AddOnType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #addOnTypeAsString}.
     * </p>
     * 
     * @return The add-on type to disable.
     * @see AddOnType
     */
    public final AddOnType addOnType() {
        return AddOnType.fromValue(addOnType);
    }

    /**
     * <p>
     * The add-on type to disable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addOnType} will
     * return {@link AddOnType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #addOnTypeAsString}.
     * </p>
     * 
     * @return The add-on type to disable.
     * @see AddOnType
     */
    public final String addOnTypeAsString() {
        return addOnType;
    }

    /**
     * <p>
     * The name of the source resource for which to disable the add-on.
     * </p>
     * 
     * @return The name of the source resource for which to disable the add-on.
     */
    public final String resourceName() {
        return resourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(addOnTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableAddOnRequest)) {
            return false;
        }
        DisableAddOnRequest other = (DisableAddOnRequest) obj;
        return Objects.equals(addOnTypeAsString(), other.addOnTypeAsString())
                && Objects.equals(resourceName(), other.resourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisableAddOnRequest").add("AddOnType", addOnTypeAsString()).add("ResourceName", resourceName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addOnType":
            return Optional.ofNullable(clazz.cast(addOnTypeAsString()));
        case "resourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("addOnType", ADD_ON_TYPE_FIELD);
        map.put("resourceName", RESOURCE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisableAddOnRequest, T> g) {
        return obj -> g.apply((DisableAddOnRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, DisableAddOnRequest> {
        /**
         * <p>
         * The add-on type to disable.
         * </p>
         * 
         * @param addOnType
         *        The add-on type to disable.
         * @see AddOnType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddOnType
         */
        Builder addOnType(String addOnType);

        /**
         * <p>
         * The add-on type to disable.
         * </p>
         * 
         * @param addOnType
         *        The add-on type to disable.
         * @see AddOnType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddOnType
         */
        Builder addOnType(AddOnType addOnType);

        /**
         * <p>
         * The name of the source resource for which to disable the add-on.
         * </p>
         * 
         * @param resourceName
         *        The name of the source resource for which to disable the add-on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String addOnType;

        private String resourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableAddOnRequest model) {
            super(model);
            addOnType(model.addOnType);
            resourceName(model.resourceName);
        }

        public final String getAddOnType() {
            return addOnType;
        }

        public final void setAddOnType(String addOnType) {
            this.addOnType = addOnType;
        }

        @Override
        public final Builder addOnType(String addOnType) {
            this.addOnType = addOnType;
            return this;
        }

        @Override
        public final Builder addOnType(AddOnType addOnType) {
            this.addOnType(addOnType == null ? null : addOnType.toString());
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisableAddOnRequest build() {
            return new DisableAddOnRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
