/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the domain name system (DNS) records that you must add to the DNS of your registered domain to validate
 * ownership for an Amazon Lightsail SSL/TLS certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainValidationRecord implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainValidationRecord.Builder, DomainValidationRecord> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainName").getter(getter(DomainValidationRecord::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<ResourceRecord> RESOURCE_RECORD_FIELD = SdkField
            .<ResourceRecord> builder(MarshallingType.SDK_POJO).memberName("resourceRecord")
            .getter(getter(DomainValidationRecord::resourceRecord)).setter(setter(Builder::resourceRecord))
            .constructor(ResourceRecord::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceRecord").build()).build();

    private static final SdkField<DnsRecordCreationState> DNS_RECORD_CREATION_STATE_FIELD = SdkField
            .<DnsRecordCreationState> builder(MarshallingType.SDK_POJO).memberName("dnsRecordCreationState")
            .getter(getter(DomainValidationRecord::dnsRecordCreationState)).setter(setter(Builder::dnsRecordCreationState))
            .constructor(DnsRecordCreationState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsRecordCreationState").build())
            .build();

    private static final SdkField<String> VALIDATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("validationStatus").getter(getter(DomainValidationRecord::validationStatusAsString))
            .setter(setter(Builder::validationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            RESOURCE_RECORD_FIELD, DNS_RECORD_CREATION_STATE_FIELD, VALIDATION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domainName;

    private final ResourceRecord resourceRecord;

    private final DnsRecordCreationState dnsRecordCreationState;

    private final String validationStatus;

    private DomainValidationRecord(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.resourceRecord = builder.resourceRecord;
        this.dnsRecordCreationState = builder.dnsRecordCreationState;
        this.validationStatus = builder.validationStatus;
    }

    /**
     * <p>
     * The domain name of the certificate validation record. For example, <code>example.com</code> or
     * <code>www.example.com</code>.
     * </p>
     * 
     * @return The domain name of the certificate validation record. For example, <code>example.com</code> or
     *         <code>www.example.com</code>.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * An object that describes the DNS records to add to your domain's DNS to validate it for the certificate.
     * </p>
     * 
     * @return An object that describes the DNS records to add to your domain's DNS to validate it for the certificate.
     */
    public final ResourceRecord resourceRecord() {
        return resourceRecord;
    }

    /**
     * <p>
     * An object that describes the state of the canonical name (CNAME) records that are automatically added by
     * Lightsail to the DNS of the domain to validate domain ownership.
     * </p>
     * 
     * @return An object that describes the state of the canonical name (CNAME) records that are automatically added by
     *         Lightsail to the DNS of the domain to validate domain ownership.
     */
    public final DnsRecordCreationState dnsRecordCreationState() {
        return dnsRecordCreationState;
    }

    /**
     * <p>
     * The validation status of the record.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationStatus}
     * will return {@link CertificateDomainValidationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #validationStatusAsString}.
     * </p>
     * 
     * @return The validation status of the record.
     * @see CertificateDomainValidationStatus
     */
    public final CertificateDomainValidationStatus validationStatus() {
        return CertificateDomainValidationStatus.fromValue(validationStatus);
    }

    /**
     * <p>
     * The validation status of the record.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationStatus}
     * will return {@link CertificateDomainValidationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #validationStatusAsString}.
     * </p>
     * 
     * @return The validation status of the record.
     * @see CertificateDomainValidationStatus
     */
    public final String validationStatusAsString() {
        return validationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceRecord());
        hashCode = 31 * hashCode + Objects.hashCode(dnsRecordCreationState());
        hashCode = 31 * hashCode + Objects.hashCode(validationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainValidationRecord)) {
            return false;
        }
        DomainValidationRecord other = (DomainValidationRecord) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(resourceRecord(), other.resourceRecord())
                && Objects.equals(dnsRecordCreationState(), other.dnsRecordCreationState())
                && Objects.equals(validationStatusAsString(), other.validationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainValidationRecord").add("DomainName", domainName()).add("ResourceRecord", resourceRecord())
                .add("DnsRecordCreationState", dnsRecordCreationState()).add("ValidationStatus", validationStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "resourceRecord":
            return Optional.ofNullable(clazz.cast(resourceRecord()));
        case "dnsRecordCreationState":
            return Optional.ofNullable(clazz.cast(dnsRecordCreationState()));
        case "validationStatus":
            return Optional.ofNullable(clazz.cast(validationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("resourceRecord", RESOURCE_RECORD_FIELD);
        map.put("dnsRecordCreationState", DNS_RECORD_CREATION_STATE_FIELD);
        map.put("validationStatus", VALIDATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DomainValidationRecord, T> g) {
        return obj -> g.apply((DomainValidationRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainValidationRecord> {
        /**
         * <p>
         * The domain name of the certificate validation record. For example, <code>example.com</code> or
         * <code>www.example.com</code>.
         * </p>
         * 
         * @param domainName
         *        The domain name of the certificate validation record. For example, <code>example.com</code> or
         *        <code>www.example.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * An object that describes the DNS records to add to your domain's DNS to validate it for the certificate.
         * </p>
         * 
         * @param resourceRecord
         *        An object that describes the DNS records to add to your domain's DNS to validate it for the
         *        certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRecord(ResourceRecord resourceRecord);

        /**
         * <p>
         * An object that describes the DNS records to add to your domain's DNS to validate it for the certificate.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceRecord.Builder} avoiding the need
         * to create one manually via {@link ResourceRecord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceRecord.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceRecord(ResourceRecord)}.
         * 
         * @param resourceRecord
         *        a consumer that will call methods on {@link ResourceRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceRecord(ResourceRecord)
         */
        default Builder resourceRecord(Consumer<ResourceRecord.Builder> resourceRecord) {
            return resourceRecord(ResourceRecord.builder().applyMutation(resourceRecord).build());
        }

        /**
         * <p>
         * An object that describes the state of the canonical name (CNAME) records that are automatically added by
         * Lightsail to the DNS of the domain to validate domain ownership.
         * </p>
         * 
         * @param dnsRecordCreationState
         *        An object that describes the state of the canonical name (CNAME) records that are automatically added
         *        by Lightsail to the DNS of the domain to validate domain ownership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsRecordCreationState(DnsRecordCreationState dnsRecordCreationState);

        /**
         * <p>
         * An object that describes the state of the canonical name (CNAME) records that are automatically added by
         * Lightsail to the DNS of the domain to validate domain ownership.
         * </p>
         * This is a convenience method that creates an instance of the {@link DnsRecordCreationState.Builder} avoiding
         * the need to create one manually via {@link DnsRecordCreationState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DnsRecordCreationState.Builder#build()} is called immediately and
         * its result is passed to {@link #dnsRecordCreationState(DnsRecordCreationState)}.
         * 
         * @param dnsRecordCreationState
         *        a consumer that will call methods on {@link DnsRecordCreationState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsRecordCreationState(DnsRecordCreationState)
         */
        default Builder dnsRecordCreationState(Consumer<DnsRecordCreationState.Builder> dnsRecordCreationState) {
            return dnsRecordCreationState(DnsRecordCreationState.builder().applyMutation(dnsRecordCreationState).build());
        }

        /**
         * <p>
         * The validation status of the record.
         * </p>
         * 
         * @param validationStatus
         *        The validation status of the record.
         * @see CertificateDomainValidationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateDomainValidationStatus
         */
        Builder validationStatus(String validationStatus);

        /**
         * <p>
         * The validation status of the record.
         * </p>
         * 
         * @param validationStatus
         *        The validation status of the record.
         * @see CertificateDomainValidationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateDomainValidationStatus
         */
        Builder validationStatus(CertificateDomainValidationStatus validationStatus);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private ResourceRecord resourceRecord;

        private DnsRecordCreationState dnsRecordCreationState;

        private String validationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainValidationRecord model) {
            domainName(model.domainName);
            resourceRecord(model.resourceRecord);
            dnsRecordCreationState(model.dnsRecordCreationState);
            validationStatus(model.validationStatus);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final ResourceRecord.Builder getResourceRecord() {
            return resourceRecord != null ? resourceRecord.toBuilder() : null;
        }

        public final void setResourceRecord(ResourceRecord.BuilderImpl resourceRecord) {
            this.resourceRecord = resourceRecord != null ? resourceRecord.build() : null;
        }

        @Override
        public final Builder resourceRecord(ResourceRecord resourceRecord) {
            this.resourceRecord = resourceRecord;
            return this;
        }

        public final DnsRecordCreationState.Builder getDnsRecordCreationState() {
            return dnsRecordCreationState != null ? dnsRecordCreationState.toBuilder() : null;
        }

        public final void setDnsRecordCreationState(DnsRecordCreationState.BuilderImpl dnsRecordCreationState) {
            this.dnsRecordCreationState = dnsRecordCreationState != null ? dnsRecordCreationState.build() : null;
        }

        @Override
        public final Builder dnsRecordCreationState(DnsRecordCreationState dnsRecordCreationState) {
            this.dnsRecordCreationState = dnsRecordCreationState;
            return this;
        }

        public final String getValidationStatus() {
            return validationStatus;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public final Builder validationStatus(CertificateDomainValidationStatus validationStatus) {
            this.validationStatus(validationStatus == null ? null : validationStatus.toString());
            return this;
        }

        @Override
        public DomainValidationRecord build() {
            return new DomainValidationRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
