/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DownloadDefaultKeyPairResponse extends LightsailResponse implements
        ToCopyableBuilder<DownloadDefaultKeyPairResponse.Builder, DownloadDefaultKeyPairResponse> {
    private static final SdkField<String> PUBLIC_KEY_BASE64_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("publicKeyBase64").getter(getter(DownloadDefaultKeyPairResponse::publicKeyBase64))
            .setter(setter(Builder::publicKeyBase64))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicKeyBase64").build()).build();

    private static final SdkField<String> PRIVATE_KEY_BASE64_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("privateKeyBase64").getter(getter(DownloadDefaultKeyPairResponse::privateKeyBase64))
            .setter(setter(Builder::privateKeyBase64))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateKeyBase64").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(DownloadDefaultKeyPairResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_KEY_BASE64_FIELD,
            PRIVATE_KEY_BASE64_FIELD, CREATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String publicKeyBase64;

    private final String privateKeyBase64;

    private final Instant createdAt;

    private DownloadDefaultKeyPairResponse(BuilderImpl builder) {
        super(builder);
        this.publicKeyBase64 = builder.publicKeyBase64;
        this.privateKeyBase64 = builder.privateKeyBase64;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * A base64-encoded public key of the <code>ssh-rsa</code> type.
     * </p>
     * 
     * @return A base64-encoded public key of the <code>ssh-rsa</code> type.
     */
    public final String publicKeyBase64() {
        return publicKeyBase64;
    }

    /**
     * <p>
     * A base64-encoded RSA private key.
     * </p>
     * 
     * @return A base64-encoded RSA private key.
     */
    public final String privateKeyBase64() {
        return privateKeyBase64;
    }

    /**
     * <p>
     * The timestamp when the default key pair was created.
     * </p>
     * 
     * @return The timestamp when the default key pair was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(publicKeyBase64());
        hashCode = 31 * hashCode + Objects.hashCode(privateKeyBase64());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DownloadDefaultKeyPairResponse)) {
            return false;
        }
        DownloadDefaultKeyPairResponse other = (DownloadDefaultKeyPairResponse) obj;
        return Objects.equals(publicKeyBase64(), other.publicKeyBase64())
                && Objects.equals(privateKeyBase64(), other.privateKeyBase64()) && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DownloadDefaultKeyPairResponse").add("PublicKeyBase64", publicKeyBase64())
                .add("PrivateKeyBase64", privateKeyBase64()).add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "publicKeyBase64":
            return Optional.ofNullable(clazz.cast(publicKeyBase64()));
        case "privateKeyBase64":
            return Optional.ofNullable(clazz.cast(privateKeyBase64()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("publicKeyBase64", PUBLIC_KEY_BASE64_FIELD);
        map.put("privateKeyBase64", PRIVATE_KEY_BASE64_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DownloadDefaultKeyPairResponse, T> g) {
        return obj -> g.apply((DownloadDefaultKeyPairResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, DownloadDefaultKeyPairResponse> {
        /**
         * <p>
         * A base64-encoded public key of the <code>ssh-rsa</code> type.
         * </p>
         * 
         * @param publicKeyBase64
         *        A base64-encoded public key of the <code>ssh-rsa</code> type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeyBase64(String publicKeyBase64);

        /**
         * <p>
         * A base64-encoded RSA private key.
         * </p>
         * 
         * @param privateKeyBase64
         *        A base64-encoded RSA private key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKeyBase64(String privateKeyBase64);

        /**
         * <p>
         * The timestamp when the default key pair was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the default key pair was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private String publicKeyBase64;

        private String privateKeyBase64;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DownloadDefaultKeyPairResponse model) {
            super(model);
            publicKeyBase64(model.publicKeyBase64);
            privateKeyBase64(model.privateKeyBase64);
            createdAt(model.createdAt);
        }

        public final String getPublicKeyBase64() {
            return publicKeyBase64;
        }

        public final void setPublicKeyBase64(String publicKeyBase64) {
            this.publicKeyBase64 = publicKeyBase64;
        }

        @Override
        public final Builder publicKeyBase64(String publicKeyBase64) {
            this.publicKeyBase64 = publicKeyBase64;
            return this;
        }

        public final String getPrivateKeyBase64() {
            return privateKeyBase64;
        }

        public final void setPrivateKeyBase64(String privateKeyBase64) {
            this.privateKeyBase64 = privateKeyBase64;
        }

        @Override
        public final Builder privateKeyBase64(String privateKeyBase64) {
            this.privateKeyBase64 = privateKeyBase64;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public DownloadDefaultKeyPairResponse build() {
            return new DownloadDefaultKeyPairResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
