/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBundlesResponse extends LightsailResponse implements
        ToCopyableBuilder<GetBundlesResponse.Builder, GetBundlesResponse> {
    private static final SdkField<List<Bundle>> BUNDLES_FIELD = SdkField
            .<List<Bundle>> builder(MarshallingType.LIST)
            .memberName("bundles")
            .getter(getter(GetBundlesResponse::bundles))
            .setter(setter(Builder::bundles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Bundle> builder(MarshallingType.SDK_POJO)
                                            .constructor(Bundle::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextPageToken").getter(getter(GetBundlesResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLES_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Bundle> bundles;

    private final String nextPageToken;

    private GetBundlesResponse(BuilderImpl builder) {
        super(builder);
        this.bundles = builder.bundles;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Bundles property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBundles() {
        return bundles != null && !(bundles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs that contains information about the available bundles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBundles} method.
     * </p>
     * 
     * @return An array of key-value pairs that contains information about the available bundles.
     */
    public final List<Bundle> bundles() {
        return bundles;
    }

    /**
     * <p>
     * The token to advance to the next page of results from your request.
     * </p>
     * <p>
     * A next page token is not returned if there are no more results to display.
     * </p>
     * <p>
     * To get the next page of results, perform another <code>GetBundles</code> request and specify the next page token
     * using the <code>pageToken</code> parameter.
     * </p>
     * 
     * @return The token to advance to the next page of results from your request.</p>
     *         <p>
     *         A next page token is not returned if there are no more results to display.
     *         </p>
     *         <p>
     *         To get the next page of results, perform another <code>GetBundles</code> request and specify the next
     *         page token using the <code>pageToken</code> parameter.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBundles() ? bundles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBundlesResponse)) {
            return false;
        }
        GetBundlesResponse other = (GetBundlesResponse) obj;
        return hasBundles() == other.hasBundles() && Objects.equals(bundles(), other.bundles())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBundlesResponse").add("Bundles", hasBundles() ? bundles() : null)
                .add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bundles":
            return Optional.ofNullable(clazz.cast(bundles()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bundles", BUNDLES_FIELD);
        map.put("nextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBundlesResponse, T> g) {
        return obj -> g.apply((GetBundlesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBundlesResponse> {
        /**
         * <p>
         * An array of key-value pairs that contains information about the available bundles.
         * </p>
         * 
         * @param bundles
         *        An array of key-value pairs that contains information about the available bundles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundles(Collection<Bundle> bundles);

        /**
         * <p>
         * An array of key-value pairs that contains information about the available bundles.
         * </p>
         * 
         * @param bundles
         *        An array of key-value pairs that contains information about the available bundles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundles(Bundle... bundles);

        /**
         * <p>
         * An array of key-value pairs that contains information about the available bundles.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lightsail.model.Bundle.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lightsail.model.Bundle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lightsail.model.Bundle.Builder#build()} is called immediately and its
         * result is passed to {@link #bundles(List<Bundle>)}.
         * 
         * @param bundles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lightsail.model.Bundle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bundles(java.util.Collection<Bundle>)
         */
        Builder bundles(Consumer<Bundle.Builder>... bundles);

        /**
         * <p>
         * The token to advance to the next page of results from your request.
         * </p>
         * <p>
         * A next page token is not returned if there are no more results to display.
         * </p>
         * <p>
         * To get the next page of results, perform another <code>GetBundles</code> request and specify the next page
         * token using the <code>pageToken</code> parameter.
         * </p>
         * 
         * @param nextPageToken
         *        The token to advance to the next page of results from your request.</p>
         *        <p>
         *        A next page token is not returned if there are no more results to display.
         *        </p>
         *        <p>
         *        To get the next page of results, perform another <code>GetBundles</code> request and specify the next
         *        page token using the <code>pageToken</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<Bundle> bundles = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBundlesResponse model) {
            super(model);
            bundles(model.bundles);
            nextPageToken(model.nextPageToken);
        }

        public final List<Bundle.Builder> getBundles() {
            List<Bundle.Builder> result = BundleListCopier.copyToBuilder(this.bundles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBundles(Collection<Bundle.BuilderImpl> bundles) {
            this.bundles = BundleListCopier.copyFromBuilder(bundles);
        }

        @Override
        public final Builder bundles(Collection<Bundle> bundles) {
            this.bundles = BundleListCopier.copy(bundles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundles(Bundle... bundles) {
            bundles(Arrays.asList(bundles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundles(Consumer<Bundle.Builder>... bundles) {
            bundles(Stream.of(bundles).map(c -> Bundle.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetBundlesResponse build() {
            return new GetBundlesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
