/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetContactMethodsRequest extends LightsailRequest implements
        ToCopyableBuilder<GetContactMethodsRequest.Builder, GetContactMethodsRequest> {
    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("protocols")
            .getter(getter(GetContactMethodsRequest::protocolsAsStrings))
            .setter(setter(Builder::protocolsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocols").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> protocols;

    private GetContactMethodsRequest(BuilderImpl builder) {
        super(builder);
        this.protocols = builder.protocols;
    }

    /**
     * <p>
     * The protocols used to send notifications, such as <code>Email</code>, or <code>SMS</code> (text messaging).
     * </p>
     * <p>
     * Specify a protocol in your request to return information about a specific contact method protocol.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProtocols} method.
     * </p>
     * 
     * @return The protocols used to send notifications, such as <code>Email</code>, or <code>SMS</code> (text
     *         messaging).</p>
     *         <p>
     *         Specify a protocol in your request to return information about a specific contact method protocol.
     */
    public final List<ContactProtocol> protocols() {
        return ContactProtocolsListCopier.copyStringToEnum(protocols);
    }

    /**
     * For responses, this returns true if the service returned a value for the Protocols property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProtocols() {
        return protocols != null && !(protocols instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The protocols used to send notifications, such as <code>Email</code>, or <code>SMS</code> (text messaging).
     * </p>
     * <p>
     * Specify a protocol in your request to return information about a specific contact method protocol.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProtocols} method.
     * </p>
     * 
     * @return The protocols used to send notifications, such as <code>Email</code>, or <code>SMS</code> (text
     *         messaging).</p>
     *         <p>
     *         Specify a protocol in your request to return information about a specific contact method protocol.
     */
    public final List<String> protocolsAsStrings() {
        return protocols;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProtocols() ? protocolsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContactMethodsRequest)) {
            return false;
        }
        GetContactMethodsRequest other = (GetContactMethodsRequest) obj;
        return hasProtocols() == other.hasProtocols() && Objects.equals(protocolsAsStrings(), other.protocolsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetContactMethodsRequest").add("Protocols", hasProtocols() ? protocolsAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "protocols":
            return Optional.ofNullable(clazz.cast(protocolsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("protocols", PROTOCOLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetContactMethodsRequest, T> g) {
        return obj -> g.apply((GetContactMethodsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetContactMethodsRequest> {
        /**
         * <p>
         * The protocols used to send notifications, such as <code>Email</code>, or <code>SMS</code> (text messaging).
         * </p>
         * <p>
         * Specify a protocol in your request to return information about a specific contact method protocol.
         * </p>
         * 
         * @param protocols
         *        The protocols used to send notifications, such as <code>Email</code>, or <code>SMS</code> (text
         *        messaging).</p>
         *        <p>
         *        Specify a protocol in your request to return information about a specific contact method protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolsWithStrings(Collection<String> protocols);

        /**
         * <p>
         * The protocols used to send notifications, such as <code>Email</code>, or <code>SMS</code> (text messaging).
         * </p>
         * <p>
         * Specify a protocol in your request to return information about a specific contact method protocol.
         * </p>
         * 
         * @param protocols
         *        The protocols used to send notifications, such as <code>Email</code>, or <code>SMS</code> (text
         *        messaging).</p>
         *        <p>
         *        Specify a protocol in your request to return information about a specific contact method protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolsWithStrings(String... protocols);

        /**
         * <p>
         * The protocols used to send notifications, such as <code>Email</code>, or <code>SMS</code> (text messaging).
         * </p>
         * <p>
         * Specify a protocol in your request to return information about a specific contact method protocol.
         * </p>
         * 
         * @param protocols
         *        The protocols used to send notifications, such as <code>Email</code>, or <code>SMS</code> (text
         *        messaging).</p>
         *        <p>
         *        Specify a protocol in your request to return information about a specific contact method protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocols(Collection<ContactProtocol> protocols);

        /**
         * <p>
         * The protocols used to send notifications, such as <code>Email</code>, or <code>SMS</code> (text messaging).
         * </p>
         * <p>
         * Specify a protocol in your request to return information about a specific contact method protocol.
         * </p>
         * 
         * @param protocols
         *        The protocols used to send notifications, such as <code>Email</code>, or <code>SMS</code> (text
         *        messaging).</p>
         *        <p>
         *        Specify a protocol in your request to return information about a specific contact method protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocols(ContactProtocol... protocols);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetContactMethodsRequest model) {
            super(model);
            protocolsWithStrings(model.protocols);
        }

        public final Collection<String> getProtocols() {
            if (protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return protocols;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = ContactProtocolsListCopier.copy(protocols);
        }

        @Override
        public final Builder protocolsWithStrings(Collection<String> protocols) {
            this.protocols = ContactProtocolsListCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsWithStrings(String... protocols) {
            protocolsWithStrings(Arrays.asList(protocols));
            return this;
        }

        @Override
        public final Builder protocols(Collection<ContactProtocol> protocols) {
            this.protocols = ContactProtocolsListCopier.copyEnumToString(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(ContactProtocol... protocols) {
            protocols(Arrays.asList(protocols));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetContactMethodsRequest build() {
            return new GetContactMethodsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
