/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetContainerApiMetadataResponse extends LightsailResponse implements
        ToCopyableBuilder<GetContainerApiMetadataResponse.Builder, GetContainerApiMetadataResponse> {
    private static final SdkField<List<Map<String, String>>> METADATA_FIELD = SdkField
            .<List<Map<String, String>>> builder(MarshallingType.LIST)
            .memberName("metadata")
            .getter(getter(GetContainerApiMetadataResponse::metadata))
            .setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Map<String, String>> metadata;

    private GetContainerApiMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.metadata = builder.metadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metadata property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetadata() {
        return metadata != null && !(metadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata about Lightsail containers, such as the current version of the Lightsail Control (lightsailctl) plugin.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadata} method.
     * </p>
     * 
     * @return Metadata about Lightsail containers, such as the current version of the Lightsail Control (lightsailctl)
     *         plugin.
     */
    public final List<Map<String, String>> metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadata() ? metadata() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContainerApiMetadataResponse)) {
            return false;
        }
        GetContainerApiMetadataResponse other = (GetContainerApiMetadataResponse) obj;
        return hasMetadata() == other.hasMetadata() && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetContainerApiMetadataResponse").add("Metadata", hasMetadata() ? metadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetContainerApiMetadataResponse, T> g) {
        return obj -> g.apply((GetContainerApiMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetContainerApiMetadataResponse> {
        /**
         * <p>
         * Metadata about Lightsail containers, such as the current version of the Lightsail Control (lightsailctl)
         * plugin.
         * </p>
         * 
         * @param metadata
         *        Metadata about Lightsail containers, such as the current version of the Lightsail Control
         *        (lightsailctl) plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Collection<? extends Map<String, String>> metadata);

        /**
         * <p>
         * Metadata about Lightsail containers, such as the current version of the Lightsail Control (lightsailctl)
         * plugin.
         * </p>
         * 
         * @param metadata
         *        Metadata about Lightsail containers, such as the current version of the Lightsail Control
         *        (lightsailctl) plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Map<String, String>... metadata);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<Map<String, String>> metadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetContainerApiMetadataResponse model) {
            super(model);
            metadata(model.metadata);
        }

        public final Collection<? extends Map<String, String>> getMetadata() {
            if (metadata instanceof SdkAutoConstructList) {
                return null;
            }
            return metadata;
        }

        public final void setMetadata(Collection<? extends Map<String, String>> metadata) {
            this.metadata = ContainerServiceMetadataEntryListCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Collection<? extends Map<String, String>> metadata) {
            this.metadata = ContainerServiceMetadataEntryListCopier.copy(metadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadata(Map<String, String>... metadata) {
            metadata(Arrays.asList(metadata));
            return this;
        }

        @Override
        public GetContainerApiMetadataResponse build() {
            return new GetContainerApiMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
