/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOperationsForResourceResponse extends LightsailResponse implements
        ToCopyableBuilder<GetOperationsForResourceResponse.Builder, GetOperationsForResourceResponse> {
    private static final SdkField<List<Operation>> OPERATIONS_FIELD = SdkField
            .<List<Operation>> builder(MarshallingType.LIST)
            .memberName("operations")
            .getter(getter(GetOperationsForResourceResponse::operations))
            .setter(setter(Builder::operations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Operation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Operation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_COUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextPageCount").getter(getter(GetOperationsForResourceResponse::nextPageCount))
            .setter(setter(Builder::nextPageCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageCount").build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextPageToken").getter(getter(GetOperationsForResourceResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATIONS_FIELD,
            NEXT_PAGE_COUNT_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Operation> operations;

    private final String nextPageCount;

    private final String nextPageToken;

    private GetOperationsForResourceResponse(BuilderImpl builder) {
        super(builder);
        this.operations = builder.operations;
        this.nextPageCount = builder.nextPageCount;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Operations property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOperations() {
        return operations != null && !(operations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe the result of the action, such as the status of the request, the timestamp of
     * the request, and the resources affected by the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperations} method.
     * </p>
     * 
     * @return An array of objects that describe the result of the action, such as the status of the request, the
     *         timestamp of the request, and the resources affected by the request.
     */
    public final List<Operation> operations() {
        return operations;
    }

    /**
     * <p>
     * (Discontinued) Returns the number of pages of results that remain.
     * </p>
     * <note>
     * <p>
     * In releases prior to June 12, 2017, this parameter returned <code>null</code> by the API. It is now discontinued,
     * and the API returns the <code>next page token</code> parameter instead.
     * </p>
     * </note>
     * 
     * @return (Discontinued) Returns the number of pages of results that remain.</p> <note>
     *         <p>
     *         In releases prior to June 12, 2017, this parameter returned <code>null</code> by the API. It is now
     *         discontinued, and the API returns the <code>next page token</code> parameter instead.
     *         </p>
     * @deprecated
     */
    @Deprecated
    public final String nextPageCount() {
        return nextPageCount;
    }

    /**
     * <p>
     * The token to advance to the next page of results from your request.
     * </p>
     * <p>
     * A next page token is not returned if there are no more results to display.
     * </p>
     * <p>
     * To get the next page of results, perform another <code>GetOperationsForResource</code> request and specify the
     * next page token using the <code>pageToken</code> parameter.
     * </p>
     * 
     * @return The token to advance to the next page of results from your request.</p>
     *         <p>
     *         A next page token is not returned if there are no more results to display.
     *         </p>
     *         <p>
     *         To get the next page of results, perform another <code>GetOperationsForResource</code> request and
     *         specify the next page token using the <code>pageToken</code> parameter.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasOperations() ? operations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageCount());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOperationsForResourceResponse)) {
            return false;
        }
        GetOperationsForResourceResponse other = (GetOperationsForResourceResponse) obj;
        return hasOperations() == other.hasOperations() && Objects.equals(operations(), other.operations())
                && Objects.equals(nextPageCount(), other.nextPageCount())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOperationsForResourceResponse").add("Operations", hasOperations() ? operations() : null)
                .add("NextPageCount", nextPageCount()).add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "operations":
            return Optional.ofNullable(clazz.cast(operations()));
        case "nextPageCount":
            return Optional.ofNullable(clazz.cast(nextPageCount()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("operations", OPERATIONS_FIELD);
        map.put("nextPageCount", NEXT_PAGE_COUNT_FIELD);
        map.put("nextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOperationsForResourceResponse, T> g) {
        return obj -> g.apply((GetOperationsForResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetOperationsForResourceResponse> {
        /**
         * <p>
         * An array of objects that describe the result of the action, such as the status of the request, the timestamp
         * of the request, and the resources affected by the request.
         * </p>
         * 
         * @param operations
         *        An array of objects that describe the result of the action, such as the status of the request, the
         *        timestamp of the request, and the resources affected by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Collection<Operation> operations);

        /**
         * <p>
         * An array of objects that describe the result of the action, such as the status of the request, the timestamp
         * of the request, and the resources affected by the request.
         * </p>
         * 
         * @param operations
         *        An array of objects that describe the result of the action, such as the status of the request, the
         *        timestamp of the request, and the resources affected by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Operation... operations);

        /**
         * <p>
         * An array of objects that describe the result of the action, such as the status of the request, the timestamp
         * of the request, and the resources affected by the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lightsail.model.Operation.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lightsail.model.Operation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lightsail.model.Operation.Builder#build()} is called immediately and
         * its result is passed to {@link #operations(List<Operation>)}.
         * 
         * @param operations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lightsail.model.Operation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operations(java.util.Collection<Operation>)
         */
        Builder operations(Consumer<Operation.Builder>... operations);

        /**
         * <p>
         * (Discontinued) Returns the number of pages of results that remain.
         * </p>
         * <note>
         * <p>
         * In releases prior to June 12, 2017, this parameter returned <code>null</code> by the API. It is now
         * discontinued, and the API returns the <code>next page token</code> parameter instead.
         * </p>
         * </note>
         * 
         * @param nextPageCount
         *        (Discontinued) Returns the number of pages of results that remain.</p> <note>
         *        <p>
         *        In releases prior to June 12, 2017, this parameter returned <code>null</code> by the API. It is now
         *        discontinued, and the API returns the <code>next page token</code> parameter instead.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder nextPageCount(String nextPageCount);

        /**
         * <p>
         * The token to advance to the next page of results from your request.
         * </p>
         * <p>
         * A next page token is not returned if there are no more results to display.
         * </p>
         * <p>
         * To get the next page of results, perform another <code>GetOperationsForResource</code> request and specify
         * the next page token using the <code>pageToken</code> parameter.
         * </p>
         * 
         * @param nextPageToken
         *        The token to advance to the next page of results from your request.</p>
         *        <p>
         *        A next page token is not returned if there are no more results to display.
         *        </p>
         *        <p>
         *        To get the next page of results, perform another <code>GetOperationsForResource</code> request and
         *        specify the next page token using the <code>pageToken</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<Operation> operations = DefaultSdkAutoConstructList.getInstance();

        private String nextPageCount;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOperationsForResourceResponse model) {
            super(model);
            operations(model.operations);
            nextPageCount(model.nextPageCount);
            nextPageToken(model.nextPageToken);
        }

        public final List<Operation.Builder> getOperations() {
            List<Operation.Builder> result = OperationListCopier.copyToBuilder(this.operations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperations(Collection<Operation.BuilderImpl> operations) {
            this.operations = OperationListCopier.copyFromBuilder(operations);
        }

        @Override
        public final Builder operations(Collection<Operation> operations) {
            this.operations = OperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Operation... operations) {
            operations(Arrays.asList(operations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Consumer<Operation.Builder>... operations) {
            operations(Stream.of(operations).map(c -> Operation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final String getNextPageCount() {
            return nextPageCount;
        }

        @Deprecated
        public final void setNextPageCount(String nextPageCount) {
            this.nextPageCount = nextPageCount;
        }

        @Override
        @Deprecated
        public final Builder nextPageCount(String nextPageCount) {
            this.nextPageCount = nextPageCount;
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetOperationsForResourceResponse build() {
            return new GetOperationsForResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
