/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRelationalDatabaseLogEventsResponse extends LightsailResponse implements
        ToCopyableBuilder<GetRelationalDatabaseLogEventsResponse.Builder, GetRelationalDatabaseLogEventsResponse> {
    private static final SdkField<List<LogEvent>> RESOURCE_LOG_EVENTS_FIELD = SdkField
            .<List<LogEvent>> builder(MarshallingType.LIST)
            .memberName("resourceLogEvents")
            .getter(getter(GetRelationalDatabaseLogEventsResponse::resourceLogEvents))
            .setter(setter(Builder::resourceLogEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceLogEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LogEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_BACKWARD_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextBackwardToken").getter(getter(GetRelationalDatabaseLogEventsResponse::nextBackwardToken))
            .setter(setter(Builder::nextBackwardToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextBackwardToken").build()).build();

    private static final SdkField<String> NEXT_FORWARD_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextForwardToken").getter(getter(GetRelationalDatabaseLogEventsResponse::nextForwardToken))
            .setter(setter(Builder::nextForwardToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextForwardToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_LOG_EVENTS_FIELD,
            NEXT_BACKWARD_TOKEN_FIELD, NEXT_FORWARD_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<LogEvent> resourceLogEvents;

    private final String nextBackwardToken;

    private final String nextForwardToken;

    private GetRelationalDatabaseLogEventsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceLogEvents = builder.resourceLogEvents;
        this.nextBackwardToken = builder.nextBackwardToken;
        this.nextForwardToken = builder.nextForwardToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceLogEvents property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceLogEvents() {
        return resourceLogEvents != null && !(resourceLogEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object describing the result of your get relational database log events request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceLogEvents} method.
     * </p>
     * 
     * @return An object describing the result of your get relational database log events request.
     */
    public final List<LogEvent> resourceLogEvents() {
        return resourceLogEvents;
    }

    /**
     * <p>
     * A token used for advancing to the previous page of results from your get relational database log events request.
     * </p>
     * 
     * @return A token used for advancing to the previous page of results from your get relational database log events
     *         request.
     */
    public final String nextBackwardToken() {
        return nextBackwardToken;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results from your get relational database log events request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results from your get relational database log events
     *         request.
     */
    public final String nextForwardToken() {
        return nextForwardToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceLogEvents() ? resourceLogEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextBackwardToken());
        hashCode = 31 * hashCode + Objects.hashCode(nextForwardToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabaseLogEventsResponse)) {
            return false;
        }
        GetRelationalDatabaseLogEventsResponse other = (GetRelationalDatabaseLogEventsResponse) obj;
        return hasResourceLogEvents() == other.hasResourceLogEvents()
                && Objects.equals(resourceLogEvents(), other.resourceLogEvents())
                && Objects.equals(nextBackwardToken(), other.nextBackwardToken())
                && Objects.equals(nextForwardToken(), other.nextForwardToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRelationalDatabaseLogEventsResponse")
                .add("ResourceLogEvents", hasResourceLogEvents() ? resourceLogEvents() : null)
                .add("NextBackwardToken", nextBackwardToken()).add("NextForwardToken", nextForwardToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceLogEvents":
            return Optional.ofNullable(clazz.cast(resourceLogEvents()));
        case "nextBackwardToken":
            return Optional.ofNullable(clazz.cast(nextBackwardToken()));
        case "nextForwardToken":
            return Optional.ofNullable(clazz.cast(nextForwardToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceLogEvents", RESOURCE_LOG_EVENTS_FIELD);
        map.put("nextBackwardToken", NEXT_BACKWARD_TOKEN_FIELD);
        map.put("nextForwardToken", NEXT_FORWARD_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRelationalDatabaseLogEventsResponse, T> g) {
        return obj -> g.apply((GetRelationalDatabaseLogEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRelationalDatabaseLogEventsResponse> {
        /**
         * <p>
         * An object describing the result of your get relational database log events request.
         * </p>
         * 
         * @param resourceLogEvents
         *        An object describing the result of your get relational database log events request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceLogEvents(Collection<LogEvent> resourceLogEvents);

        /**
         * <p>
         * An object describing the result of your get relational database log events request.
         * </p>
         * 
         * @param resourceLogEvents
         *        An object describing the result of your get relational database log events request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceLogEvents(LogEvent... resourceLogEvents);

        /**
         * <p>
         * An object describing the result of your get relational database log events request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lightsail.model.LogEvent.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lightsail.model.LogEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lightsail.model.LogEvent.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceLogEvents(List<LogEvent>)}.
         * 
         * @param resourceLogEvents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lightsail.model.LogEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceLogEvents(java.util.Collection<LogEvent>)
         */
        Builder resourceLogEvents(Consumer<LogEvent.Builder>... resourceLogEvents);

        /**
         * <p>
         * A token used for advancing to the previous page of results from your get relational database log events
         * request.
         * </p>
         * 
         * @param nextBackwardToken
         *        A token used for advancing to the previous page of results from your get relational database log
         *        events request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextBackwardToken(String nextBackwardToken);

        /**
         * <p>
         * A token used for advancing to the next page of results from your get relational database log events request.
         * </p>
         * 
         * @param nextForwardToken
         *        A token used for advancing to the next page of results from your get relational database log events
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextForwardToken(String nextForwardToken);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<LogEvent> resourceLogEvents = DefaultSdkAutoConstructList.getInstance();

        private String nextBackwardToken;

        private String nextForwardToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationalDatabaseLogEventsResponse model) {
            super(model);
            resourceLogEvents(model.resourceLogEvents);
            nextBackwardToken(model.nextBackwardToken);
            nextForwardToken(model.nextForwardToken);
        }

        public final List<LogEvent.Builder> getResourceLogEvents() {
            List<LogEvent.Builder> result = LogEventListCopier.copyToBuilder(this.resourceLogEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceLogEvents(Collection<LogEvent.BuilderImpl> resourceLogEvents) {
            this.resourceLogEvents = LogEventListCopier.copyFromBuilder(resourceLogEvents);
        }

        @Override
        public final Builder resourceLogEvents(Collection<LogEvent> resourceLogEvents) {
            this.resourceLogEvents = LogEventListCopier.copy(resourceLogEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceLogEvents(LogEvent... resourceLogEvents) {
            resourceLogEvents(Arrays.asList(resourceLogEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceLogEvents(Consumer<LogEvent.Builder>... resourceLogEvents) {
            resourceLogEvents(Stream.of(resourceLogEvents).map(c -> LogEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextBackwardToken() {
            return nextBackwardToken;
        }

        public final void setNextBackwardToken(String nextBackwardToken) {
            this.nextBackwardToken = nextBackwardToken;
        }

        @Override
        public final Builder nextBackwardToken(String nextBackwardToken) {
            this.nextBackwardToken = nextBackwardToken;
            return this;
        }

        public final String getNextForwardToken() {
            return nextForwardToken;
        }

        public final void setNextForwardToken(String nextForwardToken) {
            this.nextForwardToken = nextForwardToken;
        }

        @Override
        public final Builder nextForwardToken(String nextForwardToken) {
            this.nextForwardToken = nextForwardToken;
            return this;
        }

        @Override
        public GetRelationalDatabaseLogEventsResponse build() {
            return new GetRelationalDatabaseLogEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
