/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRelationalDatabasesResponse extends LightsailResponse implements
        ToCopyableBuilder<GetRelationalDatabasesResponse.Builder, GetRelationalDatabasesResponse> {
    private static final SdkField<List<RelationalDatabase>> RELATIONAL_DATABASES_FIELD = SdkField
            .<List<RelationalDatabase>> builder(MarshallingType.LIST)
            .memberName("relationalDatabases")
            .getter(getter(GetRelationalDatabasesResponse::relationalDatabases))
            .setter(setter(Builder::relationalDatabases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RelationalDatabase> builder(MarshallingType.SDK_POJO)
                                            .constructor(RelationalDatabase::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextPageToken").getter(getter(GetRelationalDatabasesResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIONAL_DATABASES_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<RelationalDatabase> relationalDatabases;

    private final String nextPageToken;

    private GetRelationalDatabasesResponse(BuilderImpl builder) {
        super(builder);
        this.relationalDatabases = builder.relationalDatabases;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RelationalDatabases property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRelationalDatabases() {
        return relationalDatabases != null && !(relationalDatabases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object describing the result of your get relational databases request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRelationalDatabases} method.
     * </p>
     * 
     * @return An object describing the result of your get relational databases request.
     */
    public final List<RelationalDatabase> relationalDatabases() {
        return relationalDatabases;
    }

    /**
     * <p>
     * The token to advance to the next page of results from your request.
     * </p>
     * <p>
     * A next page token is not returned if there are no more results to display.
     * </p>
     * <p>
     * To get the next page of results, perform another <code>GetRelationalDatabases</code> request and specify the next
     * page token using the <code>pageToken</code> parameter.
     * </p>
     * 
     * @return The token to advance to the next page of results from your request.</p>
     *         <p>
     *         A next page token is not returned if there are no more results to display.
     *         </p>
     *         <p>
     *         To get the next page of results, perform another <code>GetRelationalDatabases</code> request and specify
     *         the next page token using the <code>pageToken</code> parameter.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRelationalDatabases() ? relationalDatabases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabasesResponse)) {
            return false;
        }
        GetRelationalDatabasesResponse other = (GetRelationalDatabasesResponse) obj;
        return hasRelationalDatabases() == other.hasRelationalDatabases()
                && Objects.equals(relationalDatabases(), other.relationalDatabases())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRelationalDatabasesResponse")
                .add("RelationalDatabases", hasRelationalDatabases() ? relationalDatabases() : null)
                .add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relationalDatabases":
            return Optional.ofNullable(clazz.cast(relationalDatabases()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("relationalDatabases", RELATIONAL_DATABASES_FIELD);
        map.put("nextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRelationalDatabasesResponse, T> g) {
        return obj -> g.apply((GetRelationalDatabasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRelationalDatabasesResponse> {
        /**
         * <p>
         * An object describing the result of your get relational databases request.
         * </p>
         * 
         * @param relationalDatabases
         *        An object describing the result of your get relational databases request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabases(Collection<RelationalDatabase> relationalDatabases);

        /**
         * <p>
         * An object describing the result of your get relational databases request.
         * </p>
         * 
         * @param relationalDatabases
         *        An object describing the result of your get relational databases request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabases(RelationalDatabase... relationalDatabases);

        /**
         * <p>
         * An object describing the result of your get relational databases request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lightsail.model.RelationalDatabase.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.lightsail.model.RelationalDatabase#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lightsail.model.RelationalDatabase.Builder#build()} is called
         * immediately and its result is passed to {@link #relationalDatabases(List<RelationalDatabase>)}.
         * 
         * @param relationalDatabases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lightsail.model.RelationalDatabase.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relationalDatabases(java.util.Collection<RelationalDatabase>)
         */
        Builder relationalDatabases(Consumer<RelationalDatabase.Builder>... relationalDatabases);

        /**
         * <p>
         * The token to advance to the next page of results from your request.
         * </p>
         * <p>
         * A next page token is not returned if there are no more results to display.
         * </p>
         * <p>
         * To get the next page of results, perform another <code>GetRelationalDatabases</code> request and specify the
         * next page token using the <code>pageToken</code> parameter.
         * </p>
         * 
         * @param nextPageToken
         *        The token to advance to the next page of results from your request.</p>
         *        <p>
         *        A next page token is not returned if there are no more results to display.
         *        </p>
         *        <p>
         *        To get the next page of results, perform another <code>GetRelationalDatabases</code> request and
         *        specify the next page token using the <code>pageToken</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<RelationalDatabase> relationalDatabases = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationalDatabasesResponse model) {
            super(model);
            relationalDatabases(model.relationalDatabases);
            nextPageToken(model.nextPageToken);
        }

        public final List<RelationalDatabase.Builder> getRelationalDatabases() {
            List<RelationalDatabase.Builder> result = RelationalDatabaseListCopier.copyToBuilder(this.relationalDatabases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelationalDatabases(Collection<RelationalDatabase.BuilderImpl> relationalDatabases) {
            this.relationalDatabases = RelationalDatabaseListCopier.copyFromBuilder(relationalDatabases);
        }

        @Override
        public final Builder relationalDatabases(Collection<RelationalDatabase> relationalDatabases) {
            this.relationalDatabases = RelationalDatabaseListCopier.copy(relationalDatabases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalDatabases(RelationalDatabase... relationalDatabases) {
            relationalDatabases(Arrays.asList(relationalDatabases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalDatabases(Consumer<RelationalDatabase.Builder>... relationalDatabases) {
            relationalDatabases(Stream.of(relationalDatabases).map(c -> RelationalDatabase.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetRelationalDatabasesResponse build() {
            return new GetRelationalDatabasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
