/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSetupHistoryResponse extends LightsailResponse implements
        ToCopyableBuilder<GetSetupHistoryResponse.Builder, GetSetupHistoryResponse> {
    private static final SdkField<List<SetupHistory>> SETUP_HISTORY_FIELD = SdkField
            .<List<SetupHistory>> builder(MarshallingType.LIST)
            .memberName("setupHistory")
            .getter(getter(GetSetupHistoryResponse::setupHistory))
            .setter(setter(Builder::setupHistory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("setupHistory").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SetupHistory> builder(MarshallingType.SDK_POJO)
                                            .constructor(SetupHistory::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextPageToken").getter(getter(GetSetupHistoryResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SETUP_HISTORY_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SetupHistory> setupHistory;

    private final String nextPageToken;

    private GetSetupHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.setupHistory = builder.setupHistory;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SetupHistory property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSetupHistory() {
        return setupHistory != null && !(setupHistory instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The historical information that's returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSetupHistory} method.
     * </p>
     * 
     * @return The historical information that's returned.
     */
    public final List<SetupHistory> setupHistory() {
        return setupHistory;
    }

    /**
     * <p>
     * The token to advance to the next page of results from your request.
     * </p>
     * <p>
     * A next page token is not returned if there are no more results to display.
     * </p>
     * <p>
     * To get the next page of results, perform another <code>GetSetupHistory</code> request and specify the next page
     * token using the pageToken parameter.
     * </p>
     * 
     * @return The token to advance to the next page of results from your request.</p>
     *         <p>
     *         A next page token is not returned if there are no more results to display.
     *         </p>
     *         <p>
     *         To get the next page of results, perform another <code>GetSetupHistory</code> request and specify the
     *         next page token using the pageToken parameter.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSetupHistory() ? setupHistory() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSetupHistoryResponse)) {
            return false;
        }
        GetSetupHistoryResponse other = (GetSetupHistoryResponse) obj;
        return hasSetupHistory() == other.hasSetupHistory() && Objects.equals(setupHistory(), other.setupHistory())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSetupHistoryResponse").add("SetupHistory", hasSetupHistory() ? setupHistory() : null)
                .add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "setupHistory":
            return Optional.ofNullable(clazz.cast(setupHistory()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("setupHistory", SETUP_HISTORY_FIELD);
        map.put("nextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSetupHistoryResponse, T> g) {
        return obj -> g.apply((GetSetupHistoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSetupHistoryResponse> {
        /**
         * <p>
         * The historical information that's returned.
         * </p>
         * 
         * @param setupHistory
         *        The historical information that's returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setupHistory(Collection<SetupHistory> setupHistory);

        /**
         * <p>
         * The historical information that's returned.
         * </p>
         * 
         * @param setupHistory
         *        The historical information that's returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setupHistory(SetupHistory... setupHistory);

        /**
         * <p>
         * The historical information that's returned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lightsail.model.SetupHistory.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lightsail.model.SetupHistory#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lightsail.model.SetupHistory.Builder#build()} is called immediately
         * and its result is passed to {@link #setupHistory(List<SetupHistory>)}.
         * 
         * @param setupHistory
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lightsail.model.SetupHistory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #setupHistory(java.util.Collection<SetupHistory>)
         */
        Builder setupHistory(Consumer<SetupHistory.Builder>... setupHistory);

        /**
         * <p>
         * The token to advance to the next page of results from your request.
         * </p>
         * <p>
         * A next page token is not returned if there are no more results to display.
         * </p>
         * <p>
         * To get the next page of results, perform another <code>GetSetupHistory</code> request and specify the next
         * page token using the pageToken parameter.
         * </p>
         * 
         * @param nextPageToken
         *        The token to advance to the next page of results from your request.</p>
         *        <p>
         *        A next page token is not returned if there are no more results to display.
         *        </p>
         *        <p>
         *        To get the next page of results, perform another <code>GetSetupHistory</code> request and specify the
         *        next page token using the pageToken parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<SetupHistory> setupHistory = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSetupHistoryResponse model) {
            super(model);
            setupHistory(model.setupHistory);
            nextPageToken(model.nextPageToken);
        }

        public final List<SetupHistory.Builder> getSetupHistory() {
            List<SetupHistory.Builder> result = _setupHistoryListCopier.copyToBuilder(this.setupHistory);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSetupHistory(Collection<SetupHistory.BuilderImpl> setupHistory) {
            this.setupHistory = _setupHistoryListCopier.copyFromBuilder(setupHistory);
        }

        @Override
        @Transient
        public final Builder setupHistory(Collection<SetupHistory> setupHistory) {
            this.setupHistory = _setupHistoryListCopier.copy(setupHistory);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder setupHistory(SetupHistory... setupHistory) {
            setupHistory(Arrays.asList(setupHistory));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder setupHistory(Consumer<SetupHistory.Builder>... setupHistory) {
            setupHistory(Stream.of(setupHistory).map(c -> SetupHistory.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetSetupHistoryResponse build() {
            return new GetSetupHistoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
