/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that describes the state of the canonical name (CNAME) records that are automatically added by Lightsail to
 * the DNS of the domain to validate domain ownership.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoadBalancerTlsCertificateDnsRecordCreationState
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<LoadBalancerTlsCertificateDnsRecordCreationState.Builder, LoadBalancerTlsCertificateDnsRecordCreationState> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(LoadBalancerTlsCertificateDnsRecordCreationState::codeAsString)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(LoadBalancerTlsCertificateDnsRecordCreationState::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String message;

    private LoadBalancerTlsCertificateDnsRecordCreationState(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * The status code for the automated DNS record creation.
     * </p>
     * <p>
     * Following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUCCEEDED</code> - The validation records were successfully added.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STARTED</code> - The automatic DNS record creation has started.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The validation record addition failed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link LoadBalancerTlsCertificateDnsRecordCreationStateCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #codeAsString}.
     * </p>
     * 
     * @return The status code for the automated DNS record creation.</p>
     *         <p>
     *         Following are the possible values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code> - The validation records were successfully added.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STARTED</code> - The automatic DNS record creation has started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The validation record addition failed.
     *         </p>
     *         </li>
     * @see LoadBalancerTlsCertificateDnsRecordCreationStateCode
     */
    public final LoadBalancerTlsCertificateDnsRecordCreationStateCode code() {
        return LoadBalancerTlsCertificateDnsRecordCreationStateCode.fromValue(code);
    }

    /**
     * <p>
     * The status code for the automated DNS record creation.
     * </p>
     * <p>
     * Following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUCCEEDED</code> - The validation records were successfully added.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STARTED</code> - The automatic DNS record creation has started.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The validation record addition failed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link LoadBalancerTlsCertificateDnsRecordCreationStateCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #codeAsString}.
     * </p>
     * 
     * @return The status code for the automated DNS record creation.</p>
     *         <p>
     *         Following are the possible values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code> - The validation records were successfully added.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STARTED</code> - The automatic DNS record creation has started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The validation record addition failed.
     *         </p>
     *         </li>
     * @see LoadBalancerTlsCertificateDnsRecordCreationStateCode
     */
    public final String codeAsString() {
        return code;
    }

    /**
     * <p>
     * The message that describes the reason for the status code.
     * </p>
     * 
     * @return The message that describes the reason for the status code.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerTlsCertificateDnsRecordCreationState)) {
            return false;
        }
        LoadBalancerTlsCertificateDnsRecordCreationState other = (LoadBalancerTlsCertificateDnsRecordCreationState) obj;
        return Objects.equals(codeAsString(), other.codeAsString()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoadBalancerTlsCertificateDnsRecordCreationState").add("Code", codeAsString())
                .add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("code", CODE_FIELD);
        map.put("message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancerTlsCertificateDnsRecordCreationState, T> g) {
        return obj -> g.apply((LoadBalancerTlsCertificateDnsRecordCreationState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoadBalancerTlsCertificateDnsRecordCreationState> {
        /**
         * <p>
         * The status code for the automated DNS record creation.
         * </p>
         * <p>
         * Following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUCCEEDED</code> - The validation records were successfully added.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STARTED</code> - The automatic DNS record creation has started.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The validation record addition failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        The status code for the automated DNS record creation.</p>
         *        <p>
         *        Following are the possible values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code> - The validation records were successfully added.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STARTED</code> - The automatic DNS record creation has started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The validation record addition failed.
         *        </p>
         *        </li>
         * @see LoadBalancerTlsCertificateDnsRecordCreationStateCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerTlsCertificateDnsRecordCreationStateCode
         */
        Builder code(String code);

        /**
         * <p>
         * The status code for the automated DNS record creation.
         * </p>
         * <p>
         * Following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUCCEEDED</code> - The validation records were successfully added.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STARTED</code> - The automatic DNS record creation has started.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The validation record addition failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        The status code for the automated DNS record creation.</p>
         *        <p>
         *        Following are the possible values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code> - The validation records were successfully added.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STARTED</code> - The automatic DNS record creation has started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The validation record addition failed.
         *        </p>
         *        </li>
         * @see LoadBalancerTlsCertificateDnsRecordCreationStateCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerTlsCertificateDnsRecordCreationStateCode
         */
        Builder code(LoadBalancerTlsCertificateDnsRecordCreationStateCode code);

        /**
         * <p>
         * The message that describes the reason for the status code.
         * </p>
         * 
         * @param message
         *        The message that describes the reason for the status code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerTlsCertificateDnsRecordCreationState model) {
            code(model.code);
            message(model.message);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(LoadBalancerTlsCertificateDnsRecordCreationStateCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public LoadBalancerTlsCertificateDnsRecordCreationState build() {
            return new LoadBalancerTlsCertificateDnsRecordCreationState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
