/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Amazon Web Services Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Region implements SdkPojo, Serializable, ToCopyableBuilder<Region.Builder, Region> {
    private static final SdkField<String> CONTINENT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("continentCode").getter(getter(Region::continentCode)).setter(setter(Builder::continentCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continentCode").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Region::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(Region::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Region::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<AvailabilityZone>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<AvailabilityZone>> builder(MarshallingType.LIST)
            .memberName("availabilityZones")
            .getter(getter(Region::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AvailabilityZone> builder(MarshallingType.SDK_POJO)
                                            .constructor(AvailabilityZone::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AvailabilityZone>> RELATIONAL_DATABASE_AVAILABILITY_ZONES_FIELD = SdkField
            .<List<AvailabilityZone>> builder(MarshallingType.LIST)
            .memberName("relationalDatabaseAvailabilityZones")
            .getter(getter(Region::relationalDatabaseAvailabilityZones))
            .setter(setter(Builder::relationalDatabaseAvailabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("relationalDatabaseAvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AvailabilityZone> builder(MarshallingType.SDK_POJO)
                                            .constructor(AvailabilityZone::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTINENT_CODE_FIELD,
            DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, NAME_FIELD, AVAILABILITY_ZONES_FIELD,
            RELATIONAL_DATABASE_AVAILABILITY_ZONES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String continentCode;

    private final String description;

    private final String displayName;

    private final String name;

    private final List<AvailabilityZone> availabilityZones;

    private final List<AvailabilityZone> relationalDatabaseAvailabilityZones;

    private Region(BuilderImpl builder) {
        this.continentCode = builder.continentCode;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.name = builder.name;
        this.availabilityZones = builder.availabilityZones;
        this.relationalDatabaseAvailabilityZones = builder.relationalDatabaseAvailabilityZones;
    }

    /**
     * <p>
     * The continent code (<code>NA</code>, meaning North America).
     * </p>
     * 
     * @return The continent code (<code>NA</code>, meaning North America).
     */
    public final String continentCode() {
        return continentCode;
    }

    /**
     * <p>
     * The description of the Amazon Web Services Region (
     * <code>This region is recommended to serve users in the eastern United States and eastern Canada</code>).
     * </p>
     * 
     * @return The description of the Amazon Web Services Region (
     *         <code>This region is recommended to serve users in the eastern United States and eastern Canada</code>).
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The display name (<code>Ohio</code>).
     * </p>
     * 
     * @return The display name (<code>Ohio</code>).
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The region name (<code>us-east-2</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link RegionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The region name (<code>us-east-2</code>).
     * @see RegionName
     */
    public final RegionName name() {
        return RegionName.fromValue(name);
    }

    /**
     * <p>
     * The region name (<code>us-east-2</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link RegionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The region name (<code>us-east-2</code>).
     * @see RegionName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Availability Zones. Follows the format <code>us-east-2a</code> (case-sensitive).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return The Availability Zones. Follows the format <code>us-east-2a</code> (case-sensitive).
     */
    public final List<AvailabilityZone> availabilityZones() {
        return availabilityZones;
    }

    /**
     * For responses, this returns true if the service returned a value for the RelationalDatabaseAvailabilityZones
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasRelationalDatabaseAvailabilityZones() {
        return relationalDatabaseAvailabilityZones != null
                && !(relationalDatabaseAvailabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Availability Zones for databases. Follows the format <code>us-east-2a</code> (case-sensitive).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRelationalDatabaseAvailabilityZones}
     * method.
     * </p>
     * 
     * @return The Availability Zones for databases. Follows the format <code>us-east-2a</code> (case-sensitive).
     */
    public final List<AvailabilityZone> relationalDatabaseAvailabilityZones() {
        return relationalDatabaseAvailabilityZones;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(continentCode());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasRelationalDatabaseAvailabilityZones() ? relationalDatabaseAvailabilityZones() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Region)) {
            return false;
        }
        Region other = (Region) obj;
        return Objects.equals(continentCode(), other.continentCode()) && Objects.equals(description(), other.description())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(nameAsString(), other.nameAsString())
                && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && hasRelationalDatabaseAvailabilityZones() == other.hasRelationalDatabaseAvailabilityZones()
                && Objects.equals(relationalDatabaseAvailabilityZones(), other.relationalDatabaseAvailabilityZones());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("Region")
                .add("ContinentCode", continentCode())
                .add("Description", description())
                .add("DisplayName", displayName())
                .add("Name", nameAsString())
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("RelationalDatabaseAvailabilityZones",
                        hasRelationalDatabaseAvailabilityZones() ? relationalDatabaseAvailabilityZones() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "continentCode":
            return Optional.ofNullable(clazz.cast(continentCode()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "availabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "relationalDatabaseAvailabilityZones":
            return Optional.ofNullable(clazz.cast(relationalDatabaseAvailabilityZones()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("continentCode", CONTINENT_CODE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("availabilityZones", AVAILABILITY_ZONES_FIELD);
        map.put("relationalDatabaseAvailabilityZones", RELATIONAL_DATABASE_AVAILABILITY_ZONES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Region, T> g) {
        return obj -> g.apply((Region) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Region> {
        /**
         * <p>
         * The continent code (<code>NA</code>, meaning North America).
         * </p>
         * 
         * @param continentCode
         *        The continent code (<code>NA</code>, meaning North America).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continentCode(String continentCode);

        /**
         * <p>
         * The description of the Amazon Web Services Region (
         * <code>This region is recommended to serve users in the eastern United States and eastern Canada</code>).
         * </p>
         * 
         * @param description
         *        The description of the Amazon Web Services Region (
         *        <code>This region is recommended to serve users in the eastern United States and eastern Canada</code>
         *        ).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The display name (<code>Ohio</code>).
         * </p>
         * 
         * @param displayName
         *        The display name (<code>Ohio</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The region name (<code>us-east-2</code>).
         * </p>
         * 
         * @param name
         *        The region name (<code>us-east-2</code>).
         * @see RegionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionName
         */
        Builder name(String name);

        /**
         * <p>
         * The region name (<code>us-east-2</code>).
         * </p>
         * 
         * @param name
         *        The region name (<code>us-east-2</code>).
         * @see RegionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionName
         */
        Builder name(RegionName name);

        /**
         * <p>
         * The Availability Zones. Follows the format <code>us-east-2a</code> (case-sensitive).
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones. Follows the format <code>us-east-2a</code> (case-sensitive).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<AvailabilityZone> availabilityZones);

        /**
         * <p>
         * The Availability Zones. Follows the format <code>us-east-2a</code> (case-sensitive).
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones. Follows the format <code>us-east-2a</code> (case-sensitive).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(AvailabilityZone... availabilityZones);

        /**
         * <p>
         * The Availability Zones. Follows the format <code>us-east-2a</code> (case-sensitive).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lightsail.model.AvailabilityZone.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lightsail.model.AvailabilityZone#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lightsail.model.AvailabilityZone.Builder#build()} is called
         * immediately and its result is passed to {@link #availabilityZones(List<AvailabilityZone>)}.
         * 
         * @param availabilityZones
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lightsail.model.AvailabilityZone.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availabilityZones(java.util.Collection<AvailabilityZone>)
         */
        Builder availabilityZones(Consumer<AvailabilityZone.Builder>... availabilityZones);

        /**
         * <p>
         * The Availability Zones for databases. Follows the format <code>us-east-2a</code> (case-sensitive).
         * </p>
         * 
         * @param relationalDatabaseAvailabilityZones
         *        The Availability Zones for databases. Follows the format <code>us-east-2a</code> (case-sensitive).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseAvailabilityZones(Collection<AvailabilityZone> relationalDatabaseAvailabilityZones);

        /**
         * <p>
         * The Availability Zones for databases. Follows the format <code>us-east-2a</code> (case-sensitive).
         * </p>
         * 
         * @param relationalDatabaseAvailabilityZones
         *        The Availability Zones for databases. Follows the format <code>us-east-2a</code> (case-sensitive).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseAvailabilityZones(AvailabilityZone... relationalDatabaseAvailabilityZones);

        /**
         * <p>
         * The Availability Zones for databases. Follows the format <code>us-east-2a</code> (case-sensitive).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lightsail.model.AvailabilityZone.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lightsail.model.AvailabilityZone#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lightsail.model.AvailabilityZone.Builder#build()} is called
         * immediately and its result is passed to {@link #relationalDatabaseAvailabilityZones(List<AvailabilityZone>)}.
         * 
         * @param relationalDatabaseAvailabilityZones
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lightsail.model.AvailabilityZone.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relationalDatabaseAvailabilityZones(java.util.Collection<AvailabilityZone>)
         */
        Builder relationalDatabaseAvailabilityZones(Consumer<AvailabilityZone.Builder>... relationalDatabaseAvailabilityZones);
    }

    static final class BuilderImpl implements Builder {
        private String continentCode;

        private String description;

        private String displayName;

        private String name;

        private List<AvailabilityZone> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private List<AvailabilityZone> relationalDatabaseAvailabilityZones = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Region model) {
            continentCode(model.continentCode);
            description(model.description);
            displayName(model.displayName);
            name(model.name);
            availabilityZones(model.availabilityZones);
            relationalDatabaseAvailabilityZones(model.relationalDatabaseAvailabilityZones);
        }

        public final String getContinentCode() {
            return continentCode;
        }

        public final void setContinentCode(String continentCode) {
            this.continentCode = continentCode;
        }

        @Override
        public final Builder continentCode(String continentCode) {
            this.continentCode = continentCode;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(RegionName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final List<AvailabilityZone.Builder> getAvailabilityZones() {
            List<AvailabilityZone.Builder> result = AvailabilityZoneListCopier.copyToBuilder(this.availabilityZones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailabilityZones(Collection<AvailabilityZone.BuilderImpl> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copyFromBuilder(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(AvailabilityZone... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(Consumer<AvailabilityZone.Builder>... availabilityZones) {
            availabilityZones(Stream.of(availabilityZones).map(c -> AvailabilityZone.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AvailabilityZone.Builder> getRelationalDatabaseAvailabilityZones() {
            List<AvailabilityZone.Builder> result = AvailabilityZoneListCopier
                    .copyToBuilder(this.relationalDatabaseAvailabilityZones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelationalDatabaseAvailabilityZones(
                Collection<AvailabilityZone.BuilderImpl> relationalDatabaseAvailabilityZones) {
            this.relationalDatabaseAvailabilityZones = AvailabilityZoneListCopier
                    .copyFromBuilder(relationalDatabaseAvailabilityZones);
        }

        @Override
        public final Builder relationalDatabaseAvailabilityZones(Collection<AvailabilityZone> relationalDatabaseAvailabilityZones) {
            this.relationalDatabaseAvailabilityZones = AvailabilityZoneListCopier.copy(relationalDatabaseAvailabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalDatabaseAvailabilityZones(AvailabilityZone... relationalDatabaseAvailabilityZones) {
            relationalDatabaseAvailabilityZones(Arrays.asList(relationalDatabaseAvailabilityZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalDatabaseAvailabilityZones(
                Consumer<AvailabilityZone.Builder>... relationalDatabaseAvailabilityZones) {
            relationalDatabaseAvailabilityZones(Stream.of(relationalDatabaseAvailabilityZones)
                    .map(c -> AvailabilityZone.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Region build() {
            return new Region(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
