/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the estimated cost or usage that a budget tracks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceBudgetEstimate implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceBudgetEstimate.Builder, ResourceBudgetEstimate> {
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceName").getter(getter(ResourceBudgetEstimate::resourceName))
            .setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(ResourceBudgetEstimate::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<List<CostEstimate>> COST_ESTIMATES_FIELD = SdkField
            .<List<CostEstimate>> builder(MarshallingType.LIST)
            .memberName("costEstimates")
            .getter(getter(ResourceBudgetEstimate::costEstimates))
            .setter(setter(Builder::costEstimates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costEstimates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CostEstimate> builder(MarshallingType.SDK_POJO)
                                            .constructor(CostEstimate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(ResourceBudgetEstimate::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(ResourceBudgetEstimate::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_NAME_FIELD,
            RESOURCE_TYPE_FIELD, COST_ESTIMATES_FIELD, START_TIME_FIELD, END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceName;

    private final String resourceType;

    private final List<CostEstimate> costEstimates;

    private final Instant startTime;

    private final Instant endTime;

    private ResourceBudgetEstimate(BuilderImpl builder) {
        this.resourceName = builder.resourceName;
        this.resourceType = builder.resourceType;
        this.costEstimates = builder.costEstimates;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The resource name.
     * </p>
     * 
     * @return The resource name.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The type of resource the budget will track.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource the budget will track.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource the budget will track.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource the budget will track.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the CostEstimates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCostEstimates() {
        return costEstimates != null && !(costEstimates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The cost estimate for the specified budget.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCostEstimates} method.
     * </p>
     * 
     * @return The cost estimate for the specified budget.
     */
    public final List<CostEstimate> costEstimates() {
        return costEstimates;
    }

    /**
     * <p>
     * The estimate start time.
     * </p>
     * 
     * @return The estimate start time.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The estimate end time.
     * </p>
     * 
     * @return The estimate end time.
     */
    public final Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasCostEstimates() ? costEstimates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceBudgetEstimate)) {
            return false;
        }
        ResourceBudgetEstimate other = (ResourceBudgetEstimate) obj;
        return Objects.equals(resourceName(), other.resourceName())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && hasCostEstimates() == other.hasCostEstimates() && Objects.equals(costEstimates(), other.costEstimates())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceBudgetEstimate").add("ResourceName", resourceName())
                .add("ResourceType", resourceTypeAsString()).add("CostEstimates", hasCostEstimates() ? costEstimates() : null)
                .add("StartTime", startTime()).add("EndTime", endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "costEstimates":
            return Optional.ofNullable(clazz.cast(costEstimates()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceName", RESOURCE_NAME_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("costEstimates", COST_ESTIMATES_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceBudgetEstimate, T> g) {
        return obj -> g.apply((ResourceBudgetEstimate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceBudgetEstimate> {
        /**
         * <p>
         * The resource name.
         * </p>
         * 
         * @param resourceName
         *        The resource name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The type of resource the budget will track.
         * </p>
         * 
         * @param resourceType
         *        The type of resource the budget will track.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource the budget will track.
         * </p>
         * 
         * @param resourceType
         *        The type of resource the budget will track.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The cost estimate for the specified budget.
         * </p>
         * 
         * @param costEstimates
         *        The cost estimate for the specified budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costEstimates(Collection<CostEstimate> costEstimates);

        /**
         * <p>
         * The cost estimate for the specified budget.
         * </p>
         * 
         * @param costEstimates
         *        The cost estimate for the specified budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costEstimates(CostEstimate... costEstimates);

        /**
         * <p>
         * The cost estimate for the specified budget.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lightsail.model.CostEstimate.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lightsail.model.CostEstimate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lightsail.model.CostEstimate.Builder#build()} is called immediately
         * and its result is passed to {@link #costEstimates(List<CostEstimate>)}.
         * 
         * @param costEstimates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lightsail.model.CostEstimate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #costEstimates(java.util.Collection<CostEstimate>)
         */
        Builder costEstimates(Consumer<CostEstimate.Builder>... costEstimates);

        /**
         * <p>
         * The estimate start time.
         * </p>
         * 
         * @param startTime
         *        The estimate start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The estimate end time.
         * </p>
         * 
         * @param endTime
         *        The estimate end time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    static final class BuilderImpl implements Builder {
        private String resourceName;

        private String resourceType;

        private List<CostEstimate> costEstimates = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceBudgetEstimate model) {
            resourceName(model.resourceName);
            resourceType(model.resourceType);
            costEstimates(model.costEstimates);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<CostEstimate.Builder> getCostEstimates() {
            List<CostEstimate.Builder> result = CostEstimatesCopier.copyToBuilder(this.costEstimates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCostEstimates(Collection<CostEstimate.BuilderImpl> costEstimates) {
            this.costEstimates = CostEstimatesCopier.copyFromBuilder(costEstimates);
        }

        @Override
        public final Builder costEstimates(Collection<CostEstimate> costEstimates) {
            this.costEstimates = CostEstimatesCopier.copy(costEstimates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costEstimates(CostEstimate... costEstimates) {
            costEstimates(Arrays.asList(costEstimates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costEstimates(Consumer<CostEstimate.Builder>... costEstimates) {
            costEstimates(Stream.of(costEstimates).map(c -> CostEstimate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public ResourceBudgetEstimate build() {
            return new ResourceBudgetEstimate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
