/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a web-based, remote graphical user interface (GUI), NICE DCV session. The session is used to access a
 * virtual computer’s operating system or application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Session implements SdkPojo, Serializable, ToCopyableBuilder<Session.Builder, Session> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Session::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("url")
            .getter(getter(Session::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final SdkField<Boolean> IS_PRIMARY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isPrimary").getter(getter(Session::isPrimary)).setter(setter(Builder::isPrimary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPrimary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, URL_FIELD,
            IS_PRIMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String url;

    private final Boolean isPrimary;

    private Session(BuilderImpl builder) {
        this.name = builder.name;
        this.url = builder.url;
        this.isPrimary = builder.isPrimary;
    }

    /**
     * <p>
     * The session name.
     * </p>
     * 
     * @return The session name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The session URL.
     * </p>
     * 
     * @return The session URL.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * When true, this Boolean value indicates the primary session for the specified resource.
     * </p>
     * 
     * @return When true, this Boolean value indicates the primary session for the specified resource.
     */
    public final Boolean isPrimary() {
        return isPrimary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(isPrimary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Session)) {
            return false;
        }
        Session other = (Session) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(url(), other.url())
                && Objects.equals(isPrimary(), other.isPrimary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Session").add("Name", name())
                .add("Url", url() == null ? null : "*** Sensitive Data Redacted ***").add("IsPrimary", isPrimary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        case "isPrimary":
            return Optional.ofNullable(clazz.cast(isPrimary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("url", URL_FIELD);
        map.put("isPrimary", IS_PRIMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Session, T> g) {
        return obj -> g.apply((Session) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Session> {
        /**
         * <p>
         * The session name.
         * </p>
         * 
         * @param name
         *        The session name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The session URL.
         * </p>
         * 
         * @param url
         *        The session URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * When true, this Boolean value indicates the primary session for the specified resource.
         * </p>
         * 
         * @param isPrimary
         *        When true, this Boolean value indicates the primary session for the specified resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPrimary(Boolean isPrimary);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String url;

        private Boolean isPrimary;

        private BuilderImpl() {
        }

        private BuilderImpl(Session model) {
            name(model.name);
            url(model.url);
            isPrimary(model.isPrimary);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final Boolean getIsPrimary() {
            return isPrimary;
        }

        public final void setIsPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
        }

        @Override
        public final Builder isPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
            return this;
        }

        @Override
        public Session build() {
            return new Session(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
