/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns details about the commands that were run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetupExecutionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<SetupExecutionDetails.Builder, SetupExecutionDetails> {
    private static final SdkField<String> COMMAND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("command")
            .getter(getter(SetupExecutionDetails::command)).setter(setter(Builder::command))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build()).build();

    private static final SdkField<Instant> DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("dateTime").getter(getter(SetupExecutionDetails::dateTime)).setter(setter(Builder::dateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateTime").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SetupExecutionDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SetupExecutionDetails::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STANDARD_ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("standardError").getter(getter(SetupExecutionDetails::standardError))
            .setter(setter(Builder::standardError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standardError").build()).build();

    private static final SdkField<String> STANDARD_OUTPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("standardOutput").getter(getter(SetupExecutionDetails::standardOutput))
            .setter(setter(Builder::standardOutput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standardOutput").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(SetupExecutionDetails::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_FIELD,
            DATE_TIME_FIELD, NAME_FIELD, STATUS_FIELD, STANDARD_ERROR_FIELD, STANDARD_OUTPUT_FIELD, VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String command;

    private final Instant dateTime;

    private final String name;

    private final String status;

    private final String standardError;

    private final String standardOutput;

    private final String version;

    private SetupExecutionDetails(BuilderImpl builder) {
        this.command = builder.command;
        this.dateTime = builder.dateTime;
        this.name = builder.name;
        this.status = builder.status;
        this.standardError = builder.standardError;
        this.standardOutput = builder.standardOutput;
        this.version = builder.version;
    }

    /**
     * <p>
     * The command that was executed.
     * </p>
     * 
     * @return The command that was executed.
     */
    public final String command() {
        return command;
    }

    /**
     * <p>
     * The timestamp for when the request was run.
     * </p>
     * 
     * @return The timestamp for when the request was run.
     */
    public final Instant dateTime() {
        return dateTime;
    }

    /**
     * <p>
     * The name of the target resource.
     * </p>
     * 
     * @return The name of the target resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the <code>SetupInstanceHttps</code> request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SetupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the <code>SetupInstanceHttps</code> request.
     * @see SetupStatus
     */
    public final SetupStatus status() {
        return SetupStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the <code>SetupInstanceHttps</code> request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SetupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the <code>SetupInstanceHttps</code> request.
     * @see SetupStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The text written by the command to stderr.
     * </p>
     * 
     * @return The text written by the command to stderr.
     */
    public final String standardError() {
        return standardError;
    }

    /**
     * <p>
     * The text written by the command to stdout.
     * </p>
     * 
     * @return The text written by the command to stdout.
     */
    public final String standardOutput() {
        return standardOutput;
    }

    /**
     * <p>
     * The current version of the script..
     * </p>
     * 
     * @return The current version of the script..
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(command());
        hashCode = 31 * hashCode + Objects.hashCode(dateTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(standardError());
        hashCode = 31 * hashCode + Objects.hashCode(standardOutput());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetupExecutionDetails)) {
            return false;
        }
        SetupExecutionDetails other = (SetupExecutionDetails) obj;
        return Objects.equals(command(), other.command()) && Objects.equals(dateTime(), other.dateTime())
                && Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(standardError(), other.standardError())
                && Objects.equals(standardOutput(), other.standardOutput()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetupExecutionDetails").add("Command", command()).add("DateTime", dateTime())
                .add("Name", name()).add("Status", statusAsString()).add("StandardError", standardError())
                .add("StandardOutput", standardOutput()).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "command":
            return Optional.ofNullable(clazz.cast(command()));
        case "dateTime":
            return Optional.ofNullable(clazz.cast(dateTime()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "standardError":
            return Optional.ofNullable(clazz.cast(standardError()));
        case "standardOutput":
            return Optional.ofNullable(clazz.cast(standardOutput()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("command", COMMAND_FIELD);
        map.put("dateTime", DATE_TIME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("standardError", STANDARD_ERROR_FIELD);
        map.put("standardOutput", STANDARD_OUTPUT_FIELD);
        map.put("version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetupExecutionDetails, T> g) {
        return obj -> g.apply((SetupExecutionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SetupExecutionDetails> {
        /**
         * <p>
         * The command that was executed.
         * </p>
         * 
         * @param command
         *        The command that was executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(String command);

        /**
         * <p>
         * The timestamp for when the request was run.
         * </p>
         * 
         * @param dateTime
         *        The timestamp for when the request was run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateTime(Instant dateTime);

        /**
         * <p>
         * The name of the target resource.
         * </p>
         * 
         * @param name
         *        The name of the target resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the <code>SetupInstanceHttps</code> request.
         * </p>
         * 
         * @param status
         *        The status of the <code>SetupInstanceHttps</code> request.
         * @see SetupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SetupStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the <code>SetupInstanceHttps</code> request.
         * </p>
         * 
         * @param status
         *        The status of the <code>SetupInstanceHttps</code> request.
         * @see SetupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SetupStatus
         */
        Builder status(SetupStatus status);

        /**
         * <p>
         * The text written by the command to stderr.
         * </p>
         * 
         * @param standardError
         *        The text written by the command to stderr.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardError(String standardError);

        /**
         * <p>
         * The text written by the command to stdout.
         * </p>
         * 
         * @param standardOutput
         *        The text written by the command to stdout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardOutput(String standardOutput);

        /**
         * <p>
         * The current version of the script..
         * </p>
         * 
         * @param version
         *        The current version of the script..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String command;

        private Instant dateTime;

        private String name;

        private String status;

        private String standardError;

        private String standardOutput;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(SetupExecutionDetails model) {
            command(model.command);
            dateTime(model.dateTime);
            name(model.name);
            status(model.status);
            standardError(model.standardError);
            standardOutput(model.standardOutput);
            version(model.version);
        }

        public final String getCommand() {
            return command;
        }

        public final void setCommand(String command) {
            this.command = command;
        }

        @Override
        public final Builder command(String command) {
            this.command = command;
            return this;
        }

        public final Instant getDateTime() {
            return dateTime;
        }

        public final void setDateTime(Instant dateTime) {
            this.dateTime = dateTime;
        }

        @Override
        public final Builder dateTime(Instant dateTime) {
            this.dateTime = dateTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SetupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStandardError() {
            return standardError;
        }

        public final void setStandardError(String standardError) {
            this.standardError = standardError;
        }

        @Override
        public final Builder standardError(String standardError) {
            this.standardError = standardError;
            return this;
        }

        public final String getStandardOutput() {
            return standardOutput;
        }

        public final void setStandardOutput(String standardOutput) {
            this.standardOutput = standardOutput;
        }

        @Override
        public final Builder standardOutput(String standardOutput) {
            this.standardOutput = standardOutput;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public SetupExecutionDetails build() {
            return new SetupExecutionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
