/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns a list of the commands that were ran on the target resource.
 * </p>
 * <p>
 * The status of each command is also returned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetupHistory implements SdkPojo, Serializable, ToCopyableBuilder<SetupHistory.Builder, SetupHistory> {
    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operationId").getter(getter(SetupHistory::operationId)).setter(setter(Builder::operationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationId").build()).build();

    private static final SdkField<SetupRequest> REQUEST_FIELD = SdkField.<SetupRequest> builder(MarshallingType.SDK_POJO)
            .memberName("request").getter(getter(SetupHistory::request)).setter(setter(Builder::request))
            .constructor(SetupRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("request").build()).build();

    private static final SdkField<SetupHistoryResource> RESOURCE_FIELD = SdkField
            .<SetupHistoryResource> builder(MarshallingType.SDK_POJO).memberName("resource")
            .getter(getter(SetupHistory::resource)).setter(setter(Builder::resource)).constructor(SetupHistoryResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<List<SetupExecutionDetails>> EXECUTION_DETAILS_FIELD = SdkField
            .<List<SetupExecutionDetails>> builder(MarshallingType.LIST)
            .memberName("executionDetails")
            .getter(getter(SetupHistory::executionDetails))
            .setter(setter(Builder::executionDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SetupExecutionDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(SetupExecutionDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SetupHistory::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_ID_FIELD,
            REQUEST_FIELD, RESOURCE_FIELD, EXECUTION_DETAILS_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String operationId;

    private final SetupRequest request;

    private final SetupHistoryResource resource;

    private final List<SetupExecutionDetails> executionDetails;

    private final String status;

    private SetupHistory(BuilderImpl builder) {
        this.operationId = builder.operationId;
        this.request = builder.request;
        this.resource = builder.resource;
        this.executionDetails = builder.executionDetails;
        this.status = builder.status;
    }

    /**
     * <p>
     * A GUID that's used to identify the operation.
     * </p>
     * 
     * @return A GUID that's used to identify the operation.
     */
    public final String operationId() {
        return operationId;
    }

    /**
     * <p>
     * Information about the specified request.
     * </p>
     * 
     * @return Information about the specified request.
     */
    public final SetupRequest request() {
        return request;
    }

    /**
     * <p>
     * The target resource name for the request.
     * </p>
     * 
     * @return The target resource name for the request.
     */
    public final SetupHistoryResource resource() {
        return resource;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExecutionDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExecutionDetails() {
        return executionDetails != null && !(executionDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the full details of the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExecutionDetails} method.
     * </p>
     * 
     * @return Describes the full details of the request.
     */
    public final List<SetupExecutionDetails> executionDetails() {
        return executionDetails;
    }

    /**
     * <p>
     * The status of the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SetupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the request.
     * @see SetupStatus
     */
    public final SetupStatus status() {
        return SetupStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SetupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the request.
     * @see SetupStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operationId());
        hashCode = 31 * hashCode + Objects.hashCode(request());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(hasExecutionDetails() ? executionDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetupHistory)) {
            return false;
        }
        SetupHistory other = (SetupHistory) obj;
        return Objects.equals(operationId(), other.operationId()) && Objects.equals(request(), other.request())
                && Objects.equals(resource(), other.resource()) && hasExecutionDetails() == other.hasExecutionDetails()
                && Objects.equals(executionDetails(), other.executionDetails())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetupHistory").add("OperationId", operationId()).add("Request", request())
                .add("Resource", resource()).add("ExecutionDetails", hasExecutionDetails() ? executionDetails() : null)
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "operationId":
            return Optional.ofNullable(clazz.cast(operationId()));
        case "request":
            return Optional.ofNullable(clazz.cast(request()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "executionDetails":
            return Optional.ofNullable(clazz.cast(executionDetails()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("operationId", OPERATION_ID_FIELD);
        map.put("request", REQUEST_FIELD);
        map.put("resource", RESOURCE_FIELD);
        map.put("executionDetails", EXECUTION_DETAILS_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetupHistory, T> g) {
        return obj -> g.apply((SetupHistory) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SetupHistory> {
        /**
         * <p>
         * A GUID that's used to identify the operation.
         * </p>
         * 
         * @param operationId
         *        A GUID that's used to identify the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);

        /**
         * <p>
         * Information about the specified request.
         * </p>
         * 
         * @param request
         *        Information about the specified request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder request(SetupRequest request);

        /**
         * <p>
         * Information about the specified request.
         * </p>
         * This is a convenience method that creates an instance of the {@link SetupRequest.Builder} avoiding the need
         * to create one manually via {@link SetupRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SetupRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #request(SetupRequest)}.
         * 
         * @param request
         *        a consumer that will call methods on {@link SetupRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #request(SetupRequest)
         */
        default Builder request(Consumer<SetupRequest.Builder> request) {
            return request(SetupRequest.builder().applyMutation(request).build());
        }

        /**
         * <p>
         * The target resource name for the request.
         * </p>
         * 
         * @param resource
         *        The target resource name for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(SetupHistoryResource resource);

        /**
         * <p>
         * The target resource name for the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link SetupHistoryResource.Builder} avoiding
         * the need to create one manually via {@link SetupHistoryResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SetupHistoryResource.Builder#build()} is called immediately and
         * its result is passed to {@link #resource(SetupHistoryResource)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link SetupHistoryResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(SetupHistoryResource)
         */
        default Builder resource(Consumer<SetupHistoryResource.Builder> resource) {
            return resource(SetupHistoryResource.builder().applyMutation(resource).build());
        }

        /**
         * <p>
         * Describes the full details of the request.
         * </p>
         * 
         * @param executionDetails
         *        Describes the full details of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionDetails(Collection<SetupExecutionDetails> executionDetails);

        /**
         * <p>
         * Describes the full details of the request.
         * </p>
         * 
         * @param executionDetails
         *        Describes the full details of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionDetails(SetupExecutionDetails... executionDetails);

        /**
         * <p>
         * Describes the full details of the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lightsail.model.SetupExecutionDetails.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lightsail.model.SetupExecutionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lightsail.model.SetupExecutionDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #executionDetails(List<SetupExecutionDetails>)}.
         * 
         * @param executionDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lightsail.model.SetupExecutionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionDetails(java.util.Collection<SetupExecutionDetails>)
         */
        Builder executionDetails(Consumer<SetupExecutionDetails.Builder>... executionDetails);

        /**
         * <p>
         * The status of the request.
         * </p>
         * 
         * @param status
         *        The status of the request.
         * @see SetupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SetupStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the request.
         * </p>
         * 
         * @param status
         *        The status of the request.
         * @see SetupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SetupStatus
         */
        Builder status(SetupStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String operationId;

        private SetupRequest request;

        private SetupHistoryResource resource;

        private List<SetupExecutionDetails> executionDetails = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SetupHistory model) {
            operationId(model.operationId);
            request(model.request);
            resource(model.resource);
            executionDetails(model.executionDetails);
            status(model.status);
        }

        public final String getOperationId() {
            return operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final SetupRequest.Builder getRequest() {
            return request != null ? request.toBuilder() : null;
        }

        public final void setRequest(SetupRequest.BuilderImpl request) {
            this.request = request != null ? request.build() : null;
        }

        @Override
        public final Builder request(SetupRequest request) {
            this.request = request;
            return this;
        }

        public final SetupHistoryResource.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(SetupHistoryResource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(SetupHistoryResource resource) {
            this.resource = resource;
            return this;
        }

        public final List<SetupExecutionDetails.Builder> getExecutionDetails() {
            List<SetupExecutionDetails.Builder> result = SetupExecutionDetailsListCopier.copyToBuilder(this.executionDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExecutionDetails(Collection<SetupExecutionDetails.BuilderImpl> executionDetails) {
            this.executionDetails = SetupExecutionDetailsListCopier.copyFromBuilder(executionDetails);
        }

        @Override
        public final Builder executionDetails(Collection<SetupExecutionDetails> executionDetails) {
            this.executionDetails = SetupExecutionDetailsListCopier.copy(executionDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionDetails(SetupExecutionDetails... executionDetails) {
            executionDetails(Arrays.asList(executionDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionDetails(Consumer<SetupExecutionDetails.Builder>... executionDetails) {
            executionDetails(Stream.of(executionDetails).map(c -> SetupExecutionDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SetupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public SetupHistory build() {
            return new SetupHistory(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
