/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a request to create or edit the <code>StopInstanceOnIdle</code> add-on.
 * </p>
 * <important>
 * <p>
 * This add-on only applies to Lightsail for Research resources.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopInstanceOnIdleRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<StopInstanceOnIdleRequest.Builder, StopInstanceOnIdleRequest> {
    private static final SdkField<String> THRESHOLD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("threshold").getter(getter(StopInstanceOnIdleRequest::threshold)).setter(setter(Builder::threshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()).build();

    private static final SdkField<String> DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("duration").getter(getter(StopInstanceOnIdleRequest::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THRESHOLD_FIELD,
            DURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String threshold;

    private final String duration;

    private StopInstanceOnIdleRequest(BuilderImpl builder) {
        this.threshold = builder.threshold;
        this.duration = builder.duration;
    }

    /**
     * <p>
     * The value to compare with the duration.
     * </p>
     * 
     * @return The value to compare with the duration.
     */
    public final String threshold() {
        return threshold;
    }

    /**
     * <p>
     * The amount of idle time in minutes after which your virtual computer will automatically stop.
     * </p>
     * 
     * @return The amount of idle time in minutes after which your virtual computer will automatically stop.
     */
    public final String duration() {
        return duration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(threshold());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopInstanceOnIdleRequest)) {
            return false;
        }
        StopInstanceOnIdleRequest other = (StopInstanceOnIdleRequest) obj;
        return Objects.equals(threshold(), other.threshold()) && Objects.equals(duration(), other.duration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopInstanceOnIdleRequest").add("Threshold", threshold()).add("Duration", duration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "threshold":
            return Optional.ofNullable(clazz.cast(threshold()));
        case "duration":
            return Optional.ofNullable(clazz.cast(duration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("threshold", THRESHOLD_FIELD);
        map.put("duration", DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopInstanceOnIdleRequest, T> g) {
        return obj -> g.apply((StopInstanceOnIdleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StopInstanceOnIdleRequest> {
        /**
         * <p>
         * The value to compare with the duration.
         * </p>
         * 
         * @param threshold
         *        The value to compare with the duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(String threshold);

        /**
         * <p>
         * The amount of idle time in minutes after which your virtual computer will automatically stop.
         * </p>
         * 
         * @param duration
         *        The amount of idle time in minutes after which your virtual computer will automatically stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(String duration);
    }

    static final class BuilderImpl implements Builder {
        private String threshold;

        private String duration;

        private BuilderImpl() {
        }

        private BuilderImpl(StopInstanceOnIdleRequest model) {
            threshold(model.threshold);
            duration(model.duration);
        }

        public final String getThreshold() {
            return threshold;
        }

        public final void setThreshold(String threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(String threshold) {
            this.threshold = threshold;
            return this;
        }

        public final String getDuration() {
            return duration;
        }

        public final void setDuration(String duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(String duration) {
            this.duration = duration;
            return this;
        }

        @Override
        public StopInstanceOnIdleRequest build() {
            return new StopInstanceOnIdleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
