/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDistributionBundleRequest extends LightsailRequest implements
        ToCopyableBuilder<UpdateDistributionBundleRequest.Builder, UpdateDistributionBundleRequest> {
    private static final SdkField<String> DISTRIBUTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("distributionName").getter(getter(UpdateDistributionBundleRequest::distributionName))
            .setter(setter(Builder::distributionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionName").build()).build();

    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bundleId").getter(getter(UpdateDistributionBundleRequest::bundleId)).setter(setter(Builder::bundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_NAME_FIELD,
            BUNDLE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String distributionName;

    private final String bundleId;

    private UpdateDistributionBundleRequest(BuilderImpl builder) {
        super(builder);
        this.distributionName = builder.distributionName;
        this.bundleId = builder.bundleId;
    }

    /**
     * <p>
     * The name of the distribution for which to update the bundle.
     * </p>
     * <p>
     * Use the <code>GetDistributions</code> action to get a list of distribution names that you can specify.
     * </p>
     * 
     * @return The name of the distribution for which to update the bundle.</p>
     *         <p>
     *         Use the <code>GetDistributions</code> action to get a list of distribution names that you can specify.
     */
    public final String distributionName() {
        return distributionName;
    }

    /**
     * <p>
     * The bundle ID of the new bundle to apply to your distribution.
     * </p>
     * <p>
     * Use the <code>GetDistributionBundles</code> action to get a list of distribution bundle IDs that you can specify.
     * </p>
     * 
     * @return The bundle ID of the new bundle to apply to your distribution.</p>
     *         <p>
     *         Use the <code>GetDistributionBundles</code> action to get a list of distribution bundle IDs that you can
     *         specify.
     */
    public final String bundleId() {
        return bundleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(distributionName());
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDistributionBundleRequest)) {
            return false;
        }
        UpdateDistributionBundleRequest other = (UpdateDistributionBundleRequest) obj;
        return Objects.equals(distributionName(), other.distributionName()) && Objects.equals(bundleId(), other.bundleId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDistributionBundleRequest").add("DistributionName", distributionName())
                .add("BundleId", bundleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "distributionName":
            return Optional.ofNullable(clazz.cast(distributionName()));
        case "bundleId":
            return Optional.ofNullable(clazz.cast(bundleId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("distributionName", DISTRIBUTION_NAME_FIELD);
        map.put("bundleId", BUNDLE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDistributionBundleRequest, T> g) {
        return obj -> g.apply((UpdateDistributionBundleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDistributionBundleRequest> {
        /**
         * <p>
         * The name of the distribution for which to update the bundle.
         * </p>
         * <p>
         * Use the <code>GetDistributions</code> action to get a list of distribution names that you can specify.
         * </p>
         * 
         * @param distributionName
         *        The name of the distribution for which to update the bundle.</p>
         *        <p>
         *        Use the <code>GetDistributions</code> action to get a list of distribution names that you can specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionName(String distributionName);

        /**
         * <p>
         * The bundle ID of the new bundle to apply to your distribution.
         * </p>
         * <p>
         * Use the <code>GetDistributionBundles</code> action to get a list of distribution bundle IDs that you can
         * specify.
         * </p>
         * 
         * @param bundleId
         *        The bundle ID of the new bundle to apply to your distribution.</p>
         *        <p>
         *        Use the <code>GetDistributionBundles</code> action to get a list of distribution bundle IDs that you
         *        can specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String distributionName;

        private String bundleId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDistributionBundleRequest model) {
            super(model);
            distributionName(model.distributionName);
            bundleId(model.bundleId);
        }

        public final String getDistributionName() {
            return distributionName;
        }

        public final void setDistributionName(String distributionName) {
            this.distributionName = distributionName;
        }

        @Override
        public final Builder distributionName(String distributionName) {
            this.distributionName = distributionName;
            return this;
        }

        public final String getBundleId() {
            return bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDistributionBundleRequest build() {
            return new UpdateDistributionBundleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
