/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRelationalDatabaseRequest extends LightsailRequest implements
        ToCopyableBuilder<UpdateRelationalDatabaseRequest.Builder, UpdateRelationalDatabaseRequest> {
    private static final SdkField<String> RELATIONAL_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relationalDatabaseName").getter(getter(UpdateRelationalDatabaseRequest::relationalDatabaseName))
            .setter(setter(Builder::relationalDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseName").build())
            .build();

    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("masterUserPassword").getter(getter(UpdateRelationalDatabaseRequest::masterUserPassword))
            .setter(setter(Builder::masterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("masterUserPassword").build())
            .build();

    private static final SdkField<Boolean> ROTATE_MASTER_USER_PASSWORD_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("rotateMasterUserPassword")
            .getter(getter(UpdateRelationalDatabaseRequest::rotateMasterUserPassword))
            .setter(setter(Builder::rotateMasterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rotateMasterUserPassword").build())
            .build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("preferredBackupWindow").getter(getter(UpdateRelationalDatabaseRequest::preferredBackupWindow))
            .setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredBackupWindow").build())
            .build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("preferredMaintenanceWindow")
            .getter(getter(UpdateRelationalDatabaseRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Boolean> ENABLE_BACKUP_RETENTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableBackupRetention").getter(getter(UpdateRelationalDatabaseRequest::enableBackupRetention))
            .setter(setter(Builder::enableBackupRetention))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBackupRetention").build())
            .build();

    private static final SdkField<Boolean> DISABLE_BACKUP_RETENTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("disableBackupRetention").getter(getter(UpdateRelationalDatabaseRequest::disableBackupRetention))
            .setter(setter(Builder::disableBackupRetention))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableBackupRetention").build())
            .build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("publiclyAccessible").getter(getter(UpdateRelationalDatabaseRequest::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build())
            .build();

    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("applyImmediately").getter(getter(UpdateRelationalDatabaseRequest::applyImmediately))
            .setter(setter(Builder::applyImmediately))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyImmediately").build()).build();

    private static final SdkField<String> CA_CERTIFICATE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("caCertificateIdentifier").getter(getter(UpdateRelationalDatabaseRequest::caCertificateIdentifier))
            .setter(setter(Builder::caCertificateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caCertificateIdentifier").build())
            .build();

    private static final SdkField<String> RELATIONAL_DATABASE_BLUEPRINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("relationalDatabaseBlueprintId")
            .getter(getter(UpdateRelationalDatabaseRequest::relationalDatabaseBlueprintId))
            .setter(setter(Builder::relationalDatabaseBlueprintId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseBlueprintId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RELATIONAL_DATABASE_NAME_FIELD, MASTER_USER_PASSWORD_FIELD, ROTATE_MASTER_USER_PASSWORD_FIELD,
            PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, ENABLE_BACKUP_RETENTION_FIELD,
            DISABLE_BACKUP_RETENTION_FIELD, PUBLICLY_ACCESSIBLE_FIELD, APPLY_IMMEDIATELY_FIELD, CA_CERTIFICATE_IDENTIFIER_FIELD,
            RELATIONAL_DATABASE_BLUEPRINT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String relationalDatabaseName;

    private final String masterUserPassword;

    private final Boolean rotateMasterUserPassword;

    private final String preferredBackupWindow;

    private final String preferredMaintenanceWindow;

    private final Boolean enableBackupRetention;

    private final Boolean disableBackupRetention;

    private final Boolean publiclyAccessible;

    private final Boolean applyImmediately;

    private final String caCertificateIdentifier;

    private final String relationalDatabaseBlueprintId;

    private UpdateRelationalDatabaseRequest(BuilderImpl builder) {
        super(builder);
        this.relationalDatabaseName = builder.relationalDatabaseName;
        this.masterUserPassword = builder.masterUserPassword;
        this.rotateMasterUserPassword = builder.rotateMasterUserPassword;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.enableBackupRetention = builder.enableBackupRetention;
        this.disableBackupRetention = builder.disableBackupRetention;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.applyImmediately = builder.applyImmediately;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
        this.relationalDatabaseBlueprintId = builder.relationalDatabaseBlueprintId;
    }

    /**
     * <p>
     * The name of your Lightsail database resource to update.
     * </p>
     * 
     * @return The name of your Lightsail database resource to update.
     */
    public final String relationalDatabaseName() {
        return relationalDatabaseName;
    }

    /**
     * <p>
     * The password for the master user. The password can include any printable ASCII character except "/", """, or "@".
     * </p>
     * <p>
     * My<b>SQL</b>
     * </p>
     * <p>
     * Constraints: Must contain from 8 to 41 characters.
     * </p>
     * <p>
     * <b>PostgreSQL</b>
     * </p>
     * <p>
     * Constraints: Must contain from 8 to 128 characters.
     * </p>
     * 
     * @return The password for the master user. The password can include any printable ASCII character except "/",
     *         """, or "@".</p>
     *         <p>
     *         My<b>SQL</b>
     *         </p>
     *         <p>
     *         Constraints: Must contain from 8 to 41 characters.
     *         </p>
     *         <p>
     *         <b>PostgreSQL</b>
     *         </p>
     *         <p>
     *         Constraints: Must contain from 8 to 128 characters.
     */
    public final String masterUserPassword() {
        return masterUserPassword;
    }

    /**
     * <p>
     * When <code>true</code>, the master user password is changed to a new strong password generated by Lightsail.
     * </p>
     * <p>
     * Use the <code>get relational database master user password</code> operation to get the new password.
     * </p>
     * 
     * @return When <code>true</code>, the master user password is changed to a new strong password generated by
     *         Lightsail.</p>
     *         <p>
     *         Use the <code>get relational database master user password</code> operation to get the new password.
     */
    public final Boolean rotateMasterUserPassword() {
        return rotateMasterUserPassword;
    }

    /**
     * <p>
     * The daily time range during which automated backups are created for your database if automated backups are
     * enabled.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the <code>hh24:mi-hh24:mi</code> format.
     * </p>
     * <p>
     * Example: <code>16:00-16:30</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in Coordinated Universal Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not conflict with the preferred maintenance window.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The daily time range during which automated backups are created for your database if automated backups
     *         are enabled.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the <code>hh24:mi-hh24:mi</code> format.
     *         </p>
     *         <p>
     *         Example: <code>16:00-16:30</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specified in Coordinated Universal Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must not conflict with the preferred maintenance window.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 30 minutes.
     *         </p>
     *         </li>
     */
    public final String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * <p>
     * The weekly time range during which system maintenance can occur on your database.
     * </p>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services
     * Region, occurring on a random day of the week.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.
     * </p>
     * </li>
     * <li>
     * <p>
     * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in Coordinated Universal Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Example: <code>Tue:17:00-Tue:17:30</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The weekly time range during which system maintenance can occur on your database.</p>
     *         <p>
     *         The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
     *         Services Region, occurring on a random day of the week.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 30 minutes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specified in Coordinated Universal Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Example: <code>Tue:17:00-Tue:17:30</code>
     *         </p>
     *         </li>
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * When <code>true</code>, enables automated backup retention for your database.
     * </p>
     * <p>
     * Updates are applied during the next maintenance window because this can result in an outage.
     * </p>
     * 
     * @return When <code>true</code>, enables automated backup retention for your database.</p>
     *         <p>
     *         Updates are applied during the next maintenance window because this can result in an outage.
     */
    public final Boolean enableBackupRetention() {
        return enableBackupRetention;
    }

    /**
     * <p>
     * When <code>true</code>, disables automated backup retention for your database.
     * </p>
     * <p>
     * Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create
     * a snapshot of your database using the <code>create relational database snapshot</code> operation.
     * </p>
     * <p>
     * Updates are applied during the next maintenance window because this can result in an outage.
     * </p>
     * 
     * @return When <code>true</code>, disables automated backup retention for your database.</p>
     *         <p>
     *         Disabling backup retention deletes all automated database backups. Before disabling this, you may want to
     *         create a snapshot of your database using the <code>create relational database snapshot</code> operation.
     *         </p>
     *         <p>
     *         Updates are applied during the next maintenance window because this can result in an outage.
     */
    public final Boolean disableBackupRetention() {
        return disableBackupRetention;
    }

    /**
     * <p>
     * Specifies the accessibility options for your database. A value of <code>true</code> specifies a database that is
     * available to resources outside of your Lightsail account. A value of <code>false</code> specifies a database that
     * is available only to your Lightsail resources in the same region as your database.
     * </p>
     * 
     * @return Specifies the accessibility options for your database. A value of <code>true</code> specifies a database
     *         that is available to resources outside of your Lightsail account. A value of <code>false</code> specifies
     *         a database that is available only to your Lightsail resources in the same region as your database.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * <p>
     * When <code>true</code>, applies changes immediately. When <code>false</code>, applies changes during the
     * preferred maintenance window. Some changes may cause an outage.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return When <code>true</code>, applies changes immediately. When <code>false</code>, applies changes during the
     *         preferred maintenance window. Some changes may cause an outage.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean applyImmediately() {
        return applyImmediately;
    }

    /**
     * <p>
     * Indicates the certificate that needs to be associated with the database.
     * </p>
     * 
     * @return Indicates the certificate that needs to be associated with the database.
     */
    public final String caCertificateIdentifier() {
        return caCertificateIdentifier;
    }

    /**
     * <p>
     * This parameter is used to update the major version of the database. Enter the <code>blueprintId</code> for the
     * major version that you want to update to.
     * </p>
     * <p>
     * Use the <a
     * href="https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRelationalDatabaseBlueprints.html"
     * >GetRelationalDatabaseBlueprints</a> action to get a list of available blueprint IDs.
     * </p>
     * 
     * @return This parameter is used to update the major version of the database. Enter the <code>blueprintId</code>
     *         for the major version that you want to update to.</p>
     *         <p>
     *         Use the <a href=
     *         "https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRelationalDatabaseBlueprints.html"
     *         >GetRelationalDatabaseBlueprints</a> action to get a list of available blueprint IDs.
     */
    public final String relationalDatabaseBlueprintId() {
        return relationalDatabaseBlueprintId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(relationalDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(rotateMasterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(enableBackupRetention());
        hashCode = 31 * hashCode + Objects.hashCode(disableBackupRetention());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(relationalDatabaseBlueprintId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRelationalDatabaseRequest)) {
            return false;
        }
        UpdateRelationalDatabaseRequest other = (UpdateRelationalDatabaseRequest) obj;
        return Objects.equals(relationalDatabaseName(), other.relationalDatabaseName())
                && Objects.equals(masterUserPassword(), other.masterUserPassword())
                && Objects.equals(rotateMasterUserPassword(), other.rotateMasterUserPassword())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(enableBackupRetention(), other.enableBackupRetention())
                && Objects.equals(disableBackupRetention(), other.disableBackupRetention())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && Objects.equals(applyImmediately(), other.applyImmediately())
                && Objects.equals(caCertificateIdentifier(), other.caCertificateIdentifier())
                && Objects.equals(relationalDatabaseBlueprintId(), other.relationalDatabaseBlueprintId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRelationalDatabaseRequest").add("RelationalDatabaseName", relationalDatabaseName())
                .add("MasterUserPassword", masterUserPassword() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RotateMasterUserPassword", rotateMasterUserPassword())
                .add("PreferredBackupWindow", preferredBackupWindow())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("EnableBackupRetention", enableBackupRetention()).add("DisableBackupRetention", disableBackupRetention())
                .add("PubliclyAccessible", publiclyAccessible()).add("ApplyImmediately", applyImmediately())
                .add("CaCertificateIdentifier", caCertificateIdentifier())
                .add("RelationalDatabaseBlueprintId", relationalDatabaseBlueprintId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relationalDatabaseName":
            return Optional.ofNullable(clazz.cast(relationalDatabaseName()));
        case "masterUserPassword":
            return Optional.ofNullable(clazz.cast(masterUserPassword()));
        case "rotateMasterUserPassword":
            return Optional.ofNullable(clazz.cast(rotateMasterUserPassword()));
        case "preferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "preferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "enableBackupRetention":
            return Optional.ofNullable(clazz.cast(enableBackupRetention()));
        case "disableBackupRetention":
            return Optional.ofNullable(clazz.cast(disableBackupRetention()));
        case "publiclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "applyImmediately":
            return Optional.ofNullable(clazz.cast(applyImmediately()));
        case "caCertificateIdentifier":
            return Optional.ofNullable(clazz.cast(caCertificateIdentifier()));
        case "relationalDatabaseBlueprintId":
            return Optional.ofNullable(clazz.cast(relationalDatabaseBlueprintId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("relationalDatabaseName", RELATIONAL_DATABASE_NAME_FIELD);
        map.put("masterUserPassword", MASTER_USER_PASSWORD_FIELD);
        map.put("rotateMasterUserPassword", ROTATE_MASTER_USER_PASSWORD_FIELD);
        map.put("preferredBackupWindow", PREFERRED_BACKUP_WINDOW_FIELD);
        map.put("preferredMaintenanceWindow", PREFERRED_MAINTENANCE_WINDOW_FIELD);
        map.put("enableBackupRetention", ENABLE_BACKUP_RETENTION_FIELD);
        map.put("disableBackupRetention", DISABLE_BACKUP_RETENTION_FIELD);
        map.put("publiclyAccessible", PUBLICLY_ACCESSIBLE_FIELD);
        map.put("applyImmediately", APPLY_IMMEDIATELY_FIELD);
        map.put("caCertificateIdentifier", CA_CERTIFICATE_IDENTIFIER_FIELD);
        map.put("relationalDatabaseBlueprintId", RELATIONAL_DATABASE_BLUEPRINT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRelationalDatabaseRequest, T> g) {
        return obj -> g.apply((UpdateRelationalDatabaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRelationalDatabaseRequest> {
        /**
         * <p>
         * The name of your Lightsail database resource to update.
         * </p>
         * 
         * @param relationalDatabaseName
         *        The name of your Lightsail database resource to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseName(String relationalDatabaseName);

        /**
         * <p>
         * The password for the master user. The password can include any printable ASCII character except "/",
         * """, or "@".
         * </p>
         * <p>
         * My<b>SQL</b>
         * </p>
         * <p>
         * Constraints: Must contain from 8 to 41 characters.
         * </p>
         * <p>
         * <b>PostgreSQL</b>
         * </p>
         * <p>
         * Constraints: Must contain from 8 to 128 characters.
         * </p>
         * 
         * @param masterUserPassword
         *        The password for the master user. The password can include any printable ASCII character except "/",
         *        """, or "@".</p>
         *        <p>
         *        My<b>SQL</b>
         *        </p>
         *        <p>
         *        Constraints: Must contain from 8 to 41 characters.
         *        </p>
         *        <p>
         *        <b>PostgreSQL</b>
         *        </p>
         *        <p>
         *        Constraints: Must contain from 8 to 128 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserPassword(String masterUserPassword);

        /**
         * <p>
         * When <code>true</code>, the master user password is changed to a new strong password generated by Lightsail.
         * </p>
         * <p>
         * Use the <code>get relational database master user password</code> operation to get the new password.
         * </p>
         * 
         * @param rotateMasterUserPassword
         *        When <code>true</code>, the master user password is changed to a new strong password generated by
         *        Lightsail.</p>
         *        <p>
         *        Use the <code>get relational database master user password</code> operation to get the new password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotateMasterUserPassword(Boolean rotateMasterUserPassword);

        /**
         * <p>
         * The daily time range during which automated backups are created for your database if automated backups are
         * enabled.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the <code>hh24:mi-hh24:mi</code> format.
         * </p>
         * <p>
         * Example: <code>16:00-16:30</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Specified in Coordinated Universal Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Must not conflict with the preferred maintenance window.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 30 minutes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param preferredBackupWindow
         *        The daily time range during which automated backups are created for your database if automated backups
         *        are enabled.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the <code>hh24:mi-hh24:mi</code> format.
         *        </p>
         *        <p>
         *        Example: <code>16:00-16:30</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Specified in Coordinated Universal Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must not conflict with the preferred maintenance window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 30 minutes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * The weekly time range during which system maintenance can occur on your database.
         * </p>
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
         * Services Region, occurring on a random day of the week.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 30 minutes.
         * </p>
         * </li>
         * <li>
         * <p>
         * Specified in Coordinated Universal Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Example: <code>Tue:17:00-Tue:17:30</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range during which system maintenance can occur on your database.</p>
         *        <p>
         *        The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
         *        Services Region, occurring on a random day of the week.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 30 minutes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Specified in Coordinated Universal Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Example: <code>Tue:17:00-Tue:17:30</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * When <code>true</code>, enables automated backup retention for your database.
         * </p>
         * <p>
         * Updates are applied during the next maintenance window because this can result in an outage.
         * </p>
         * 
         * @param enableBackupRetention
         *        When <code>true</code>, enables automated backup retention for your database.</p>
         *        <p>
         *        Updates are applied during the next maintenance window because this can result in an outage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableBackupRetention(Boolean enableBackupRetention);

        /**
         * <p>
         * When <code>true</code>, disables automated backup retention for your database.
         * </p>
         * <p>
         * Disabling backup retention deletes all automated database backups. Before disabling this, you may want to
         * create a snapshot of your database using the <code>create relational database snapshot</code> operation.
         * </p>
         * <p>
         * Updates are applied during the next maintenance window because this can result in an outage.
         * </p>
         * 
         * @param disableBackupRetention
         *        When <code>true</code>, disables automated backup retention for your database.</p>
         *        <p>
         *        Disabling backup retention deletes all automated database backups. Before disabling this, you may want
         *        to create a snapshot of your database using the <code>create relational database snapshot</code>
         *        operation.
         *        </p>
         *        <p>
         *        Updates are applied during the next maintenance window because this can result in an outage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableBackupRetention(Boolean disableBackupRetention);

        /**
         * <p>
         * Specifies the accessibility options for your database. A value of <code>true</code> specifies a database that
         * is available to resources outside of your Lightsail account. A value of <code>false</code> specifies a
         * database that is available only to your Lightsail resources in the same region as your database.
         * </p>
         * 
         * @param publiclyAccessible
         *        Specifies the accessibility options for your database. A value of <code>true</code> specifies a
         *        database that is available to resources outside of your Lightsail account. A value of
         *        <code>false</code> specifies a database that is available only to your Lightsail resources in the same
         *        region as your database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * When <code>true</code>, applies changes immediately. When <code>false</code>, applies changes during the
         * preferred maintenance window. Some changes may cause an outage.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param applyImmediately
         *        When <code>true</code>, applies changes immediately. When <code>false</code>, applies changes during
         *        the preferred maintenance window. Some changes may cause an outage.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyImmediately(Boolean applyImmediately);

        /**
         * <p>
         * Indicates the certificate that needs to be associated with the database.
         * </p>
         * 
         * @param caCertificateIdentifier
         *        Indicates the certificate that needs to be associated with the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificateIdentifier(String caCertificateIdentifier);

        /**
         * <p>
         * This parameter is used to update the major version of the database. Enter the <code>blueprintId</code> for
         * the major version that you want to update to.
         * </p>
         * <p>
         * Use the <a href=
         * "https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRelationalDatabaseBlueprints.html"
         * >GetRelationalDatabaseBlueprints</a> action to get a list of available blueprint IDs.
         * </p>
         * 
         * @param relationalDatabaseBlueprintId
         *        This parameter is used to update the major version of the database. Enter the <code>blueprintId</code>
         *        for the major version that you want to update to.</p>
         *        <p>
         *        Use the <a href=
         *        "https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRelationalDatabaseBlueprints.html"
         *        >GetRelationalDatabaseBlueprints</a> action to get a list of available blueprint IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseBlueprintId(String relationalDatabaseBlueprintId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String relationalDatabaseName;

        private String masterUserPassword;

        private Boolean rotateMasterUserPassword;

        private String preferredBackupWindow;

        private String preferredMaintenanceWindow;

        private Boolean enableBackupRetention;

        private Boolean disableBackupRetention;

        private Boolean publiclyAccessible;

        private Boolean applyImmediately;

        private String caCertificateIdentifier;

        private String relationalDatabaseBlueprintId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRelationalDatabaseRequest model) {
            super(model);
            relationalDatabaseName(model.relationalDatabaseName);
            masterUserPassword(model.masterUserPassword);
            rotateMasterUserPassword(model.rotateMasterUserPassword);
            preferredBackupWindow(model.preferredBackupWindow);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            enableBackupRetention(model.enableBackupRetention);
            disableBackupRetention(model.disableBackupRetention);
            publiclyAccessible(model.publiclyAccessible);
            applyImmediately(model.applyImmediately);
            caCertificateIdentifier(model.caCertificateIdentifier);
            relationalDatabaseBlueprintId(model.relationalDatabaseBlueprintId);
        }

        public final String getRelationalDatabaseName() {
            return relationalDatabaseName;
        }

        public final void setRelationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
        }

        @Override
        public final Builder relationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
            return this;
        }

        public final String getMasterUserPassword() {
            return masterUserPassword;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final Boolean getRotateMasterUserPassword() {
            return rotateMasterUserPassword;
        }

        public final void setRotateMasterUserPassword(Boolean rotateMasterUserPassword) {
            this.rotateMasterUserPassword = rotateMasterUserPassword;
        }

        @Override
        public final Builder rotateMasterUserPassword(Boolean rotateMasterUserPassword) {
            this.rotateMasterUserPassword = rotateMasterUserPassword;
            return this;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Boolean getEnableBackupRetention() {
            return enableBackupRetention;
        }

        public final void setEnableBackupRetention(Boolean enableBackupRetention) {
            this.enableBackupRetention = enableBackupRetention;
        }

        @Override
        public final Builder enableBackupRetention(Boolean enableBackupRetention) {
            this.enableBackupRetention = enableBackupRetention;
            return this;
        }

        public final Boolean getDisableBackupRetention() {
            return disableBackupRetention;
        }

        public final void setDisableBackupRetention(Boolean disableBackupRetention) {
            this.disableBackupRetention = disableBackupRetention;
        }

        @Override
        public final Builder disableBackupRetention(Boolean disableBackupRetention) {
            this.disableBackupRetention = disableBackupRetention;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final Boolean getApplyImmediately() {
            return applyImmediately;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final String getCaCertificateIdentifier() {
            return caCertificateIdentifier;
        }

        public final void setCaCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        @Override
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final String getRelationalDatabaseBlueprintId() {
            return relationalDatabaseBlueprintId;
        }

        public final void setRelationalDatabaseBlueprintId(String relationalDatabaseBlueprintId) {
            this.relationalDatabaseBlueprintId = relationalDatabaseBlueprintId;
        }

        @Override
        public final Builder relationalDatabaseBlueprintId(String relationalDatabaseBlueprintId) {
            this.relationalDatabaseBlueprintId = relationalDatabaseBlueprintId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRelationalDatabaseRequest build() {
            return new UpdateRelationalDatabaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
