/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.LogEvent;
import software.amazon.awssdk.services.lightsail.model.LogEventListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRelationalDatabaseLogEventsResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetRelationalDatabaseLogEventsResponse> {
    private static final SdkField<List<LogEvent>> RESOURCE_LOG_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceLogEvents").getter(GetRelationalDatabaseLogEventsResponse.getter(GetRelationalDatabaseLogEventsResponse::resourceLogEvents)).setter(GetRelationalDatabaseLogEventsResponse.setter(Builder::resourceLogEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceLogEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_BACKWARD_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextBackwardToken").getter(GetRelationalDatabaseLogEventsResponse.getter(GetRelationalDatabaseLogEventsResponse::nextBackwardToken)).setter(GetRelationalDatabaseLogEventsResponse.setter(Builder::nextBackwardToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextBackwardToken").build()}).build();
    private static final SdkField<String> NEXT_FORWARD_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextForwardToken").getter(GetRelationalDatabaseLogEventsResponse.getter(GetRelationalDatabaseLogEventsResponse::nextForwardToken)).setter(GetRelationalDatabaseLogEventsResponse.setter(Builder::nextForwardToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextForwardToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_LOG_EVENTS_FIELD, NEXT_BACKWARD_TOKEN_FIELD, NEXT_FORWARD_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRelationalDatabaseLogEventsResponse.memberNameToFieldInitializer();
    private final List<LogEvent> resourceLogEvents;
    private final String nextBackwardToken;
    private final String nextForwardToken;

    private GetRelationalDatabaseLogEventsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceLogEvents = builder.resourceLogEvents;
        this.nextBackwardToken = builder.nextBackwardToken;
        this.nextForwardToken = builder.nextForwardToken;
    }

    public final boolean hasResourceLogEvents() {
        return this.resourceLogEvents != null && !(this.resourceLogEvents instanceof SdkAutoConstructList);
    }

    public final List<LogEvent> resourceLogEvents() {
        return this.resourceLogEvents;
    }

    public final String nextBackwardToken() {
        return this.nextBackwardToken;
    }

    public final String nextForwardToken() {
        return this.nextForwardToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceLogEvents() ? this.resourceLogEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextBackwardToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextForwardToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabaseLogEventsResponse)) {
            return false;
        }
        GetRelationalDatabaseLogEventsResponse other = (GetRelationalDatabaseLogEventsResponse)((Object)obj);
        return this.hasResourceLogEvents() == other.hasResourceLogEvents() && Objects.equals(this.resourceLogEvents(), other.resourceLogEvents()) && Objects.equals(this.nextBackwardToken(), other.nextBackwardToken()) && Objects.equals(this.nextForwardToken(), other.nextForwardToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetRelationalDatabaseLogEventsResponse").add("ResourceLogEvents", this.hasResourceLogEvents() ? this.resourceLogEvents() : null).add("NextBackwardToken", (Object)this.nextBackwardToken()).add("NextForwardToken", (Object)this.nextForwardToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceLogEvents": {
                return Optional.ofNullable(clazz.cast(this.resourceLogEvents()));
            }
            case "nextBackwardToken": {
                return Optional.ofNullable(clazz.cast(this.nextBackwardToken()));
            }
            case "nextForwardToken": {
                return Optional.ofNullable(clazz.cast(this.nextForwardToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceLogEvents", RESOURCE_LOG_EVENTS_FIELD);
        map.put("nextBackwardToken", NEXT_BACKWARD_TOKEN_FIELD);
        map.put("nextForwardToken", NEXT_FORWARD_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRelationalDatabaseLogEventsResponse, T> g) {
        return obj -> g.apply((GetRelationalDatabaseLogEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<LogEvent> resourceLogEvents = DefaultSdkAutoConstructList.getInstance();
        private String nextBackwardToken;
        private String nextForwardToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationalDatabaseLogEventsResponse model) {
            super(model);
            this.resourceLogEvents(model.resourceLogEvents);
            this.nextBackwardToken(model.nextBackwardToken);
            this.nextForwardToken(model.nextForwardToken);
        }

        public final List<LogEvent.Builder> getResourceLogEvents() {
            List<LogEvent.Builder> result = LogEventListCopier.copyToBuilder(this.resourceLogEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceLogEvents(Collection<LogEvent.BuilderImpl> resourceLogEvents) {
            this.resourceLogEvents = LogEventListCopier.copyFromBuilder(resourceLogEvents);
        }

        @Override
        public final Builder resourceLogEvents(Collection<LogEvent> resourceLogEvents) {
            this.resourceLogEvents = LogEventListCopier.copy(resourceLogEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceLogEvents(LogEvent ... resourceLogEvents) {
            this.resourceLogEvents(Arrays.asList(resourceLogEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceLogEvents(Consumer<LogEvent.Builder> ... resourceLogEvents) {
            this.resourceLogEvents(Stream.of(resourceLogEvents).map(c -> (LogEvent)((LogEvent.Builder)LogEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextBackwardToken() {
            return this.nextBackwardToken;
        }

        public final void setNextBackwardToken(String nextBackwardToken) {
            this.nextBackwardToken = nextBackwardToken;
        }

        @Override
        public final Builder nextBackwardToken(String nextBackwardToken) {
            this.nextBackwardToken = nextBackwardToken;
            return this;
        }

        public final String getNextForwardToken() {
            return this.nextForwardToken;
        }

        public final void setNextForwardToken(String nextForwardToken) {
            this.nextForwardToken = nextForwardToken;
        }

        @Override
        public final Builder nextForwardToken(String nextForwardToken) {
            this.nextForwardToken = nextForwardToken;
            return this;
        }

        @Override
        public GetRelationalDatabaseLogEventsResponse build() {
            return new GetRelationalDatabaseLogEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRelationalDatabaseLogEventsResponse> {
        public Builder resourceLogEvents(Collection<LogEvent> var1);

        public Builder resourceLogEvents(LogEvent ... var1);

        public Builder resourceLogEvents(Consumer<LogEvent.Builder> ... var1);

        public Builder nextBackwardToken(String var1);

        public Builder nextForwardToken(String var1);
    }
}

