/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.SetupExecutionDetails;
import software.amazon.awssdk.services.lightsail.model.SetupExecutionDetailsListCopier;
import software.amazon.awssdk.services.lightsail.model.SetupHistoryResource;
import software.amazon.awssdk.services.lightsail.model.SetupRequest;
import software.amazon.awssdk.services.lightsail.model.SetupStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetupHistory
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SetupHistory> {
    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operationId").getter(SetupHistory.getter(SetupHistory::operationId)).setter(SetupHistory.setter(Builder::operationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationId").build()}).build();
    private static final SdkField<SetupRequest> REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("request").getter(SetupHistory.getter(SetupHistory::request)).setter(SetupHistory.setter(Builder::request)).constructor(SetupRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("request").build()}).build();
    private static final SdkField<SetupHistoryResource> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resource").getter(SetupHistory.getter(SetupHistory::resource)).setter(SetupHistory.setter(Builder::resource)).constructor(SetupHistoryResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<List<SetupExecutionDetails>> EXECUTION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("executionDetails").getter(SetupHistory.getter(SetupHistory::executionDetails)).setter(SetupHistory.setter(Builder::executionDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SetupExecutionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(SetupHistory.getter(SetupHistory::statusAsString)).setter(SetupHistory.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_ID_FIELD, REQUEST_FIELD, RESOURCE_FIELD, EXECUTION_DETAILS_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SetupHistory.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String operationId;
    private final SetupRequest request;
    private final SetupHistoryResource resource;
    private final List<SetupExecutionDetails> executionDetails;
    private final String status;

    private SetupHistory(BuilderImpl builder) {
        this.operationId = builder.operationId;
        this.request = builder.request;
        this.resource = builder.resource;
        this.executionDetails = builder.executionDetails;
        this.status = builder.status;
    }

    public final String operationId() {
        return this.operationId;
    }

    public final SetupRequest request() {
        return this.request;
    }

    public final SetupHistoryResource resource() {
        return this.resource;
    }

    public final boolean hasExecutionDetails() {
        return this.executionDetails != null && !(this.executionDetails instanceof SdkAutoConstructList);
    }

    public final List<SetupExecutionDetails> executionDetails() {
        return this.executionDetails;
    }

    public final SetupStatus status() {
        return SetupStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.request());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExecutionDetails() ? this.executionDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetupHistory)) {
            return false;
        }
        SetupHistory other = (SetupHistory)obj;
        return Objects.equals(this.operationId(), other.operationId()) && Objects.equals(this.request(), other.request()) && Objects.equals(this.resource(), other.resource()) && this.hasExecutionDetails() == other.hasExecutionDetails() && Objects.equals(this.executionDetails(), other.executionDetails()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SetupHistory").add("OperationId", (Object)this.operationId()).add("Request", (Object)this.request()).add("Resource", (Object)this.resource()).add("ExecutionDetails", this.hasExecutionDetails() ? this.executionDetails() : null).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "operationId": {
                return Optional.ofNullable(clazz.cast(this.operationId()));
            }
            case "request": {
                return Optional.ofNullable(clazz.cast(this.request()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "executionDetails": {
                return Optional.ofNullable(clazz.cast(this.executionDetails()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("operationId", OPERATION_ID_FIELD);
        map.put("request", REQUEST_FIELD);
        map.put("resource", RESOURCE_FIELD);
        map.put("executionDetails", EXECUTION_DETAILS_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetupHistory, T> g) {
        return obj -> g.apply((SetupHistory)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String operationId;
        private SetupRequest request;
        private SetupHistoryResource resource;
        private List<SetupExecutionDetails> executionDetails = DefaultSdkAutoConstructList.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SetupHistory model) {
            this.operationId(model.operationId);
            this.request(model.request);
            this.resource(model.resource);
            this.executionDetails(model.executionDetails);
            this.status(model.status);
        }

        public final String getOperationId() {
            return this.operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final SetupRequest.Builder getRequest() {
            return this.request != null ? this.request.toBuilder() : null;
        }

        public final void setRequest(SetupRequest.BuilderImpl request) {
            this.request = request != null ? request.build() : null;
        }

        @Override
        public final Builder request(SetupRequest request) {
            this.request = request;
            return this;
        }

        public final SetupHistoryResource.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        public final void setResource(SetupHistoryResource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(SetupHistoryResource resource) {
            this.resource = resource;
            return this;
        }

        public final List<SetupExecutionDetails.Builder> getExecutionDetails() {
            List<SetupExecutionDetails.Builder> result = SetupExecutionDetailsListCopier.copyToBuilder(this.executionDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExecutionDetails(Collection<SetupExecutionDetails.BuilderImpl> executionDetails) {
            this.executionDetails = SetupExecutionDetailsListCopier.copyFromBuilder(executionDetails);
        }

        @Override
        public final Builder executionDetails(Collection<SetupExecutionDetails> executionDetails) {
            this.executionDetails = SetupExecutionDetailsListCopier.copy(executionDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionDetails(SetupExecutionDetails ... executionDetails) {
            this.executionDetails(Arrays.asList(executionDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionDetails(Consumer<SetupExecutionDetails.Builder> ... executionDetails) {
            this.executionDetails(Stream.of(executionDetails).map(c -> (SetupExecutionDetails)((SetupExecutionDetails.Builder)SetupExecutionDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SetupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public SetupHistory build() {
            return new SetupHistory(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SetupHistory> {
        public Builder operationId(String var1);

        public Builder request(SetupRequest var1);

        default public Builder request(Consumer<SetupRequest.Builder> request) {
            return this.request((SetupRequest)((SetupRequest.Builder)SetupRequest.builder().applyMutation(request)).build());
        }

        public Builder resource(SetupHistoryResource var1);

        default public Builder resource(Consumer<SetupHistoryResource.Builder> resource) {
            return this.resource((SetupHistoryResource)((SetupHistoryResource.Builder)SetupHistoryResource.builder().applyMutation(resource)).build());
        }

        public Builder executionDetails(Collection<SetupExecutionDetails> var1);

        public Builder executionDetails(SetupExecutionDetails ... var1);

        public Builder executionDetails(Consumer<SetupExecutionDetails.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(SetupStatus var1);
    }
}

