/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.SetupStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetupExecutionDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SetupExecutionDetails> {
    private static final SdkField<String> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("command").getter(SetupExecutionDetails.getter(SetupExecutionDetails::command)).setter(SetupExecutionDetails.setter(Builder::command)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build()}).build();
    private static final SdkField<Instant> DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("dateTime").getter(SetupExecutionDetails.getter(SetupExecutionDetails::dateTime)).setter(SetupExecutionDetails.setter(Builder::dateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(SetupExecutionDetails.getter(SetupExecutionDetails::name)).setter(SetupExecutionDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(SetupExecutionDetails.getter(SetupExecutionDetails::statusAsString)).setter(SetupExecutionDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STANDARD_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("standardError").getter(SetupExecutionDetails.getter(SetupExecutionDetails::standardError)).setter(SetupExecutionDetails.setter(Builder::standardError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standardError").build()}).build();
    private static final SdkField<String> STANDARD_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("standardOutput").getter(SetupExecutionDetails.getter(SetupExecutionDetails::standardOutput)).setter(SetupExecutionDetails.setter(Builder::standardOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standardOutput").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(SetupExecutionDetails.getter(SetupExecutionDetails::version)).setter(SetupExecutionDetails.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_FIELD, DATE_TIME_FIELD, NAME_FIELD, STATUS_FIELD, STANDARD_ERROR_FIELD, STANDARD_OUTPUT_FIELD, VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SetupExecutionDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String command;
    private final Instant dateTime;
    private final String name;
    private final String status;
    private final String standardError;
    private final String standardOutput;
    private final String version;

    private SetupExecutionDetails(BuilderImpl builder) {
        this.command = builder.command;
        this.dateTime = builder.dateTime;
        this.name = builder.name;
        this.status = builder.status;
        this.standardError = builder.standardError;
        this.standardOutput = builder.standardOutput;
        this.version = builder.version;
    }

    public final String command() {
        return this.command;
    }

    public final Instant dateTime() {
        return this.dateTime;
    }

    public final String name() {
        return this.name;
    }

    public final SetupStatus status() {
        return SetupStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String standardError() {
        return this.standardError;
    }

    public final String standardOutput() {
        return this.standardOutput;
    }

    public final String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.command());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardError());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetupExecutionDetails)) {
            return false;
        }
        SetupExecutionDetails other = (SetupExecutionDetails)obj;
        return Objects.equals(this.command(), other.command()) && Objects.equals(this.dateTime(), other.dateTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.standardError(), other.standardError()) && Objects.equals(this.standardOutput(), other.standardOutput()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"SetupExecutionDetails").add("Command", (Object)this.command()).add("DateTime", (Object)this.dateTime()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("StandardError", (Object)this.standardError()).add("StandardOutput", (Object)this.standardOutput()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "dateTime": {
                return Optional.ofNullable(clazz.cast(this.dateTime()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "standardError": {
                return Optional.ofNullable(clazz.cast(this.standardError()));
            }
            case "standardOutput": {
                return Optional.ofNullable(clazz.cast(this.standardOutput()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("command", COMMAND_FIELD);
        map.put("dateTime", DATE_TIME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("standardError", STANDARD_ERROR_FIELD);
        map.put("standardOutput", STANDARD_OUTPUT_FIELD);
        map.put("version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetupExecutionDetails, T> g) {
        return obj -> g.apply((SetupExecutionDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String command;
        private Instant dateTime;
        private String name;
        private String status;
        private String standardError;
        private String standardOutput;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(SetupExecutionDetails model) {
            this.command(model.command);
            this.dateTime(model.dateTime);
            this.name(model.name);
            this.status(model.status);
            this.standardError(model.standardError);
            this.standardOutput(model.standardOutput);
            this.version(model.version);
        }

        public final String getCommand() {
            return this.command;
        }

        public final void setCommand(String command) {
            this.command = command;
        }

        @Override
        public final Builder command(String command) {
            this.command = command;
            return this;
        }

        public final Instant getDateTime() {
            return this.dateTime;
        }

        public final void setDateTime(Instant dateTime) {
            this.dateTime = dateTime;
        }

        @Override
        public final Builder dateTime(Instant dateTime) {
            this.dateTime = dateTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SetupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStandardError() {
            return this.standardError;
        }

        public final void setStandardError(String standardError) {
            this.standardError = standardError;
        }

        @Override
        public final Builder standardError(String standardError) {
            this.standardError = standardError;
            return this;
        }

        public final String getStandardOutput() {
            return this.standardOutput;
        }

        public final void setStandardOutput(String standardOutput) {
            this.standardOutput = standardOutput;
        }

        @Override
        public final Builder standardOutput(String standardOutput) {
            this.standardOutput = standardOutput;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public SetupExecutionDetails build() {
            return new SetupExecutionDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SetupExecutionDetails> {
        public Builder command(String var1);

        public Builder dateTime(Instant var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(SetupStatus var1);

        public Builder standardError(String var1);

        public Builder standardOutput(String var1);

        public Builder version(String var1);
    }
}

